/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.api;

import com.hulaki.smtp.api.ApiCommand;
import com.hulaki.smtp.api.ApiRequest;
import com.hulaki.smtp.exceptions.ApiProtocolException;
import com.hulaki.smtp.utils.EmailUtils;

public class CountRequest
extends ApiRequest {
    private String recipient;

    public CountRequest(String requestBody) throws ApiProtocolException {
        super(requestBody, ApiCommand.COUNT);
        String[] tokens = requestBody.split(" ");
        if (tokens.length == 2) {
            this.recipient = EmailUtils.normalizeEmailAddress(tokens[1]);
        } else if (tokens.length > 2) {
            throw new ApiProtocolException("The count request should be in format COUNT [<email-address>]");
        }
    }

    public CountRequest() {
        super(ApiCommand.COUNT);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public CountRequest setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Override
    public String toRequestString() {
        if (this.recipient != null) {
            return this.getCommand().toString() + " " + this.recipient;
        }
        return this.getCommand().toString();
    }
}

