/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.api;

import com.hulaki.smtp.api.ApiCommand;
import com.hulaki.smtp.api.ApiRequest;
import com.hulaki.smtp.api.RelayMode;
import com.hulaki.smtp.exceptions.ApiProtocolException;
import com.hulaki.smtp.utils.EmailUtils;
import org.apache.commons.lang3.StringUtils;

public class RelayRequest
extends ApiRequest {
    private final RelayMode relayMode;
    private String recipient;

    public RelayRequest(RelayMode relayMode) {
        super(ApiCommand.RELAY);
        this.relayMode = relayMode;
    }

    public RelayRequest(String requestBody) throws ApiProtocolException {
        super(requestBody, ApiCommand.RELAY);
        String[] tokens = requestBody.split(" ");
        if (tokens.length == 2) {
            this.relayMode = RelayMode.parse(tokens[1]);
        } else if (tokens.length == 3) {
            this.relayMode = RelayMode.parse(tokens[1]);
            this.recipient = EmailUtils.normalizeEmailAddress(tokens[2]);
        } else {
            throw new ApiProtocolException("Invalid format. Should be in format: " + ApiCommand.RELAY.toString() + " [" + StringUtils.join((Object[])RelayMode.all(), (String)"|") + "] [email-address]");
        }
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public RelayMode getRelayMode() {
        return this.relayMode;
    }

    @Override
    public String toRequestString() {
        StringBuilder request = new StringBuilder(ApiCommand.RELAY.toString());
        request.append(" ").append((Object)this.relayMode);
        if (this.recipient != null) {
            request.append(" ").append(this.recipient);
        }
        return request.toString();
    }
}

