/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.api;

import com.hulaki.smtp.api.ApiCommand;
import com.hulaki.smtp.api.ApiRequest;
import com.hulaki.smtp.api.ServerName;
import com.hulaki.smtp.exceptions.ApiProtocolException;
import org.apache.commons.lang3.StringUtils;

public class ServerStatusRequest
extends ApiRequest {
    private final ServerName serverName;

    public ServerStatusRequest(ServerName serverName) {
        super("", ApiCommand.SERVER_STATUS);
        this.serverName = serverName;
    }

    public ServerStatusRequest(String requestBody) throws ApiProtocolException {
        super(requestBody, ApiCommand.SERVER_STATUS);
        String[] tokens = requestBody.split(" ");
        if (tokens.length != 2) {
            throw new ApiProtocolException("Server status should be in format SERVER_STATUS [" + StringUtils.join((Object[])ServerName.values(), (char)'|') + "]");
        }
        this.serverName = ServerName.parse(tokens[1].trim());
    }

    @Override
    public String toRequestString() {
        return ApiCommand.SERVER_STATUS.toString() + " " + (Object)((Object)this.serverName);
    }

    public ServerName getServerName() {
        return this.serverName;
    }
}

