/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.app;

import com.hulaki.smtp.api.MailMessage;
import com.hulaki.smtp.storage.MailMessageDao;
import com.hulaki.smtp.storage.RelayAddressDao;
import com.hulaki.smtp.transport.Observer;
import com.hulaki.smtp.transport.SmtpMessage;
import com.hulaki.smtp.utils.EmailSender;
import com.hulaki.smtp.utils.EmailUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;

@Component
public class MailProcessor
implements Observer<SmtpMessage>,
Runnable {
    private static final Logger logger = Logger.getLogger(MailProcessor.class);
    private volatile boolean stopped;
    private MailMessageDao mailMessageDao;
    private RelayAddressDao relayAddressDao;
    private EmailSender emailSender;

    @Override
    public void notify(SmtpMessage smtpMessage) {
        String[] toAddresses;
        for (String toAddress : toAddresses = smtpMessage.getHeaderValue("To").split(",")) {
            String recipient = EmailUtils.normalizeEmailAddress(toAddress);
            String sender = smtpMessage.getHeaderValue("From");
            String subject = smtpMessage.getHeaderValue("Subject");
            String body = smtpMessage.getBody();
            this.process(sender, recipient, subject, body);
        }
    }

    private void process(String sender, String recipient, String subject, String body) {
        boolean wasMailRelayed = false;
        if (this.relayAddressDao.isRelayRecipient(recipient)) {
            wasMailRelayed = true;
            this.emailSender.sendEmail(sender, recipient, subject, body);
            logger.info((Object)("Relayed email to " + recipient));
        }
        MailMessage message = new MailMessage(sender, recipient, subject, body, wasMailRelayed);
        this.mailMessageDao.storeMessage(recipient, message);
    }

    public void stop() {
        logger.info((Object)"Stopping Mail processor...");
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void run() {
        logger.info((Object)"Starting Mail processor...");
        this.stopped = false;
        logger.info((Object)"Mail processor started!");
        while (!this.stopped) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.stopped = true;
            }
        }
        logger.info((Object)"Mail processor stopped!");
    }

    @Required
    public void setMailMessageDao(MailMessageDao mailMessageDao) {
        this.mailMessageDao = mailMessageDao;
    }

    @Required
    public void setRelayAddressDao(RelayAddressDao relayAddressDao) {
        this.relayAddressDao = relayAddressDao;
    }

    @Required
    public void setEmailSender(EmailSender emailSender) {
        this.emailSender = emailSender;
    }
}

