/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.app;

import com.hulaki.smtp.app.MailProcessor;
import com.hulaki.smtp.storage.MailMessageDaoFactory;
import com.hulaki.smtp.transport.ApiServer;
import com.hulaki.smtp.transport.SmtpServer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ServerApplication
implements ApplicationListener<ContextStartedEvent> {
    private static final Logger logger = Logger.getLogger(ServerApplication.class);
    public static final String CONFIG_STORAGE_MODE = "storage.mode";

    public static void main(String[] args) throws Exception {
        ServerApplication.setupMailMessageDaoFactory();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("application-config.xml");
        ApiServer apiServer = (ApiServer)context.getBean(ApiServer.class);
        apiServer.start();
        SmtpServer smtpServer = (SmtpServer)context.getBean(SmtpServer.class);
        smtpServer.start();
        MailProcessor mailProcessor = (MailProcessor)context.getBean(MailProcessor.class);
        smtpServer.addObserver(mailProcessor);
        Thread mailProcessorThread = new Thread(mailProcessor);
        mailProcessorThread.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Type EXIT to close the application");
        String line = reader.readLine();
        while (!line.equalsIgnoreCase("EXIT")) {
            System.out.println("Type EXIT to close the application");
            line = reader.readLine();
        }
        apiServer.stop();
        smtpServer.stop();
        mailProcessor.stop();
    }

    private static void setupMailMessageDaoFactory() {
        MailMessageDaoFactory.StorageMode storageMode;
        String storageModeProp = System.getProperty(CONFIG_STORAGE_MODE);
        if (!StringUtils.isEmpty((CharSequence)storageModeProp)) {
            storageMode = MailMessageDaoFactory.StorageMode.valueOf(storageModeProp.toUpperCase());
            logger.info((Object)("Using " + storageMode.name() + " storage..."));
        } else {
            storageMode = MailMessageDaoFactory.StorageMode.IN_MEMORY;
            logger.warn((Object)"No explicit storage mode specified. IN_MEMORY storage will be used.");
        }
        MailMessageDaoFactory.setStorageMode(storageMode);
    }

    public void onApplicationEvent(ContextStartedEvent contextStartedEvent) {
    }
}

