/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.storage;

import com.google.common.collect.Maps;
import com.hulaki.smtp.api.MailMessage;
import com.hulaki.smtp.storage.MailMessageDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class InMemoryMailMessageDao
implements MailMessageDao {
    private Map<String, ArrayList<MailMessage>> emailsByRecipients = Maps.newConcurrentMap();
    private int storedEmailCount = 0;
    private Logger logger = Logger.getLogger(this.getClass());

    @Override
    public synchronized void storeMessage(String recipient, MailMessage email) {
        if (!this.emailsByRecipients.containsKey(recipient)) {
            this.emailsByRecipients.put(recipient, new ArrayList());
        }
        ArrayList<MailMessage> mailsForUser = this.emailsByRecipients.get(recipient);
        mailsForUser.add(email);
        ++this.storedEmailCount;
        this.logger.info((Object)("Stored message # " + mailsForUser.size() + " for " + recipient + " (total: " + this.storedEmailCount + ")..."));
    }

    public synchronized ArrayList<MailMessage> retrieveMessages(String recipient) {
        ArrayList<MailMessage> result = new ArrayList<MailMessage>();
        if (this.emailsByRecipients.containsKey(recipient)) {
            result.addAll((Collection)this.emailsByRecipients.get(recipient));
        }
        this.logger.info((Object)("Retrieved " + result.size() + " messages for " + recipient));
        return result;
    }

    @Override
    public synchronized int countMessagesForRecipient(String recipient) {
        int count = 0;
        if (this.emailsByRecipients.containsKey(recipient)) {
            count = this.emailsByRecipients.get(recipient).size();
        }
        this.logger.info((Object)("Counted  " + count + " messages for " + recipient));
        return count;
    }

    @Override
    public synchronized void clearMessagesForRecipient(String recipient) {
        if (this.emailsByRecipients.containsKey(recipient)) {
            int count = this.emailsByRecipients.get(recipient).size();
            this.storedEmailCount -= count;
            this.emailsByRecipients.get(recipient).clear();
            this.emailsByRecipients.remove(recipient);
            this.logger.info((Object)("Cleared  " + count + " messages for " + recipient));
        }
    }

    @Override
    public synchronized void clearMessages() {
        this.emailsByRecipients.clear();
        this.logger.info((Object)("Cleared  " + this.storedEmailCount + " messages"));
        this.storedEmailCount = 0;
    }

    @Override
    public synchronized int countAllMessagesReceived() {
        this.logger.info((Object)("Counted " + this.storedEmailCount + " messages"));
        return this.storedEmailCount;
    }
}

