/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.storage;

import com.hulaki.smtp.app.ApplicationContextProvider;
import com.hulaki.smtp.storage.FileBasedMailMessageDao;
import com.hulaki.smtp.storage.InMemoryMailMessageDao;
import com.hulaki.smtp.storage.MailMessageDao;
import com.hulaki.smtp.storage.MapDbMailMessageDao;
import com.hulaki.smtp.storage.SqliteMailMessageDao;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class MailMessageDaoFactory {
    private static volatile MailMessageDaoFactory instance;
    private static StorageMode storageMode;
    private MailMessageDao dao;

    private MailMessageDaoFactory() {
        ApplicationContext context = new ApplicationContextProvider().getApplicationContext();
        switch (storageMode) {
            case SQLITE: {
                this.dao = (MailMessageDao)context.getBean(SqliteMailMessageDao.class);
                break;
            }
            case FILE_BASED: {
                this.dao = (MailMessageDao)context.getBean(FileBasedMailMessageDao.class);
                break;
            }
            case IN_MEMORY: {
                this.dao = (MailMessageDao)context.getBean(InMemoryMailMessageDao.class);
                break;
            }
            case MAP_DB: {
                this.dao = (MailMessageDao)context.getBean(MapDbMailMessageDao.class);
                break;
            }
            default: {
                throw new IllegalStateException("Storage mode not initialized correctly.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MailMessageDaoFactory getInstance() {
        if (instance != null) return instance;
        Class<MailMessageDaoFactory> clazz = MailMessageDaoFactory.class;
        synchronized (MailMessageDaoFactory.class) {
            if (instance != null) return instance;
            instance = new MailMessageDaoFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public MailMessageDao getDao() {
        return this.dao;
    }

    public static void setStorageMode(StorageMode mode) {
        storageMode = mode;
    }

    public static enum StorageMode {
        SQLITE,
        FILE_BASED,
        IN_MEMORY,
        MAP_DB;

    }
}

