/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.storage;

import com.google.common.collect.Lists;
import com.hulaki.smtp.api.MailMessage;
import com.hulaki.smtp.storage.MailMessageDao;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.log4j.Logger;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class MapDbMailMessageDao
implements MailMessageDao {
    private static final String COLLECTION_NAME = "emails";
    private static final Logger logger = Logger.getLogger(MapDbMailMessageDao.class);
    private volatile int storedEmailsCount = 0;
    private final ConcurrentNavigableMap<String, List<MailMessage>> map;
    private final DB db;
    private final String dbFilepath;

    public MapDbMailMessageDao(String dbFilepath) {
        this.dbFilepath = dbFilepath;
        this.db = DBMaker.newFileDB((File)new File(this.dbFilepath)).closeOnJvmShutdown().compressionEnable().make();
        this.map = this.db.getTreeMap(COLLECTION_NAME);
        this.map.clear();
        this.db.commit();
    }

    @Override
    public synchronized void storeMessage(String recipient, MailMessage email) {
        ++this.storedEmailsCount;
        ArrayList emails = Lists.newArrayList();
        if (this.map.containsKey(recipient)) {
            emails.addAll((Collection)this.map.get(recipient));
        }
        emails.add(email);
        this.map.put(recipient, emails);
        this.db.commit();
        logger.info((Object)("Stored message #" + emails.size() + " for " + recipient + ". Sum-total: " + this.storedEmailsCount));
    }

    @Override
    public synchronized List<MailMessage> retrieveMessages(String recipient) {
        ArrayList emails = Lists.newArrayList();
        if (this.map.containsKey(recipient)) {
            emails = Lists.newArrayList((Iterable)((Iterable)this.map.get(recipient)));
        }
        logger.info((Object)("Retrieved " + emails.size() + " emails for " + recipient));
        return emails;
    }

    @Override
    public synchronized int countMessagesForRecipient(String recipient) {
        int count = 0;
        if (this.map.containsKey(recipient)) {
            count = ((List)this.map.get(recipient)).size();
        }
        logger.info((Object)("Counted " + count + " emails for " + recipient));
        return count;
    }

    @Override
    public synchronized void clearMessagesForRecipient(String recipient) {
        int countForRecipient = 0;
        if (this.map.containsKey(recipient)) {
            countForRecipient = ((List)this.map.get(recipient)).size();
            this.storedEmailsCount -= countForRecipient;
            this.map.remove(recipient);
            this.db.commit();
        }
        logger.info((Object)("Cleared " + countForRecipient + " emails for " + recipient + ". Sum-total: " + this.storedEmailsCount));
    }

    @Override
    public synchronized void clearMessages() {
        int previousCount = this.storedEmailsCount;
        this.storedEmailsCount = 0;
        this.map.clear();
        this.db.commit();
        logger.info((Object)("Cleared " + previousCount + " emails. Sum-total: " + this.storedEmailsCount));
    }

    @Override
    public synchronized int countAllMessagesReceived() {
        logger.info((Object)("Counted total of " + this.storedEmailsCount + " emails."));
        return this.storedEmailsCount;
    }
}

