/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.hulaki.smtp.transport.ApiServerHandlerFactory;
import com.hulaki.smtp.transport.ApiServerInitializerFactory;
import com.hulaki.smtp.transport.Server;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ApiServer
implements Server {
    private static final Logger logger = Logger.getLogger(ApiServer.class);
    private static final int BOSS_GROUP_THREAD_COUNT = 10;
    private static final int WORKER_GROUP_THREAD_COUNT = 20;
    private final int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private volatile boolean started = false;
    private ApiServerInitializerFactory apiServerInitializerFactory;
    private ApiServerHandlerFactory apiServerHandlerFactory;

    public ApiServer(int port) {
        this.port = port;
        this.bossGroup = new NioEventLoopGroup(10);
        this.workerGroup = new NioEventLoopGroup(20);
    }

    @Override
    public boolean isRunning() {
        return this.started && !this.bossGroup.isShutdown() && !this.bossGroup.isShuttingDown() && !this.workerGroup.isShutdown() && !this.workerGroup.isShuttingDown();
    }

    @Override
    public synchronized void start() throws InterruptedException {
        Assert.notNull((Object)this.apiServerInitializerFactory);
        Assert.notNull((Object)this.apiServerHandlerFactory);
        if (this.started) {
            logger.warn((Object)"API Server already started.");
            return;
        }
        this.started = true;
        logger.info((Object)("Starting API server on port: " + this.port + "..."));
        ServerBootstrap b = new ServerBootstrap();
        this.bossGroup = new NioEventLoopGroup(10);
        this.workerGroup = new NioEventLoopGroup(20);
        b.group(this.bossGroup, this.workerGroup);
        b.channel(NioServerSocketChannel.class);
        b.childHandler((ChannelHandler)this.apiServerInitializerFactory.create());
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.bind(this.port).sync();
        logger.info((Object)"Started API server!");
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        if (!this.started) {
            logger.warn((Object)"API Server already stopped.");
            return;
        }
        logger.info((Object)"Stopping API server...");
        this.workerGroup.shutdownGracefully();
        this.workerGroup.terminationFuture().sync();
        this.bossGroup.shutdownGracefully();
        this.bossGroup.terminationFuture().sync();
        logger.info((Object)"Stopped API server!");
        this.started = false;
    }

    @Required
    public void setApiServerInitializerFactory(ApiServerInitializerFactory apiServerInitializerFactory) {
        this.apiServerInitializerFactory = apiServerInitializerFactory;
    }

    @Required
    public void setApiServerHandlerFactory(ApiServerHandlerFactory apiServerHandlerFactory) {
        this.apiServerHandlerFactory = apiServerHandlerFactory;
    }
}

