/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.hulaki.smtp.api.ApiRequest;
import com.hulaki.smtp.api.ApiResponse;
import com.hulaki.smtp.api.ClearRequest;
import com.hulaki.smtp.api.CountRequest;
import com.hulaki.smtp.api.CountResponse;
import com.hulaki.smtp.api.GetRequest;
import com.hulaki.smtp.api.GetResponse;
import com.hulaki.smtp.api.InvalidRequest;
import com.hulaki.smtp.api.RelayMode;
import com.hulaki.smtp.api.RelayRequest;
import com.hulaki.smtp.api.RelayResponse;
import com.hulaki.smtp.api.ServerName;
import com.hulaki.smtp.api.ServerStatus;
import com.hulaki.smtp.api.ServerStatusRequest;
import com.hulaki.smtp.api.StatusResponse;
import com.hulaki.smtp.app.MailProcessor;
import com.hulaki.smtp.exceptions.ApiProtocolException;
import com.hulaki.smtp.storage.MailMessageDao;
import com.hulaki.smtp.storage.RelayAddressDao;
import com.hulaki.smtp.transport.SmtpServer;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.springframework.util.Assert;

public class ApiServerHandler
extends ChannelHandlerAdapter {
    private final MailMessageDao mailMessageDao;
    private final RelayAddressDao relayAddressDao;
    private final MailProcessor mailProcessor;
    private final SmtpServer smtpServer;

    public ApiServerHandler(MailMessageDao mailMessageDao, RelayAddressDao relayAddressDao, MailProcessor mailProcessor, SmtpServer smtpServer) {
        Assert.notNull((Object)mailMessageDao);
        Assert.notNull((Object)relayAddressDao);
        Assert.notNull((Object)mailProcessor);
        Assert.notNull((Object)smtpServer);
        this.mailMessageDao = mailMessageDao;
        this.relayAddressDao = relayAddressDao;
        this.mailProcessor = mailProcessor;
        this.smtpServer = smtpServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ApiRequest request = (ApiRequest)msg;
        ChannelFuture writeHandler = null;
        try {
            ApiResponse response = request == null || request instanceof InvalidRequest ? new StatusResponse(404, "Invalid command!") : (request instanceof CountRequest ? this.process((CountRequest)request) : (request instanceof GetRequest ? this.process((GetRequest)request) : (request instanceof ClearRequest ? this.process((ClearRequest)request) : (request instanceof RelayRequest ? this.process((RelayRequest)request) : (request instanceof ServerStatusRequest ? this.process((ServerStatusRequest)request) : new StatusResponse(403, "Bad request!"))))));
            writeHandler = ctx.writeAndFlush((Object)response);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
            if (writeHandler != null) {
                writeHandler.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.close();
            }
        }
    }

    private ApiResponse process(CountRequest countRequest) {
        int cnt = countRequest.getRecipient() != null ? this.mailMessageDao.countMessagesForRecipient(countRequest.getRecipient()) : this.mailMessageDao.countAllMessagesReceived();
        return new CountResponse(countRequest.getRecipient(), cnt);
    }

    private ApiResponse process(GetRequest getRequest) {
        return new GetResponse(getRequest.getRecipient(), this.mailMessageDao.retrieveMessages(getRequest.getRecipient()));
    }

    private ApiResponse process(ClearRequest clearRequest) {
        this.mailMessageDao.clearMessagesForRecipient(clearRequest.getRecipient());
        return new StatusResponse(200, "OK");
    }

    private ApiResponse process(ServerStatusRequest request) {
        ServerStatus status = request.getServerName() == ServerName.MAIL_PROCESSOR ? (!this.mailProcessor.isStopped() ? ServerStatus.RUNNING : ServerStatus.STOPPED) : (this.smtpServer.isRunning() ? ServerStatus.RUNNING : ServerStatus.STOPPED);
        return new StatusResponse(status.getStatus(), status.getStatusString());
    }

    private ApiResponse process(RelayRequest relayRequest) {
        if (relayRequest.getRecipient() != null) {
            if (relayRequest.getRelayMode() == RelayMode.ADD) {
                this.relayAddressDao.addRelayRecipient(relayRequest.getRecipient());
                return new StatusResponse(200, "OK");
            }
            if (relayRequest.getRelayMode() == RelayMode.REMOVE) {
                this.relayAddressDao.removeRelayRecipient(relayRequest.getRecipient());
                return new StatusResponse(200, "OK");
            }
            if (relayRequest.getRelayMode() == RelayMode.GET) {
                if (this.relayAddressDao.isRelayRecipient(relayRequest.getRecipient())) {
                    return new StatusResponse(200, "OK");
                }
                return new StatusResponse(404, "NOT FOUND");
            }
        } else {
            if (relayRequest.getRelayMode() == RelayMode.REMOVE) {
                this.relayAddressDao.clearRelayRecipients();
                return new StatusResponse(200, "OK");
            }
            if (relayRequest.getRelayMode() == RelayMode.GET) {
                return new RelayResponse(this.relayAddressDao.getRelayRecipients());
            }
        }
        throw new ApiProtocolException("Parameters missing in the request.");
    }
}

