/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.hulaki.smtp.transport.ApiRequestDecoder;
import com.hulaki.smtp.transport.ApiRequestEncoder;
import com.hulaki.smtp.transport.ApiServerHandlerFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import org.springframework.beans.factory.annotation.Required;

public class ApiServerInitializer
extends ChannelInitializer<SocketChannel> {
    private ApiServerHandlerFactory serverHandlerFactory;

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(1000, Delimiters.lineDelimiter()));
        pipeline.addLast("decoder", (ChannelHandler)new ApiRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new ApiRequestEncoder());
        pipeline.addLast("handler", (ChannelHandler)this.serverHandlerFactory.create());
    }

    @Required
    public void setServerHandlerFactory(ApiServerHandlerFactory serverHandlerFactory) {
        this.serverHandlerFactory = serverHandlerFactory;
    }
}

