/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.google.common.collect.Maps;
import com.hulaki.smtp.exceptions.SmtpException;
import com.hulaki.smtp.transport.SmtpServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SmtpMessage {
    private static final Pattern headerPattern = Pattern.compile("(?<name>[^:]*): (?<value>.*)");
    private static final Logger logger = Logger.getLogger(SmtpServer.class);
    private Map<String, String> headers = Maps.newHashMap();
    private StringBuffer bodyBuffer = new StringBuffer();
    private String body;
    private String latestHeader;
    private boolean isReadingHeader = true;
    private boolean closed = false;

    public void addLine(String line) {
        if (this.closed) {
            throw new SmtpException("Can't add content once the message is closed.");
        }
        if (this.isReadingHeader && StringUtils.isEmpty((CharSequence)line)) {
            this.isReadingHeader = false;
            return;
        }
        if (this.isReadingHeader) {
            this.addHeader(line);
            return;
        }
        this.bodyBuffer.append(line).append("\n");
        String encoding = this.getEncoding();
        if (encoding != null) {
            boolean isSoftBreak;
            boolean bl = isSoftBreak = encoding.equalsIgnoreCase("quoted-printable") && line.endsWith("=3D");
            if (isSoftBreak) {
                this.bodyBuffer.delete(this.bodyBuffer.length() - 4, this.bodyBuffer.length() - 1);
            }
        }
    }

    public void close() {
        this.closed = true;
        if (this.bodyBuffer.length() > 0) {
            this.bodyBuffer.deleteCharAt(this.bodyBuffer.length() - 1);
        }
        String encoding = this.getEncoding();
        String charset = this.getCharset();
        if (charset != null && encoding != null) {
            try {
                this.body = SmtpMessage.decodeFromUtf8(this.bodyBuffer.toString(), encoding, charset);
            }
            catch (Exception ex) {
                throw new SmtpException("Error decoding body '" + this.bodyBuffer + "': " + ex.getMessage(), ex);
            }
        } else {
            this.body = this.bodyBuffer.toString();
        }
    }

    private String getEncoding() {
        return this.getHeaderValue("Content-Transfer-Encoding");
    }

    private String encodedText(String encodedText) {
        try {
            return MimeUtility.decodeText((String)encodedText);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)("Error decode text '" + encodedText + "'. The unencoded Text will be returned."), (Throwable)e);
            return encodedText;
        }
    }

    public String getHeaderValue(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return this.headers.get(headerName);
        }
        return null;
    }

    private void addHeader(String line) {
        Matcher headerMatcher = headerPattern.matcher(line);
        if (headerMatcher.matches()) {
            String name;
            this.latestHeader = name = headerMatcher.group("name");
            String value = headerMatcher.group("value");
            this.headers.put(name, this.encodedText(value));
        } else {
            String value = this.headers.get(this.latestHeader) + this.encodedText(line.substring(1));
            this.headers.put(this.latestHeader, value);
        }
    }

    private String getCharset() {
        int n;
        String contentType = this.getHeaderValue("Content-Type");
        if (contentType != null && (n = contentType.indexOf("charset=")) >= 0) {
            String charset = contentType.substring(n + "charset=".length());
            if ((n = charset.indexOf(";")) >= 0) {
                charset = charset.substring(0, n);
            }
            return charset;
        }
        return null;
    }

    private static String decodeFromUtf8(String text, String encoding, String charset) throws Exception {
        if (text.length() == 0) {
            return text;
        }
        byte[] asciiBytes = text.getBytes("UTF-8");
        InputStream decodedStream = MimeUtility.decode((InputStream)new ByteArrayInputStream(asciiBytes), (String)encoding);
        byte[] tmp = new byte[asciiBytes.length];
        int n = decodedStream.read(tmp);
        byte[] res = new byte[n];
        System.arraycopy(tmp, 0, res, 0, n);
        return new String(res, charset);
    }

    public String getBody() {
        return this.body;
    }
}

