/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.hulaki.smtp.exceptions.SmtpProtocolException;
import com.hulaki.smtp.transport.SmtpCommand;
import com.hulaki.smtp.transport.SmtpResult;
import com.hulaki.smtp.transport.SmtpState;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SmtpRequest {
    private final SmtpState currentState;
    private final SmtpCommand command;
    private static String hostname;

    public SmtpRequest(SmtpState currentState, SmtpCommand command) {
        this.command = command;
        this.currentState = currentState;
    }

    public SmtpResult execute() {
        switch (this.command) {
            case VRFY: 
            case EXPN: {
                return new SmtpResult(this.currentState, 252, "Not supported");
            }
            case HELP: {
                return new SmtpResult(this.currentState, 211, "No help available");
            }
            case NOOP: {
                return new SmtpResult(this.currentState, 250, "OK");
            }
            case RSET: {
                return new SmtpResult(SmtpState.GREET, 250, "OK");
            }
            case CONNECT: {
                return this.toStatefulResponse(new SmtpResult(SmtpState.GREET, 220, "ESMTP " + hostname + " service ready"), SmtpState.CONNECT);
            }
            case EHLO: 
            case HELO: {
                return this.toStatefulResponse(new SmtpResult(SmtpState.MAIL, 250, "OK"), SmtpState.GREET);
            }
            case MAIL: {
                return this.toStatefulResponse(new SmtpResult(SmtpState.RCPT, 250, "OK"), SmtpState.MAIL, SmtpState.QUIT);
            }
            case RCPT: {
                return this.toStatefulResponse(new SmtpResult(SmtpState.RCPT, 250, "OK"), SmtpState.RCPT);
            }
            case DATA: {
                return this.toStatefulResponse(new SmtpResult(SmtpState.DATA_HEADER, 354, "Start mail input; end with <CRLF>.<CRLF>"), SmtpState.RCPT);
            }
            case UNRECOGNIZED: {
                if (this.currentState == SmtpState.DATA_HEADER || this.currentState == SmtpState.DATA_BODY) {
                    return this.toStatefulResponse(new SmtpResult(this.currentState), SmtpState.DATA_HEADER, SmtpState.DATA_BODY);
                }
                return new SmtpResult(this.currentState, 500, "Command not recognized");
            }
            case DATA_END: {
                return this.toStatefulResponse(new SmtpResult(SmtpState.QUIT, 250, "OK"), SmtpState.DATA_HEADER, SmtpState.DATA_BODY);
            }
            case BLANK_LINE: {
                if (this.currentState == SmtpState.DATA_HEADER) {
                    return this.toStatefulResponse(new SmtpResult(SmtpState.DATA_BODY), SmtpState.DATA_HEADER);
                }
                return this.toStatefulResponse(new SmtpResult(this.currentState), SmtpState.DATA_BODY);
            }
            case QUIT: {
                return this.toStatefulResponse(new SmtpResult(SmtpState.DISCONNECT, 221, hostname + " closing transmission channel"), SmtpState.QUIT, SmtpState.CONNECT);
            }
        }
        throw new SmtpProtocolException("Unable to process request");
    }

    private SmtpResult toStatefulResponse(SmtpResult correctResponse, SmtpState ... allowedCurrentStates) {
        for (SmtpState allowedCurrentState : allowedCurrentStates) {
            if (this.currentState != allowedCurrentState) continue;
            return correctResponse;
        }
        return new SmtpResult(this.currentState, 503, "Bad sequence of commands: " + this.command.name());
    }

    static {
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "?";
        }
    }
}

