/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.google.common.collect.Lists;
import com.hulaki.smtp.transport.Observable;
import com.hulaki.smtp.transport.Observer;
import com.hulaki.smtp.transport.Server;
import com.hulaki.smtp.transport.SmtpMessage;
import com.hulaki.smtp.transport.SmtpServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SmtpServer
implements Observable<SmtpMessage>,
Observer<SmtpMessage>,
Server {
    private static final Logger logger = Logger.getLogger(SmtpServer.class);
    private static final int BOSS_GROUP_THREAD_COUNT = 10;
    private static final int WORKER_GROUP_THREAD_COUNT = 20;
    private final int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private volatile boolean started = false;
    private List<Observer<SmtpMessage>> observers;

    public SmtpServer(int port) {
        this.port = port;
        this.observers = Lists.newArrayList();
    }

    @Override
    public boolean isRunning() {
        return this.started && !this.bossGroup.isShutdown() && !this.bossGroup.isShuttingDown() && !this.workerGroup.isShutdown() && !this.workerGroup.isShuttingDown();
    }

    @Override
    public synchronized void start() throws InterruptedException {
        if (this.started) {
            logger.warn((Object)"SMTP Server already started.");
            return;
        }
        this.started = true;
        logger.info((Object)("Starting SMTP server on port: " + this.port + "..."));
        ServerBootstrap b = new ServerBootstrap();
        this.bossGroup = new NioEventLoopGroup(10);
        this.workerGroup = new NioEventLoopGroup(20);
        b.group(this.bossGroup, this.workerGroup);
        b.channel(NioServerSocketChannel.class);
        b.childHandler((ChannelHandler)new SmtpServerInitializer(this));
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.bind(this.port).sync();
        logger.info((Object)"Started SMTP server!");
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        if (!this.started) {
            logger.warn((Object)"SMTP Server already stopped.");
            return;
        }
        this.started = false;
        logger.info((Object)"Stopping SMTP server...");
        this.workerGroup.shutdownGracefully().sync();
        Assert.isTrue((boolean)this.workerGroup.isShutdown());
        this.bossGroup.shutdownGracefully().sync();
        Assert.isTrue((boolean)this.bossGroup.isShutdown());
        logger.info((Object)"Stopped SMTP server!");
    }

    @Override
    public void notify(SmtpMessage data) {
        for (Observer<SmtpMessage> observer : this.observers) {
            observer.notify(data);
        }
    }

    @Override
    public void addObserver(Observer<SmtpMessage> observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(Observer<SmtpMessage> observer) {
        this.observers.remove(observer);
    }
}

