/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.google.common.collect.Lists;
import com.hulaki.smtp.transport.Observable;
import com.hulaki.smtp.transport.Observer;
import com.hulaki.smtp.transport.SmtpCommand;
import com.hulaki.smtp.transport.SmtpMessage;
import com.hulaki.smtp.transport.SmtpRequest;
import com.hulaki.smtp.transport.SmtpResult;
import com.hulaki.smtp.transport.SmtpState;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class SmtpServerHandler
extends ChannelHandlerAdapter
implements Observable<SmtpMessage> {
    private static final Logger logger = Logger.getLogger(SmtpServerHandler.class);
    private List<Observer<SmtpMessage>> observers = Lists.newArrayList();
    private SmtpState currentState = SmtpState.CONNECT;
    private SmtpMessage smtpMessage = new SmtpMessage();

    public void channelActive(ChannelHandlerContext ctx) {
        Assert.notEmpty(this.observers);
        logger.debug((Object)"Connected!");
        SmtpRequest request = new SmtpRequest(this.currentState, SmtpCommand.CONNECT);
        SmtpResult result = request.execute();
        this.currentState = result.getNextState();
        ctx.writeAndFlush((Object)(result.toSmtpResponseString() + "\r\n"));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String line = (String)msg;
        logger.debug((Object)("CLIENT: " + line));
        try {
            SmtpResult result = this.executeCommand(line);
            SmtpState prevState = this.currentState;
            this.currentState = result.getNextState();
            if (prevState == SmtpState.DATA_HEADER || prevState == SmtpState.DATA_BODY) {
                this.onData(line, prevState);
            }
            if (result.getSmtpResponse() != null) {
                ctx.writeAndFlush((Object)(result.toSmtpResponseString() + "\r\n")).sync();
                if (this.currentState == SmtpState.DISCONNECT) {
                    ctx.close().sync();
                }
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private SmtpResult executeCommand(String line) {
        SmtpCommand command = SmtpCommand.parse(line);
        SmtpRequest request = new SmtpRequest(this.currentState, command);
        return request.execute();
    }

    private void onData(String line, SmtpState prevState) {
        if (prevState == SmtpState.DATA_BODY && this.currentState == SmtpState.QUIT) {
            this.smtpMessage.close();
            this.notifyObservers(this.smtpMessage);
            this.smtpMessage = new SmtpMessage();
        }
        if (line.startsWith("..")) {
            line = line.substring(1);
        }
        this.smtpMessage.addLine(line);
    }

    private void notifyObservers(SmtpMessage smtpMessage) {
        for (Observer<SmtpMessage> observer : this.observers) {
            observer.notify(smtpMessage);
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.observers.clear();
        this.observers = null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)"An error occurred while processing the request", cause);
        this.observers.clear();
        this.observers = null;
        if (ctx.channel().isOpen()) {
            ctx.channel().close();
        }
    }

    @Override
    public void addObserver(Observer<SmtpMessage> observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(Observer<SmtpMessage> observer) {
        this.observers.remove(observer);
    }
}

