/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.transport;

import com.hulaki.smtp.transport.SmtpServer;
import com.hulaki.smtp.transport.SmtpServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;

public class SmtpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private SmtpServer smtpServer;

    public SmtpServerInitializer(SmtpServer smtpServer) {
        this.smtpServer = smtpServer;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(1000, Delimiters.lineDelimiter()));
        pipeline.addLast("decoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
        pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
        SmtpServerHandler serverHandler = new SmtpServerHandler();
        serverHandler.addObserver(this.smtpServer);
        pipeline.addLast("handler", (ChannelHandler)serverHandler);
    }
}

