/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.utils;

import com.google.common.collect.Lists;
import com.hulaki.smtp.exceptions.SmtpException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailSender {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String charset = "UTF-8";
    private String encoding;
    private List<String> additionalHeaderLines = Lists.newArrayList();
    private final String smtpHostname;
    private final int smtpPort;
    private String username;
    private String password;

    public EmailSender(String smtpHostname, int smtpPort) {
        this.smtpHostname = smtpHostname;
        this.smtpPort = smtpPort;
    }

    public void sendEmail(String from, String to, String subject, String body) {
        this.sendEmail(from, new String[]{to}, subject, body);
    }

    public void sendEmail(String from, MimeMessage ... mimeMessages) throws MessagingException {
        Session session = this.newSmtpSession(from);
        Transport transport = session.getTransport("smtp");
        transport.connect(this.smtpHostname, this.smtpPort, this.username, this.password);
        for (MimeMessage message : mimeMessages) {
            if (this.encoding != null) {
                message.setHeader("Content-Transfer-Encoding", this.encoding);
            }
            message.setFrom((Address)new InternetAddress(from));
            for (String headerLine : this.additionalHeaderLines) {
                message.addHeaderLine(headerLine);
            }
            transport.sendMessage((Message)message, message.getAllRecipients());
        }
        transport.close();
    }

    public void sendEmail(String from, String[] to, String subject, String body) {
        Session session = this.newSmtpSession(from);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setHeader("Content-Type", "text/plain; charset=" + this.charset + "; format=flowed");
            message.setHeader("X-Accept-Language", "pt-br, pt");
            ArrayList recipients = Lists.newArrayList();
            for (String email : to) {
                recipients.add(new InternetAddress(email, email));
            }
            message.setFrom((Address)new InternetAddress(from));
            message.addRecipients(Message.RecipientType.TO, (Address[])recipients.toArray(new InternetAddress[recipients.size()]));
            message.setSubject(subject);
            message.setText(body);
            this.sendEmail(from, message);
        }
        catch (Exception ex) {
            throw new SmtpException(ex);
        }
    }

    public Session newSmtpSession(String from) {
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", this.smtpHostname);
        properties.setProperty("mail.smtp.port", Integer.toString(this.smtpPort));
        properties.put("mail.mime.charset", this.charset);
        properties.put("mail.from", from);
        return Session.getDefaultInstance((Properties)properties);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void addHeaderLine(String headerLine) {
        this.additionalHeaderLines.add(headerLine);
    }

    public void addHeader(String headerKey, String headerValue) {
        this.addHeaderLine(headerKey + ": " + headerValue);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

