/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.ariia.mvc.model.ControllerHandler;
import org.ariia.mvc.processing.ProxySwitcher;
import org.ariia.mvc.resource.FileResourceHandler;
import org.ariia.mvc.resource.StreamResourceHandler;
import org.ariia.mvc.router.Routes;
import org.ariia.mvc.sse.ServerSideEventHandler;
import org.ariia.mvc.sse.SourceEvent;

public class WebServer {
    private HttpServer server;
    private String staticResourceHandler;
    private List<ControllerHandler> controllerHandlers;

    public WebServer(int port, String resourceLocation, ResourceType type) throws IOException {
        this(new InetSocketAddress(port), resourceLocation, type, new Routes("/"));
    }

    public WebServer(int port, String resourceLocation, ResourceType type, Routes rootRoutes) throws IOException {
        this(new InetSocketAddress(port), resourceLocation, type, rootRoutes);
    }

    public WebServer(InetSocketAddress address, String resourceLocation, ResourceType type, Routes rootRoutes) throws IOException {
        this.server = HttpServer.create(address, 0);
        this.staticResourceHandler = resourceLocation;
        switch (type) {
            case FILE: {
                this.createFileResourceHandlerContext("/", resourceLocation, rootRoutes);
                break;
            }
            default: {
                this.createStreamResourceHandlerContext("/", resourceLocation, rootRoutes);
            }
        }
        this.controllerHandlers = new ArrayList<ControllerHandler>();
    }

    public HttpServer server() {
        return this.server;
    }

    public String staticResourceHandler() {
        return this.staticResourceHandler;
    }

    public void removeResourceContext() throws IllegalArgumentException {
        this.server.removeContext("/");
    }

    public void start() {
        this.server.start();
    }

    public void setExecutor(Executor executor) {
        this.server.setExecutor(executor);
    }

    public void stop(int delay) {
        this.server.stop(delay);
    }

    public HttpContext createContext(String path, HttpHandler handler) {
        return this.server.createContext(path, handler);
    }

    public HttpContext createStreamResourceHandlerContext(String path, String resourceLocation, Routes rootRoutes) {
        StreamResourceHandler handler = new StreamResourceHandler(resourceLocation, rootRoutes);
        return this.server.createContext(path, handler);
    }

    public HttpContext createFileResourceHandlerContext(String path, String resourceLocation, Routes rootRoutes) {
        FileResourceHandler handler = new FileResourceHandler(resourceLocation, rootRoutes);
        return this.server.createContext(path, handler);
    }

    public HttpContext createContext(String path) {
        return this.server.createContext(path);
    }

    public HttpContext createControllerContext(Object controller) {
        ProxySwitcher switcher = new ProxySwitcher(controller);
        ControllerHandler handler = new ControllerHandler(controller, switcher);
        this.controllerHandlers.add(handler);
        return this.server.createContext(switcher.getContext(), handler);
    }

    public HttpContext createServerSideEventContext(String path, ServerSideEventHandler handler) {
        return this.server.createContext(path, handler);
    }

    public HttpContext createServerSideEventContext(String path, SourceEvent event) {
        ServerSideEventHandler handler = new ServerSideEventHandler(event);
        return this.server.createContext(path, handler);
    }

    public static enum ResourceType {
        FILE,
        STREAM;

    }
}

