/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.model;

import com.google.gson.Gson;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ariia.mvc.model.ParameterInfo;
import org.ariia.mvc.model.RequestInfo;
import org.ariia.mvc.processing.MethodIndex;
import org.ariia.mvc.processing.ProxySwitcher;
import org.ariia.mvc.resource.MimeType;

public class ControllerHandler
implements HttpHandler {
    private static Gson gson = new Gson();
    private Object controller;
    private ProxySwitcher switcher;
    private List<MethodIndex> methodIndexs;

    public ControllerHandler(Object controller, ProxySwitcher switcher) {
        this.controller = controller;
        this.switcher = switcher;
        this.methodIndexs = switcher.getMethodIndexs();
    }

    private static Object[] getParamters(HttpExchange exchange, MethodIndex methodIndex, RequestInfo requestInfo) {
        Object[] parameters = new Object[methodIndex.getParametersInfo().size()];
        for (int i = 0; i < parameters.length; ++i) {
            ParameterInfo info = methodIndex.getParametersInfo().get(i);
            if (info.isRequestBody()) {
                parameters[i] = ControllerHandler.toObject(info.getParameterType(), requestInfo.getBody());
                continue;
            }
            if (info.isPathVariable()) {
                parameters[i] = ControllerHandler.toObject(info.getParameterType(), requestInfo.getPathVariable(info.name()));
                continue;
            }
            if (info.isRequestParam()) {
                parameters[i] = ControllerHandler.toObject(info.getParameterType(), requestInfo.getParamter(info.name()));
                continue;
            }
            if (info.isHeaderValue()) {
                parameters[i] = ControllerHandler.toObject(info.getParameterType(), exchange.getRequestHeaders().getFirst(info.name()));
                continue;
            }
            if (info.getParameterType().equals(HttpExchange.class)) {
                parameters[i] = exchange;
                continue;
            }
            if (info.getParameterType().equals(OutputStream.class)) {
                parameters[i] = exchange.getResponseBody();
                continue;
            }
            if (!info.getParameterType().equals(InputStream.class)) continue;
            parameters[i] = exchange.getRequestBody();
        }
        return parameters;
    }

    private static Object toObject(Class<?> clazz, String value) {
        if (String.class == clazz) {
            return value;
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            return Byte.parseByte(value);
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            return Short.parseShort(value);
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return Integer.parseInt(value);
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            return Long.parseLong(value);
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return Double.parseDouble(value);
        }
        return gson.fromJson(value, clazz);
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            Optional<MethodIndex> optional;
            URI uri = exchange.getRequestURI();
            RequestInfo requestInfo = new RequestInfo();
            if (exchange.getRequestBody().available() > 0) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(exchange.getRequestBody(), StandardCharsets.UTF_8));
                requestInfo.setBody(reader.lines().collect(Collectors.joining("\n")));
            }
            String path = uri.getPath();
            requestInfo.setParamters(uri.getQuery());
            requestInfo.setMethodContext(path.split(this.switcher.getContext(), 2)[1]);
            if (this.switcher.getContextParamter().size() > 0) {
                for (String param : this.switcher.getContextParamter()) {
                    String methodContext = requestInfo.getMethodContext();
                    int i = methodContext.indexOf(47);
                    requestInfo.putPathVariable(param, methodContext.substring(0, i));
                    requestInfo.setMethodContext(methodContext.substring(i + 1));
                }
                requestInfo.setMethodContext('/' + requestInfo.getMethodContext());
            }
            if (!(optional = this.filterMethods(requestInfo, exchange.getRequestMethod(), path, exchange.getRequestHeaders())).isPresent()) {
                exchange.sendResponseHeaders(500, -1L);
                return;
            }
            MethodIndex methodIndex = optional.get();
            if (!methodIndex.context().equals(requestInfo.getMethodContext())) {
                String mContext = requestInfo.getMethodContext().split(methodIndex.context())[1];
                for (String pathVariable : methodIndex.pathVariables()) {
                    String methodContext = mContext;
                    int i = methodContext.indexOf(47);
                    if (i == -1) {
                        requestInfo.putPathVariable(pathVariable, methodContext);
                        break;
                    }
                    requestInfo.putPathVariable(pathVariable, methodContext.substring(0, i));
                    mContext = methodContext.substring(i + 1);
                }
            }
            try {
                this.executeMathod(exchange, methodIndex, requestInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    boolean printMethodIndex(MethodIndex method) {
        System.out.println(method);
        return true;
    }

    Optional<MethodIndex> filterMethods(RequestInfo requestInfo, String method, String path, Headers requestHeaders) {
        List base = this.methodIndexs.stream().filter(m -> method.equalsIgnoreCase(m.httpMethod())).filter(m -> requestInfo.getMethodContext().startsWith(m.context())).filter(m -> requestInfo.hasBody() == m.hasBodyParameter()).filter(m -> path.matches(m.getRegexPattern())).collect(Collectors.toList());
        List headerFilter = base.stream().filter(m -> {
            boolean hasAll = !m.headers().isEmpty();
            for (String header : m.headers()) {
                hasAll &= requestHeaders.containsKey(header);
            }
            return hasAll;
        }).limit(1L).collect(Collectors.toList());
        if (!headerFilter.isEmpty()) {
            return headerFilter.stream().findFirst();
        }
        return base.stream().limit(1L).findFirst();
    }

    private void executeMathod(HttpExchange exchange, MethodIndex methodIndex, RequestInfo requestInfo) throws IllegalAccessException, InvocationTargetException, IOException {
        int paramterLength = methodIndex.getParametersInfo().size();
        Object returnObject = null;
        if (paramterLength == 0) {
            returnObject = methodIndex.method().invoke(this.controller, new Object[0]);
        } else {
            Object[] parameters = ControllerHandler.getParamters(exchange, methodIndex, requestInfo);
            returnObject = methodIndex.method().invoke(this.controller, parameters);
        }
        if (Objects.isNull(returnObject)) {
            if (methodIndex.canDoExchange()) {
                return;
            }
            exchange.sendResponseHeaders(200, -1L);
            exchange.close();
        } else {
            String responseBody = gson.toJson(returnObject);
            byte[] bodyBytes = responseBody.getBytes(StandardCharsets.UTF_8);
            if (responseBody.startsWith("{") || responseBody.startsWith("[")) {
                exchange.getResponseHeaders().add("Content-Type", MimeType.mime("json"));
            }
            exchange.sendResponseHeaders(200, bodyBytes.length);
            exchange.getResponseBody().write(bodyBytes);
            exchange.close();
        }
    }
}

