/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.processing;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ariia.mvc.annotation.DoExchange;
import org.ariia.mvc.annotation.HeaderValue;
import org.ariia.mvc.annotation.PathVariable;
import org.ariia.mvc.annotation.RequestBody;
import org.ariia.mvc.annotation.RequestParam;
import org.ariia.mvc.annotation.RestController;
import org.ariia.mvc.annotation.method.DeleteRequest;
import org.ariia.mvc.annotation.method.GetRequest;
import org.ariia.mvc.annotation.method.HeadRequest;
import org.ariia.mvc.annotation.method.HttpMethod;
import org.ariia.mvc.annotation.method.OptionsRequest;
import org.ariia.mvc.annotation.method.PatchRequest;
import org.ariia.mvc.annotation.method.PostRequest;
import org.ariia.mvc.annotation.method.PutRequest;
import org.ariia.mvc.annotation.method.TraceRequest;
import org.ariia.mvc.model.ParameterInfo;
import org.ariia.mvc.processing.MethodIndex;

public class ProxySwitcher {
    private static List<Class<? extends Annotation>> requestAnnotation = new ArrayList<Class<? extends Annotation>>();
    private static List<Class<? extends Annotation>> parameterAnnotation = new ArrayList<Class<? extends Annotation>>();
    private Object controller;
    private List<String> contextParamter;
    private String context;
    private String controllerContext;
    private List<MethodIndex> methodIndexs;

    public ProxySwitcher(Object controller) {
        this.controller = controller;
        this.methodIndexs = new ArrayList<MethodIndex>();
        this.initController();
    }

    public List<MethodIndex> getMethodIndexs() {
        return this.methodIndexs;
    }

    public List<String> getContextParamter() {
        return this.contextParamter;
    }

    public String getControllerContext() {
        return this.controllerContext;
    }

    public String getContext() {
        return this.context;
    }

    private void initController() {
        Class<?> clazz = this.controller.getClass();
        if (clazz.isAnnotationPresent(RestController.class)) {
            RestController restContext = clazz.getAnnotation(RestController.class);
            this.controllerContext = restContext.value();
            if (this.controllerContext.contains("{")) {
                this.context = this.controllerContext.substring(0, this.controllerContext.indexOf(123));
                this.contextParamter = this.listOfPathVariavle(this.controllerContext);
            } else {
                this.context = this.controllerContext;
                this.contextParamter = Collections.emptyList();
            }
        } else {
            this.context = this.controllerContext = clazz.getSimpleName();
            this.contextParamter = Collections.emptyList();
        }
        block0: for (Method method : clazz.getMethods()) {
            for (Class<? extends Annotation> annotationClass : requestAnnotation) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                method.setAccessible(true);
                Annotation annotation = method.getAnnotation(annotationClass);
                this.methodIndexs.add(this.getMethodIndex(method, annotation));
                continue block0;
            }
        }
    }

    private MethodIndex getMethodIndex(Method method, Annotation annotation) {
        try {
            MethodIndex.MethodIndexBuilder indexBuilder = new MethodIndex.MethodIndexBuilder();
            indexBuilder.method(method);
            indexBuilder.canDoExchange(method.isAnnotationPresent(DoExchange.class));
            HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
            indexBuilder.httpMethod(httpMethod.method().name());
            Method pathMethod = annotation.getClass().getMethod("path", new Class[0]);
            Method headersMethod = annotation.getClass().getMethod("headers", new Class[0]);
            Method producesMethod = annotation.getClass().getMethod("produces", new Class[0]);
            indexBuilder.headers(Arrays.asList((String[])headersMethod.invoke((Object)annotation, new Object[0])));
            indexBuilder.produces(Arrays.asList((String[])producesMethod.invoke((Object)annotation, new Object[0])));
            String methodPathContext = pathMethod.invoke((Object)annotation, new Object[0]).toString();
            if (methodPathContext.contains("{")) {
                indexBuilder.context(methodPathContext.substring(0, methodPathContext.indexOf(123)));
                indexBuilder.pathVariables(this.listOfPathVariavle(methodPathContext));
            } else {
                indexBuilder.context(methodPathContext);
                indexBuilder.pathVariables(Collections.emptyList());
            }
            indexBuilder.regexPattern(this.setupRegxPattern(this.controllerContext + methodPathContext));
            indexBuilder.parametersInfo(this.getParametersInfo(method));
            return indexBuilder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    String setupRegxPattern(String pattern) {
        return '^' + pattern.replaceAll("\\{(?:.[a-zA-Z0-9]*)\\}", "(?:.*)");
    }

    String removeBraces(String string) {
        return string.substring(1, string.length() - 1);
    }

    ArrayList<String> listOfPathVariavle(String path) {
        ArrayList<String> list = new ArrayList<String>(3);
        Matcher matcher = Pattern.compile("\\{(?:.[a-zA-Z0-9]*)\\}").matcher(path);
        while (matcher.find()) {
            list.add(this.removeBraces(matcher.group()));
        }
        return list;
    }

    String getPattern(String pathContext) {
        StringBuilder pattern = new StringBuilder();
        pattern.append('^');
        int mark = 0;
        int start = 0;
        int end = 0;
        do {
            start = pathContext.indexOf(123, mark);
            end = pathContext.indexOf("}", start);
            pattern.append(pathContext.subSequence(mark, start));
            pattern.append("(?:.*)");
        } while ((mark = end + 1) < pathContext.length());
        return pattern.toString();
    }

    private List<ParameterInfo> getParametersInfo(Method method) {
        ParameterInfo.Builder builder = null;
        Parameter[] parameters = method.getParameters();
        ArrayList<ParameterInfo> infos = new ArrayList<ParameterInfo>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            builder = new ParameterInfo.Builder();
            Parameter parameter = parameters[i];
            builder.parameterType(parameter.getType());
            for (Class<? extends Annotation> annotationClass : parameterAnnotation) {
                if (!parameter.isAnnotationPresent(annotationClass)) continue;
                builder.index(i);
                Annotation annotation = parameter.getAnnotation(annotationClass);
                builder.annotation(annotation);
                if (annotationClass.equals(RequestBody.class)) {
                    builder.name("@Body");
                    break;
                }
                try {
                    builder.name(annotationClass.getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]).toString());
                }
                catch (Exception exception) {}
                break;
            }
            infos.add(builder.build());
        }
        return infos;
    }

    static {
        requestAnnotation.add(GetRequest.class);
        requestAnnotation.add(HeadRequest.class);
        requestAnnotation.add(PostRequest.class);
        requestAnnotation.add(PutRequest.class);
        requestAnnotation.add(DeleteRequest.class);
        requestAnnotation.add(OptionsRequest.class);
        requestAnnotation.add(TraceRequest.class);
        requestAnnotation.add(PatchRequest.class);
        parameterAnnotation.add(PathVariable.class);
        parameterAnnotation.add(RequestParam.class);
        parameterAnnotation.add(RequestBody.class);
        parameterAnnotation.add(HeaderValue.class);
    }
}

