/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.resource;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.ariia.mvc.resource.StreamHandler;
import org.ariia.mvc.router.Routes;

public abstract class RouterResourceHandler
implements HttpHandler,
StreamHandler {
    protected String indexFile;
    protected Routes routes;

    public RouterResourceHandler(String indexFile, Routes routes) {
        this.indexFile = Objects.requireNonNull(indexFile);
        this.routes = Objects.requireNonNull(routes);
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public void setRootRoutes(Routes routes) {
        this.routes = routes;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        InputStream stream;
        URI uri = exchange.getRequestURI();
        String filename = uri.getPath();
        if (filename.contains("/../")) {
            exchange.sendResponseHeaders(404, -1L);
            exchange.close();
            return;
        }
        if (this.routes.lookupRoute(filename)) {
            filename = this.indexFile;
        }
        try {
            stream = this.getResourceAsStream(filename);
        }
        catch (IOException e) {
            exchange.sendResponseHeaders(404, -1L);
            exchange.close();
            return;
        }
        this.handelStream(exchange, filename, stream);
    }

    protected abstract InputStream getResourceAsStream(String var1) throws IOException;
}

