/*
 * Decompiled with CFR 0.152.
 */
package org.ariia.mvc.sse;

import java.util.Objects;
import org.ariia.mvc.sse.SseMessageEvent;

public class MessageEvent
extends SseMessageEvent {
    public static final MessageEvent KeepAlive = new MessageEvent(":\n\n");
    private String data;
    private String event;
    private Integer retry;
    private String id;

    private MessageEvent(String message) {
        super(message);
    }

    private MessageEvent(String event, String data, Integer retry, String id) {
        this.data = data;
        this.event = event;
        this.retry = retry;
        this.id = id;
    }

    public final String data() {
        return this.data;
    }

    public final String event() {
        return this.event;
    }

    public final Integer retry() {
        return this.retry;
    }

    public final String id() {
        return this.id;
    }

    @Override
    protected String buildMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.event != null) {
            sb.append("event: ").append(this.event.replace("\n", "")).append('\n');
        }
        if (this.data != null) {
            for (String s : this.data.split("\n")) {
                sb.append("data: ").append(s).append('\n');
            }
        }
        if (this.retry != null) {
            sb.append("retry: ").append(this.retry).append('\n');
        }
        if (this.id != null) {
            sb.append("id: ").append(this.id.replace("\n", "")).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (Objects.isNull(obj) || !(obj instanceof MessageEvent)) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        MessageEvent message = (MessageEvent)obj;
        return Objects.equals(this.event, message.event) && Objects.equals(this.data, message.data) && Objects.equals(this.retry, message.retry) && Objects.equals(this.id, message.id);
    }

    public static class Builder {
        private String data = null;
        private String event = null;
        private Integer retry = null;
        private String id = null;

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder event(String event) {
            this.event = event;
            return this;
        }

        public Builder retry(Integer retry) {
            this.retry = retry;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public MessageEvent build() {
            return new MessageEvent(this.event, this.data, this.retry, this.id);
        }
    }
}

