/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ClearAttachmentsOutInterceptor;
import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.internal.PartnerAPI;
import com.exacttarget.fuelsdk.internal.Soap;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.log4j.Logger;

public class ETSoapConnection {
    private static Logger logger = Logger.getLogger(ETSoapConnection.class);
    private static final String WSSE_NAMESPACE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private String endpoint = null;
    private Soap soap = null;
    private Client soapClient = null;
    private SOAPFactory soapFactory = null;
    private SOAPElement accessTokenElement = null;

    public ETSoapConnection(ETClient client, String endpoint) throws ETSdkException {
        this.endpoint = endpoint;
        try {
            PartnerAPI service = new PartnerAPI();
            this.soap = service.getSoap();
            this.soapClient = ClientProxy.getClient((Object)this.soap);
            this.soapClient.getInInterceptors().add(new ClearAttachmentsOutInterceptor());
            this.soapClient.getOutInterceptors().add(new ClearAttachmentsOutInterceptor());
            Endpoint soapEndpoint = this.soapClient.getEndpoint();
            this.soapFactory = SOAPFactory.newInstance();
            this.soapClient.getRequestContext().put(Message.ENDPOINT_ADDRESS, endpoint);
            HTTPConduit conduit = (HTTPConduit)this.soapClient.getConduit();
            Integer cxfConnectTimeout = null;
            Integer cxfReceiveTimeout = null;
            try {
                cxfConnectTimeout = new Integer(client.getConfiguration().get("cxfConnectTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                cxfReceiveTimeout = new Integer(client.getConfiguration().get("cxfReceiveTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            HTTPClientPolicy clientPolicy = new HTTPClientPolicy();
            if (cxfConnectTimeout != null) {
                clientPolicy.setConnectionTimeout((long)cxfConnectTimeout.intValue());
            }
            if (cxfReceiveTimeout != null) {
                clientPolicy.setReceiveTimeout((long)cxfReceiveTimeout.intValue());
            }
            conduit.setClient(clientPolicy);
            if (client.getConfiguration().isTrue("cxfDisableCNCheck")) {
                TLSClientParameters tlsClientParameters = new TLSClientParameters();
                tlsClientParameters.setDisableCNCheck(true);
                conduit.setTlsClientParameters(tlsClientParameters);
            }
            this.soapClient.getRequestContext().put(Message.ENCODING, "UTF-8");
            LoggingInInterceptor loggingInInterceptor = new LoggingInInterceptor();
            loggingInInterceptor.setPrettyLogging(true);
            LoggingOutInterceptor loggingOutInterceptor = new LoggingOutInterceptor();
            loggingOutInterceptor.setPrettyLogging(true);
            soapEndpoint.getInInterceptors().add(loggingInInterceptor);
            soapEndpoint.getOutInterceptors().add(loggingOutInterceptor);
        }
        catch (SOAPException ex) {
            throw new ETSdkException("could not initialize SOAP proxy", ex);
        }
    }

    public ETSoapConnection(ETClient client, String endpoint, String username, String password) throws ETSdkException {
        this(client, endpoint);
        try {
            ArrayList<Header> headers = new ArrayList<Header>();
            SOAPElement usernameElement = this.soapFactory.createElement(new QName(WSSE_NAMESPACE_URI, "Username", "wsse"));
            usernameElement.addTextNode(username);
            SOAPElement passwordElement = this.soapFactory.createElement(new QName(WSSE_NAMESPACE_URI, "Password", "wsse"));
            passwordElement.addTextNode(password);
            SOAPElement usernameTokenElement = this.soapFactory.createElement(new QName(WSSE_NAMESPACE_URI, "UsernameToken", "wsse"));
            usernameTokenElement.addChildElement(usernameElement);
            usernameTokenElement.addChildElement(passwordElement);
            SOAPElement securityElement = this.soapFactory.createElement(new QName(WSSE_NAMESPACE_URI, "Security", "wsse"));
            securityElement.addChildElement(usernameTokenElement);
            headers.add(new Header(new QName(WSSE_NAMESPACE_URI, "Security", "wsse"), (Object)securityElement));
            this.soapClient.getRequestContext().put(Header.HEADER_LIST, headers);
        }
        catch (SOAPException ex) {
            throw new ETSdkException("could not initialize SOAP proxy", ex);
        }
    }

    public ETSoapConnection(ETClient client, String endpoint, String accessToken) throws ETSdkException {
        this(client, endpoint);
        try {
            ArrayList<Header> headers = new ArrayList<Header>();
            this.accessTokenElement = this.soapFactory.createElement(new QName(null, "fueloauth"));
            if (accessToken != null) {
                this.setAccessToken(accessToken);
            }
            headers.add(new Header(new QName(null, "fueloauth"), (Object)this.accessTokenElement));
            this.soapClient.getRequestContext().put(Header.HEADER_LIST, headers);
        }
        catch (SOAPException ex) {
            throw new ETSdkException("could not initialize SOAP proxy", ex);
        }
    }

    public Soap getSoap() {
        return this.soap;
    }

    public Soap getSoap(String m) {
        this.soapClient.getRequestContext().put("HTTP_HEADER_USER_AGENT", "FuelSDK-Java-v1.2.2-SOAP-" + m);
        return this.soap;
    }

    public Soap getSoap(String m, String o) {
        this.soapClient.getRequestContext().put("HTTP_HEADER_USER_AGENT", "FuelSDK-Java-v1.2.2-SOAP-" + m + "-" + o);
        return this.soap;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setAccessToken(String accessToken) throws ETSdkException {
        if (this.accessTokenElement != null) {
            this.accessTokenElement.removeContents();
            try {
                this.accessTokenElement.addTextNode(accessToken);
            }
            catch (SOAPException ex) {
                throw new ETSdkException("could not set access token", ex);
            }
            logger.debug((Object)("updated SOAP header with new access token " + accessToken));
        }
    }
}

