/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETApiObject;
import com.exacttarget.fuelsdk.ETConfiguration;
import com.exacttarget.fuelsdk.ETExpression;
import com.exacttarget.fuelsdk.ETFilter;
import com.exacttarget.fuelsdk.ETResponse;
import com.exacttarget.fuelsdk.ETRestConnection;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.ETSoapConnection;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ETClient {
    private static Logger logger = Logger.getLogger(ETClient.class);
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "fuelsdk.properties";
    private static final String DEFAULT_ENDPOINT = "https://www.exacttargetapis.com";
    private static final String DEFAULT_AUTH_ENDPOINT = "https://auth.exacttargetapis.com";
    private static final String PATH_REQUESTTOKEN = "/v1/requestToken";
    private static final String PATH_OAUTH2TOKEN = "/v2/token";
    private static final String PATH_ENDPOINTS_SOAP = "/platform/v1/endpoints/soap";
    private static final String DEFAULT_SOAP_ENDPOINT = "https://webservice.exacttarget.com/Service.asmx";
    private ETConfiguration configuration = null;
    private String clientId = null;
    private String clientSecret = null;
    private String endpoint = null;
    private String authEndpoint = null;
    private String soapEndpoint = null;
    private Boolean autoHydrateObjects = true;
    private Gson gson = null;
    private ETRestConnection authConnection = null;
    private ETRestConnection restConnection = null;
    private ETSoapConnection soapConnection = null;
    private String accessToken = null;
    private int expiresIn = 0;
    private String legacyToken = null;
    private String refreshToken = null;
    private long tokenExpirationTime = 0L;
    private static long soapEndpointExpiration = 0L;
    private static String fetchedSoapEndpoint = null;
    private static final long cacheDurationInMillis = 600000L;
    private boolean useOAuth2Authentication;
    private String applicationType;
    private String authorizationCode;
    private String redirectURI;

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public ETClient() throws ETSdkException {
        this(DEFAULT_PROPERTIES_FILE_NAME);
    }

    public ETClient(String file) throws ETSdkException {
        this(new ETConfiguration(file));
    }

    public ETClient(ETConfiguration configuration) throws ETSdkException {
        this.configuration = configuration;
        this.clientId = configuration.get("clientId");
        this.clientSecret = configuration.get("clientSecret");
        this.endpoint = configuration.get("endpoint");
        if (this.endpoint == null) {
            this.endpoint = DEFAULT_ENDPOINT;
        }
        this.authEndpoint = configuration.get("authEndpoint");
        if (this.authEndpoint == null) {
            this.authEndpoint = DEFAULT_AUTH_ENDPOINT;
        }
        this.soapEndpoint = configuration.get("soapEndpoint");
        GsonBuilder gsonBuilder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.gson = logger.isDebugEnabled() ? gsonBuilder.setPrettyPrinting().create() : gsonBuilder.create();
        this.useOAuth2Authentication = configuration.isTrue("useOAuth2Authentication");
        this.applicationType = configuration.get("applicationType");
        this.authorizationCode = configuration.get("authorizationCode");
        this.redirectURI = configuration.get("redirectURI");
        if (ETClient.isNullOrBlankOrEmpty(this.applicationType)) {
            this.applicationType = "server";
            configuration.set("applicationType", "server");
        }
        if ((this.applicationType.equals("public") || this.applicationType.equals("web")) && (ETClient.isNullOrBlankOrEmpty(this.authorizationCode) || ETClient.isNullOrBlankOrEmpty(this.redirectURI))) {
            throw new ETSdkException("AuthorizationCode or RedirectURI is null: For Public/Web Apps, authorizationCode and redirectURI must be provided in config file");
        }
        if (this.applicationType.equals("public")) {
            if (ETClient.isNullOrBlankOrEmpty(this.clientId)) {
                throw new ETSdkException("ClientId is null: clientId must be provided in config file");
            }
        } else if (ETClient.isNullOrBlankOrEmpty(this.clientId) || ETClient.isNullOrBlankOrEmpty(this.clientSecret)) {
            throw new ETSdkException("ClientId or ClientSecret is null: clientId and clientSecret must be provided in config file");
        }
        this.buildClients();
        if (configuration.isFalse("autoHydrateObjects")) {
            this.autoHydrateObjects = false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"ETClient initialized:");
            logger.trace((Object)("  clientId = " + this.clientId));
            logger.trace((Object)"  clientSecret = *");
            logger.trace((Object)("  endpoint = " + this.endpoint));
            logger.trace((Object)("  authEndpoint = " + this.authEndpoint));
            logger.trace((Object)("  soapEndpoint = " + this.soapEndpoint));
            logger.trace((Object)("  autoHydrateObjects = " + this.autoHydrateObjects));
        }
    }

    private void buildClients() throws ETSdkException {
        this.authConnection = new ETRestConnection(this, this.authEndpoint, true);
        this.requestToken();
        this.restConnection = new ETRestConnection(this, this.endpoint);
        this.fetchSoapEndpoint();
        this.soapConnection = new ETSoapConnection(this, this.soapEndpoint, this.accessToken);
    }

    public static boolean isNullOrBlankOrEmpty(String str) {
        return str == null || StringUtils.isBlank((String)str) || StringUtils.isEmpty((String)str);
    }

    private void fetchSoapEndpoint() {
        if (this.useOAuth2Authentication) {
            return;
        }
        if (this.soapEndpoint == null || this.soapEndpoint.equals("")) {
            try {
                if (System.currentTimeMillis() > soapEndpointExpiration || fetchedSoapEndpoint == null) {
                    ETRestConnection.Response response = this.restConnection.get(PATH_ENDPOINTS_SOAP);
                    if (response.getResponseCode() == 200) {
                        String responsePayload = response.getResponsePayload();
                        JsonParser jsonParser = new JsonParser();
                        JsonObject jsonObject = jsonParser.parse(responsePayload).getAsJsonObject();
                        fetchedSoapEndpoint = this.soapEndpoint = jsonObject.get("url").getAsString();
                        soapEndpointExpiration = System.currentTimeMillis() + 600000L;
                    } else {
                        this.soapEndpoint = DEFAULT_SOAP_ENDPOINT;
                    }
                } else {
                    this.soapEndpoint = fetchedSoapEndpoint;
                }
            }
            catch (ETSdkException ex) {
                this.soapEndpoint = DEFAULT_SOAP_ENDPOINT;
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getLegacyToken() {
        return this.accessToken;
    }

    public Boolean autoHydrateObjects() {
        return this.autoHydrateObjects;
    }

    public ETConfiguration getConfiguration() {
        return this.configuration;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ETRestConnection getRestConnection() {
        return this.restConnection;
    }

    public ETSoapConnection getSoapConnection() {
        return this.soapConnection;
    }

    @Deprecated
    public ETRestConnection getRESTConnection() {
        return this.getRestConnection();
    }

    @Deprecated
    public ETSoapConnection getSOAPConnection() {
        return this.getSoapConnection();
    }

    public synchronized String requestToken() throws ETSdkException {
        return this.requestToken(null);
    }

    private synchronized String requestOAuth2Token() throws ETSdkException {
        JsonObject payload = this.createPayload(this.configuration);
        ETRestConnection.Response response = this.authConnection.post(PATH_OAUTH2TOKEN, this.gson.toJson((JsonElement)payload));
        if (response.getResponseCode() != 200) {
            throw new ETSdkException("error obtaining OAuth2 access token (" + response.getResponseCode() + " " + response.getResponseMessage() + ")");
        }
        JsonParser jsonParser = new JsonParser();
        String responsePayload = response.getResponsePayload();
        JsonObject jsonObject = jsonParser.parse(responsePayload).getAsJsonObject();
        this.accessToken = jsonObject.get("access_token").getAsString();
        this.endpoint = jsonObject.get("rest_instance_url").getAsString();
        this.soapEndpoint = jsonObject.get("soap_instance_url").getAsString() + "service.asmx";
        this.expiresIn = jsonObject.get("expires_in").getAsInt();
        this.tokenExpirationTime = System.currentTimeMillis() + (long)(this.expiresIn * 1000);
        if (jsonObject.has("refresh_token")) {
            this.refreshToken = jsonObject.get("refresh_token").getAsString();
        }
        return this.accessToken;
    }

    JsonObject createPayload(ETConfiguration configuration) {
        JsonObject payload = new JsonObject();
        payload.addProperty("client_id", configuration.get("clientId"));
        String applicationType = configuration.get("applicationType");
        if (applicationType.equals("web") || applicationType.equals("server")) {
            payload.addProperty("client_secret", configuration.get("clientSecret"));
        }
        if (!ETClient.isNullOrBlankOrEmpty(this.refreshToken)) {
            payload.addProperty("grant_type", "refresh_token");
            payload.addProperty("refresh_token", this.refreshToken);
        } else if (applicationType.equals("public") || applicationType.equals("web")) {
            payload.addProperty("grant_type", "authorization_code");
            payload.addProperty("code", configuration.get("authorizationCode"));
            payload.addProperty("redirect_uri", configuration.get("redirectURI"));
        } else {
            payload.addProperty("grant_type", "client_credentials");
        }
        if (!ETClient.isNullOrBlankOrEmpty(configuration.get("accountId"))) {
            payload.addProperty("account_id", configuration.get("accountId"));
        }
        if (!ETClient.isNullOrBlankOrEmpty(configuration.get("scope"))) {
            payload.addProperty("scope", configuration.get("scope"));
        }
        return payload;
    }

    public synchronized String requestToken(String refreshToken) throws ETSdkException {
        if (this.useOAuth2Authentication) {
            return this.requestOAuth2Token();
        }
        if (this.clientId == null || this.clientSecret == null) {
            return null;
        }
        logger.debug((Object)"requesting access token...");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("clientId", this.clientId);
        jsonObject.addProperty("clientSecret", this.clientSecret);
        jsonObject.addProperty("accessType", this.configuration.get("accessType") != null ? this.configuration.get("accessType") : "online");
        if (this.configuration.get("accessType") != null && this.configuration.get("accessType").equals("offline") && refreshToken != null) {
            jsonObject.addProperty("refreshToken", refreshToken);
        }
        String requestPayload = this.gson.toJson((JsonElement)jsonObject);
        ETRestConnection.Response response = null;
        response = this.authConnection.post(PATH_REQUESTTOKEN, requestPayload);
        if (response.getResponseCode() != 200) {
            throw new ETSdkException("error obtaining access token (" + response.getResponseCode() + " " + response.getResponseMessage() + ")");
        }
        String responsePayload = response.getResponsePayload();
        JsonParser jsonParser = new JsonParser();
        jsonObject = jsonParser.parse(responsePayload).getAsJsonObject();
        logger.debug((Object)"received token:");
        this.accessToken = jsonObject.get("accessToken").getAsString();
        logger.debug((Object)("  accessToken: " + this.accessToken));
        this.expiresIn = jsonObject.get("expiresIn").getAsInt();
        logger.debug((Object)("  expiresIn: " + this.expiresIn));
        JsonElement jsonElement = jsonObject.get("legacyToken");
        if (jsonElement != null) {
            this.legacyToken = jsonElement.getAsString();
        }
        logger.debug((Object)("  legacyToken: " + this.legacyToken));
        if (jsonObject.get("refreshToken") != null) {
            this.refreshToken = jsonObject.get("refreshToken").getAsString();
        }
        logger.debug((Object)("  refreshToken: " + this.refreshToken));
        this.tokenExpirationTime = System.currentTimeMillis() + (long)(this.expiresIn * 1000);
        logger.debug((Object)("access token expires at " + new Date(this.tokenExpirationTime)));
        return this.accessToken;
    }

    public synchronized String refreshToken() throws ETSdkException {
        if (this.tokenExpirationTime > 0L) {
            logger.debug((Object)("access token expires at " + new Date(this.tokenExpirationTime)));
            if (this.tokenExpirationTime - System.currentTimeMillis() > 300000L) {
                logger.debug((Object)"not refreshing access token");
                return this.accessToken;
            }
            logger.debug((Object)"refreshing access token...");
        }
        this.requestToken(this.refreshToken);
        if (this.soapConnection != null) {
            this.soapConnection.setAccessToken(this.accessToken);
        }
        return this.accessToken;
    }

    public <T extends ETApiObject> T instantiate(Class<T> type) throws ETSdkException {
        ETApiObject object = null;
        try {
            object = (ETApiObject)type.newInstance();
        }
        catch (Exception ex) {
            throw new ETSdkException("could not instantiate " + type.getName(), ex);
        }
        object.setClient(this);
        return (T)object;
    }

    public <T extends ETApiObject> ETResponse<T> retrieve(Class<T> type, ETFilter filter) throws ETSdkException {
        return this.retrieve(type, null, null, filter);
    }

    public <T extends ETApiObject> ETResponse<T> retrieve(Class<T> type, String ... filter) throws ETSdkException {
        return this.retrieve(type, null, null, ETFilter.parse(filter));
    }

    public <T extends ETApiObject> ETResponse<T> retrieve(Class<T> type, Integer page, Integer pageSize, ETFilter filter) throws ETSdkException {
        Method retrieve = null;
        for (Class<T> t = type; t != null; t = t.getSuperclass()) {
            try {
                retrieve = t.getDeclaredMethod("retrieve", ETClient.class, Class.class, Integer.class, Integer.class, ETFilter.class);
                if (retrieve == null) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (retrieve == null) {
            throw new ETSdkException("could not find retrieve method for type " + type);
        }
        ETResponse response = null;
        try {
            response = (ETResponse)retrieve.invoke(null, this, type, page, pageSize, filter);
        }
        catch (Exception ex) {
            throw new ETSdkException("error invoking retrieve method for type " + type, ex);
        }
        return response;
    }

    public <T extends ETApiObject> ETResponse<T> retrieve(Class<T> type, Integer page, Integer pageSize, String ... filter) throws ETSdkException {
        return this.retrieve(type, page, pageSize, ETFilter.parse(filter));
    }

    @Deprecated
    public <T extends ETApiObject> ETResponse<T> retrieve(Class<T> type, ETFilter filter, String ... properties) throws ETSdkException {
        ETFilter f = new ETFilter();
        f.setExpression(filter.getExpression());
        for (String property : properties) {
            f.addProperty(property);
        }
        return this.retrieve(type, null, null, f);
    }

    @Deprecated
    public <T extends ETApiObject> ETResponse<T> retrieve(Class<T> type, ETFilter filter, Integer page, Integer pageSize, String ... properties) throws ETSdkException {
        ETFilter f = new ETFilter();
        f.setExpression(filter.getExpression());
        for (String property : properties) {
            f.addProperty(property);
        }
        return this.retrieve(type, page, pageSize, f);
    }

    @Deprecated
    public <T extends ETApiObject> ETResponse<T> retrieve(Class<T> type, String filter, Integer page, Integer pageSize, String ... properties) throws ETSdkException {
        ETFilter f = new ETFilter();
        f.setExpression(ETExpression.parse(filter));
        for (String property : properties) {
            f.addProperty(property);
        }
        return this.retrieve(type, page, pageSize, f);
    }

    public <T extends ETApiObject> T retrieveObject(Class<T> type, ETFilter filter) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter);
        if (response == null) {
            return null;
        }
        return response.getObject();
    }

    public <T extends ETApiObject> T retrieveObject(Class<T> type, String ... filter) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter);
        if (response == null) {
            return null;
        }
        return response.getObject();
    }

    @Deprecated
    public <T extends ETApiObject> T retrieveObject(Class<T> type, ETFilter filter, String ... properties) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter, properties);
        if (response == null) {
            return null;
        }
        return response.getObject();
    }

    public <T extends ETApiObject> List<T> retrieveObjects(Class<T> type, ETFilter filter) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter);
        if (response == null) {
            return null;
        }
        return response.getObjects();
    }

    public <T extends ETApiObject> List<T> retrieveObjects(Class<T> type, String ... filter) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter);
        if (response == null) {
            return null;
        }
        return response.getObjects();
    }

    public <T extends ETApiObject> List<T> retrieveObjects(Class<T> type, Integer page, Integer pageSize, ETFilter filter) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, page, pageSize, filter);
        if (response == null) {
            return null;
        }
        return response.getObjects();
    }

    public <T extends ETApiObject> List<T> retrieveObjects(Class<T> type, Integer page, Integer pageSize, String ... filter) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, page, pageSize, filter);
        if (response == null) {
            return null;
        }
        return response.getObjects();
    }

    @Deprecated
    public <T extends ETApiObject> List<T> retrieveObjects(Class<T> type, ETFilter filter, String ... properties) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter, properties);
        if (response == null) {
            return null;
        }
        return response.getObjects();
    }

    @Deprecated
    public <T extends ETApiObject> List<T> retrieveObjects(Class<T> type, ETFilter filter, Integer page, Integer pageSize, String ... properties) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter, page, pageSize, properties);
        if (response == null) {
            return null;
        }
        return response.getObjects();
    }

    @Deprecated
    public <T extends ETApiObject> List<T> retrieveObjects(Class<T> type, String filter, Integer page, Integer pageSize, String ... properties) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter, page, pageSize, properties);
        if (response == null) {
            return null;
        }
        return response.getObjects();
    }

    public <T extends ETApiObject> ETResponse<T> create(T ... objects) throws ETSdkException {
        return this.createUpdateDelete("create", Arrays.asList(objects));
    }

    public <T extends ETApiObject> ETResponse<T> create(List<T> objects) throws ETSdkException {
        return this.createUpdateDelete("create", objects);
    }

    public <T extends ETApiObject> ETResponse<T> update(T ... objects) throws ETSdkException {
        return this.createUpdateDelete("update", Arrays.asList(objects));
    }

    public <T extends ETApiObject> ETResponse<T> update(List<T> objects) throws ETSdkException {
        return this.createUpdateDelete("update", objects);
    }

    public <T extends ETApiObject> ETResponse<T> delete(T ... objects) throws ETSdkException {
        return this.createUpdateDelete("delete", Arrays.asList(objects));
    }

    public <T extends ETApiObject> ETResponse<T> delete(List<T> objects) throws ETSdkException {
        return this.createUpdateDelete("delete", objects);
    }

    public <T extends ETApiObject> ETResponse<T> update(Class<T> type, String filter, String ... values) throws ETSdkException {
        ETResponse<T> response = this.retrieve(type, filter);
        List<T> objects = response.getObjects();
        for (ETApiObject object : objects) {
            for (String value : values) {
                ETExpression expression = ETExpression.parse(value);
                Field field = object.getField(expression.getProperty());
                try {
                    boolean isAccessible = field.isAccessible();
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    field.set(object, expression.getValue());
                    field.setAccessible(isAccessible);
                }
                catch (Exception ex) {
                    throw new ETSdkException("could not update property \"" + expression.getProperty() + "\" to value \"" + value + "\" on object " + object, ex);
                }
            }
        }
        return this.update(objects);
    }

    public <T extends ETApiObject> ETResponse<T> delete(Class<T> type, ETFilter filter) throws ETSdkException {
        ETExpression expression = filter.getExpression();
        if (expression.getOperator() == ETExpression.Operator.EQUALS && expression.getProperty().equals("id")) {
            ETApiObject object = null;
            try {
                object = (ETApiObject)type.newInstance();
            }
            catch (Exception ex) {
                throw new ETSdkException("could not instantiate " + type.getName(), ex);
            }
            object.setId(expression.getValue());
            ArrayList<ETApiObject> objects = new ArrayList<ETApiObject>();
            objects.add(object);
            return this.delete((List<T>)objects);
        }
        ETResponse<T> response = this.retrieve(type, filter);
        return this.delete(response.getObjects());
    }

    public <T extends ETApiObject> ETResponse<T> delete(Class<T> type, String filter) throws ETSdkException {
        return this.delete(type, ETFilter.parse(filter));
    }

    private <T extends ETApiObject> ETResponse<T> createUpdateDelete(String method, List<T> objects) throws ETSdkException {
        Class<?> type = ((ETApiObject)objects.get(0)).getClass();
        Method m = null;
        for (Class<?> t = type; t != null; t = t.getSuperclass()) {
            try {
                m = t.getDeclaredMethod(method, ETClient.class, List.class);
                if (m == null) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m == null) {
            throw new ETSdkException("could not find " + method + " method for type " + type);
        }
        ETResponse response = null;
        try {
            response = (ETResponse)m.invoke(null, this, objects);
        }
        catch (Exception ex) {
            throw new ETSdkException("error invoking " + method + " method for type " + type, ex);
        }
        return response;
    }
}

