/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETSdkException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ETConfiguration {
    private static Logger logger = Logger.getLogger(ETConfiguration.class);
    private Properties properties = new Properties();

    public ETConfiguration() {
    }

    public ETConfiguration(String file) throws ETSdkException {
        logger.trace((Object)("reading configuration from " + file));
        InputStream is = this.getClass().getResourceAsStream(file);
        if (is == null) {
            try {
                is = new FileInputStream(new File(file));
            }
            catch (FileNotFoundException ex) {
                throw new ETSdkException("error opening " + file, ex);
            }
        }
        try {
            this.properties.load(is);
        }
        catch (IOException ex) {
            throw new ETSdkException("error reading " + file, ex);
        }
        if (logger.isTraceEnabled()) {
            for (String property : this.properties.stringPropertyNames()) {
                logger.trace((Object)("  " + property + " = " + this.get(property)));
            }
        }
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public boolean equals(String key, String value) {
        String v = this.get(key);
        if (v == null) {
            return false;
        }
        return v.equals(value);
    }

    public boolean notEquals(String key, String value) {
        String v = this.get(key);
        if (v == null) {
            return true;
        }
        return !v.equals(value);
    }

    public boolean isTrue(String key) {
        String value = this.get(key);
        return value != null && value.toLowerCase().equals("true");
    }

    public boolean isFalse(String key) {
        String value = this.get(key);
        return value != null && value.toLowerCase().equals("false");
    }

    @Deprecated
    public String getClientId() {
        return this.get("clientId");
    }

    @Deprecated
    public void setClientId(String clientId) {
        this.set("clientId", clientId);
    }

    @Deprecated
    public String getClientSecret() {
        return this.get("clientSecret");
    }

    @Deprecated
    public void setClientSecret(String clientSecret) {
        this.set("clientSecret", clientSecret);
    }

    @Deprecated
    public String getEndpoint() {
        return this.get("endpoint");
    }

    @Deprecated
    public void setEndpoint(String endpoint) {
        this.set("endpoint", endpoint);
    }

    @Deprecated
    public String getAuthEndpoint() {
        return this.get("authEndpoint");
    }

    @Deprecated
    public void setAuthEndpoint(String authEndpoint) {
        this.set("authEndpoint", authEndpoint);
    }

    @Deprecated
    public String getSoapEndpoint() {
        return this.get("soapEndpoint");
    }

    @Deprecated
    public void setSoapEndpoint(String soapEndpoint) {
        this.set("soapEndpoint", soapEndpoint);
    }
}

