/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETExtractDescription;
import com.exacttarget.fuelsdk.ETResponse;
import com.exacttarget.fuelsdk.ETResult;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.internal.ExtractOptions;
import com.exacttarget.fuelsdk.internal.ExtractParameter;
import com.exacttarget.fuelsdk.internal.ExtractRequest;
import com.exacttarget.fuelsdk.internal.ExtractRequestMsg;
import com.exacttarget.fuelsdk.internal.ExtractResponseMsg;
import com.exacttarget.fuelsdk.internal.Soap;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ETDataExtract {
    private Soap soap;
    public HashMap<String, String> extractType;
    private SimpleDateFormat dateFormat;
    private Date StartDate;
    private Date EndDate;
    private String DECustomerKey;
    private String _AsyncID;
    private String OutputFileName;
    private boolean HasColumnHeaders;
    private boolean ExtractBounces;
    private boolean ExtractClicks;
    private boolean ExtractConversions;
    private boolean ExtractOpens;
    private boolean ExtractSends;
    private boolean ExtractSendJobs;
    private boolean ExtractSurveyResponses;
    private boolean IncludeTestSends;
    private boolean ExtractUnsubs;

    public ETDataExtract(ETClient client) {
        try {
            this.extractType = new HashMap();
            this.soap = client.getSoapConnection().getSoap("Extract");
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm aa");
            this.ExtractBounces = false;
            this.ExtractClicks = true;
            this.ExtractConversions = true;
            this.ExtractOpens = true;
            this.ExtractSendJobs = true;
            this.ExtractSends = true;
            this.ExtractSurveyResponses = true;
            this.IncludeTestSends = false;
            this.ExtractUnsubs = true;
            this.HasColumnHeaders = true;
            this._AsyncID = "0";
            this.populateExtractType(client);
        }
        catch (Exception ex) {
            Logger.getLogger(ETDataExtract.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ExtractResponseMsg extractDataExtension(String deCustomerKey, String outputFileName, boolean hasColumnHeaders) throws Exception {
        this.setDECustomerKey(deCustomerKey);
        this.setHasColumnHeaders(hasColumnHeaders);
        this.setOutputFileName(outputFileName);
        return this.extractDataExtension();
    }

    public ExtractResponseMsg extractDataExtension() throws Exception {
        this.validate();
        String dateInString = "2017-08-01 12:00 AM";
        this.StartDate = this.dateFormat.parse(dateInString);
        this.EndDate = this.dateFormat.parse(dateInString);
        String[] paramNames = new String[]{"DECustomerKey", "HasColumnHeaders", "_AsyncID", "OutputFileName", "StartDate", "EndDate"};
        return this.performDataExtract("Data Extension Extract", paramNames);
    }

    public ExtractResponseMsg extractTrackingData() throws Exception {
        this.validateTrackingDataParams();
        String[] paramNames = new String[]{"ExtractClicks", "ExtractBounces", "ExtractConversions", "ExtractSendJobs", "ExtractSends", "ExtractSurveyResponses", "IncludeTestSends", "ExtractUnsubs", "ExtractOpens", "OutputFileName", "StartDate", "EndDate"};
        return this.performDataExtract("Tracking Extract", paramNames);
    }

    private ExtractResponseMsg performDataExtract(String extractName, String[] paramNames) throws Exception {
        ArrayList<ExtractParameter> extractParameters = new ArrayList<ExtractParameter>();
        ExtractParameter extractParam = null;
        Class<ETDataExtract> obj = ETDataExtract.class;
        for (String param : paramNames) {
            Field field = obj.getDeclaredField(param);
            Object value = field.get(this);
            extractParam = new ExtractParameter();
            extractParam.setName(field.getName());
            if (value instanceof Date) {
                extractParam.setValue(this.dateFormat.format(value));
            } else {
                if (value == null) continue;
                extractParam.setValue(value.toString());
            }
            extractParameters.add(extractParam);
        }
        ExtractRequest.Parameters eparams = new ExtractRequest.Parameters();
        eparams.getParameter().addAll(extractParameters);
        ExtractRequest request = new ExtractRequest();
        request.setOptions(new ExtractOptions());
        request.setID(this.extractType.get(extractName));
        request.setParameters(eparams);
        ExtractRequestMsg erm = new ExtractRequestMsg();
        erm.getRequests().add(request);
        ExtractResponseMsg resp = this.soap.extract(erm);
        return resp;
    }

    private void validate() throws ETSdkException {
        if (this.getDECustomerKey() == null || this.getOutputFileName() == null) {
            throw new ETSdkException("Customer Key and Output file name needs to be set.");
        }
        String ext = this.getOutputFileName().toLowerCase();
        if (!ext.endsWith(".csv") && !ext.endsWith(".zip")) {
            throw new ETSdkException("Invalid file extension. Only csv or zip allowed.");
        }
    }

    private void validateTrackingDataParams() throws ETSdkException {
        if (this.getOutputFileName() == null || this.getOutputFileName().trim() == "") {
            throw new ETSdkException("Output file name can not be empty or null.");
        }
        String ext = this.getOutputFileName().toLowerCase();
        if (!ext.endsWith(".zip")) {
            throw new ETSdkException("Invalid file extension. Only zip allowed.");
        }
    }

    private void populateExtractType(ETClient client) throws ETSdkException {
        ETResponse<ETExtractDescription> response = client.retrieve(ETExtractDescription.class, new String[0]);
        for (ETResult<ETExtractDescription> r : response.getResults()) {
            this.extractType.put(r.getObject().getName(), r.getObject().getId());
        }
    }

    public String getOutputFileName() {
        return this.OutputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.OutputFileName = outputFileName;
    }

    public void setStartDate(Date StartDate) {
        this.StartDate = StartDate;
    }

    public void setEndDate(Date EndDate) {
        this.EndDate = EndDate;
    }

    public String getDECustomerKey() {
        return this.DECustomerKey;
    }

    public void setDECustomerKey(String DECustomerKey) {
        this.DECustomerKey = DECustomerKey;
    }

    public boolean isExtractBounces() {
        return this.ExtractBounces;
    }

    public void setExtractBounces(boolean ExtractBounces) {
        this.ExtractBounces = ExtractBounces;
    }

    public boolean isExtractClicks() {
        return this.ExtractClicks;
    }

    public void setExtractClicks(boolean ExtractClicks) {
        this.ExtractClicks = ExtractClicks;
    }

    public boolean isExtractConversions() {
        return this.ExtractConversions;
    }

    public void setExtractConversions(boolean ExtractConversions) {
        this.ExtractConversions = ExtractConversions;
    }

    public boolean isExtractOpens() {
        return this.ExtractOpens;
    }

    public void setExtractOpens(boolean ExtractOpens) {
        this.ExtractOpens = ExtractOpens;
    }

    public boolean isExtractSends() {
        return this.ExtractSends;
    }

    public void setExtractSends(boolean ExtractSends) {
        this.ExtractSends = ExtractSends;
    }

    public boolean isExtractSendJobs() {
        return this.ExtractSendJobs;
    }

    public void setExtractSendJobs(boolean ExtractSendJobs) {
        this.ExtractSendJobs = ExtractSendJobs;
    }

    public boolean isExtractSurveyResponses() {
        return this.ExtractSurveyResponses;
    }

    public void setExtractSurveyResponses(boolean ExtractSurveyResponses) {
        this.ExtractSurveyResponses = ExtractSurveyResponses;
    }

    public boolean isIncludeTestSends() {
        return this.IncludeTestSends;
    }

    public void setIncludeTestSends(boolean IncludeTestSends) {
        this.IncludeTestSends = IncludeTestSends;
    }

    public boolean isExtractUnsubs() {
        return this.ExtractUnsubs;
    }

    public void setExtractUnsubs(boolean ExtractUnsubs) {
        this.ExtractUnsubs = ExtractUnsubs;
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public Date getEndDate() {
        return this.EndDate;
    }

    public String getAsyncID() {
        return this._AsyncID;
    }

    private void setAsyncID(String _AsyncID) {
        this._AsyncID = _AsyncID;
    }

    public boolean isHasColumnHeaders() {
        return this.HasColumnHeaders;
    }

    public void setHasColumnHeaders(boolean HasColumnHeaders) {
        this.HasColumnHeaders = HasColumnHeaders;
    }
}

