/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETExpressionParser;
import com.exacttarget.fuelsdk.ETObject;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.ParseException;
import com.exacttarget.fuelsdk.annotations.PrettyPrint;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ETExpression
extends ETObject {
    private static Logger logger = Logger.getLogger(ETExpression.class);
    @PrettyPrint
    private String property = null;
    @PrettyPrint
    private Operator operator = null;
    @PrettyPrint
    private List<String> values = new ArrayList<String>();
    @PrettyPrint
    private List<ETExpression> subexpressions = new ArrayList<ETExpression>();

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void setOperator(String operator) {
        this.operator = Operator.fromValue(operator);
    }

    public String getValue() {
        if (this.values.size() > 1) {
            logger.warn((Object)"getValue() called on expression with values > 1");
        }
        return this.values.get(0);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValue(String value) {
        this.values.clear();
        this.values.add(value);
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public List<ETExpression> getSubexpressions() {
        return this.subexpressions;
    }

    public void addSubexpression(ETExpression expression) {
        this.subexpressions.add(expression);
    }

    public static ETExpression parse(String s) throws ETSdkException {
        ETExpressionParser parser = new ETExpressionParser(new ByteArrayInputStream(s.getBytes()));
        ETExpression expression = null;
        try {
            expression = parser.parse();
        }
        catch (ParseException ex) {
            throw new ETSdkException("could not parse expression: " + s, ex);
        }
        return expression;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.operator != null) {
            switch (this.operator) {
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUALS: 
                case IN: 
                case BETWEEN: 
                case LIKE: {
                    stringBuilder.append(this.property);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.operator.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(this.values);
                    break;
                }
                case IS_NULL: 
                case IS_NOT_NULL: {
                    stringBuilder.append(this.property);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.operator.toString());
                    break;
                }
                case AND: 
                case OR: {
                    stringBuilder.append(this.subexpressions.get(0));
                    stringBuilder.append(" ");
                    stringBuilder.append(this.operator.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(this.subexpressions.get(1));
                    break;
                }
                case NOT: {
                    stringBuilder.append(this.operator.toString());
                    stringBuilder.append(" ");
                    stringBuilder.append(this.subexpressions.get(0));
                }
            }
        } else if (!this.subexpressions.isEmpty()) {
            stringBuilder.append("(");
            stringBuilder.append(this.subexpressions.get(0));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static enum Operator {
        EQUALS("="),
        NOT_EQUALS("!="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUALS("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUALS(">="),
        IS_NULL("is null"),
        IS_NOT_NULL("is not null"),
        IN("in"),
        BETWEEN("between"),
        LIKE("like"),
        AND("and"),
        OR("or"),
        NOT("not");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Operator fromValue(String value) {
            for (Operator v : Operator.values()) {
                if (!v.value.equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException(value);
        }
    }
}

