/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETExpression;
import com.exacttarget.fuelsdk.ETObject;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.ParseException;
import com.exacttarget.fuelsdk.annotations.PrettyPrint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ETFilter
extends ETObject {
    @PrettyPrint
    private ETExpression expression = new ETExpression();
    @PrettyPrint
    private List<String> orderBy = new ArrayList<String>();
    @PrettyPrint
    private List<String> properties = new ArrayList<String>();
    @PrettyPrint
    private Boolean orderByAsc = true;

    public ETExpression getExpression() {
        return this.expression;
    }

    public void setExpression(ETExpression expression) {
        this.expression = expression;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List<String> orderBy) {
        this.orderBy = orderBy;
    }

    public Boolean getOrderByAsc() {
        return this.orderByAsc;
    }

    public void setOrderByAsc(Boolean orderByAsc) {
        this.orderByAsc = orderByAsc;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public void addProperty(String property) {
        this.properties.add(property);
    }

    public static ETFilter parse(String ... s) throws ETSdkException {
        ETFilter filter = new ETFilter();
        for (String t : s) {
            try {
                filter.setExpression(ETExpression.parse(t));
            }
            catch (ETSdkException ex) {
                if (ex.getCause() instanceof ParseException) {
                    if (t.length() >= 8 && t.substring(0, 8).toLowerCase().equals("order by")) {
                        String[] tokens = t.substring(9).split(" ");
                        if (tokens.length > 1 && tokens[1].toLowerCase().equals("desc")) {
                            filter.setOrderByAsc(false);
                        }
                        filter.setOrderBy(Arrays.asList(tokens[0].split(",")));
                        continue;
                    }
                    filter.addProperty(t);
                    continue;
                }
                throw ex;
            }
        }
        return filter;
    }

    @Deprecated
    public String getProperty() {
        return this.expression.getProperty();
    }

    @Deprecated
    public void setProperty(String property) {
        this.expression.setProperty(property);
    }

    @Deprecated
    public Operator getOperator() {
        ETExpression.Operator operator = this.expression.getOperator();
        switch (operator) {
            case AND: {
                return Operator.AND;
            }
            case BETWEEN: {
                return Operator.BETWEEN;
            }
            case EQUALS: {
                return Operator.EQUALS;
            }
            case GREATER_THAN: {
                return Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUALS: {
                return Operator.GREATER_THAN_OR_EQUALS;
            }
            case IN: {
                return Operator.IN;
            }
            case IS_NULL: {
                return Operator.IS_NULL;
            }
            case IS_NOT_NULL: {
                return Operator.IS_NOT_NULL;
            }
            case LESS_THAN: {
                return Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUALS: {
                return Operator.LESS_THAN_OR_EQUALS;
            }
            case LIKE: {
                return Operator.LIKE;
            }
            case NOT: {
                return Operator.NOT;
            }
            case NOT_EQUALS: {
                return Operator.NOT_EQUALS;
            }
            case OR: {
                return Operator.OR;
            }
        }
        return null;
    }

    @Deprecated
    public void setOperator(Operator operator) {
        switch (operator) {
            case AND: {
                this.expression.setOperator(ETExpression.Operator.AND);
                break;
            }
            case BETWEEN: {
                this.expression.setOperator(ETExpression.Operator.BETWEEN);
                break;
            }
            case EQUALS: {
                this.expression.setOperator(ETExpression.Operator.EQUALS);
                break;
            }
            case GREATER_THAN: {
                this.expression.setOperator(ETExpression.Operator.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                this.expression.setOperator(ETExpression.Operator.GREATER_THAN_OR_EQUALS);
                break;
            }
            case IN: {
                this.expression.setOperator(ETExpression.Operator.IN);
                break;
            }
            case IS_NULL: {
                this.expression.setOperator(ETExpression.Operator.IS_NULL);
                break;
            }
            case IS_NOT_NULL: {
                this.expression.setOperator(ETExpression.Operator.IS_NOT_NULL);
                break;
            }
            case LESS_THAN: {
                this.expression.setOperator(ETExpression.Operator.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                this.expression.setOperator(ETExpression.Operator.LESS_THAN_OR_EQUALS);
                break;
            }
            case LIKE: {
                this.expression.setOperator(ETExpression.Operator.LIKE);
                break;
            }
            case NOT: {
                this.expression.setOperator(ETExpression.Operator.NOT);
                break;
            }
            case NOT_EQUALS: {
                this.expression.setOperator(ETExpression.Operator.NOT_EQUALS);
                break;
            }
            case OR: {
                this.expression.setOperator(ETExpression.Operator.OR);
            }
        }
    }

    @Deprecated
    public String getValue() {
        return this.expression.getValue();
    }

    @Deprecated
    public List<String> getValues() {
        return this.expression.getValues();
    }

    @Deprecated
    public void addValue(String value) {
        this.expression.addValue(value);
    }

    @Deprecated
    public List<ETFilter> getFilters() {
        ArrayList<ETFilter> filters = new ArrayList<ETFilter>();
        List<ETExpression> subexpressions = this.expression.getSubexpressions();
        for (ETExpression subexpression : subexpressions) {
            ETFilter filter = new ETFilter();
            filter.setExpression(subexpression);
            filters.add(filter);
        }
        return filters;
    }

    @Deprecated
    public void addFilter(ETFilter filter) {
        this.expression.addSubexpression(filter.getExpression());
    }

    @Deprecated
    public static enum Operator {
        EQUALS("="),
        NOT_EQUALS("!="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUALS("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUALS(">="),
        IS_NULL("is null"),
        IS_NOT_NULL("is not null"),
        IN("in"),
        BETWEEN("between"),
        LIKE("like"),
        AND("and"),
        OR("or"),
        NOT("not");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Operator fromValue(String value) {
            for (Operator v : Operator.values()) {
                if (!v.value.equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException(value);
        }
    }
}

