/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETApiObject;
import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETExpression;
import com.exacttarget.fuelsdk.ETFilter;
import com.exacttarget.fuelsdk.ETResponse;
import com.exacttarget.fuelsdk.ETRestConnection;
import com.exacttarget.fuelsdk.ETResult;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.annotations.RestObject;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ETRestObject
extends ETApiObject {
    private static Logger logger = Logger.getLogger(ETRestObject.class);

    public static <T extends ETRestObject> ETResponse<T> retrieve(ETClient client, Class<T> type, Integer page, Integer pageSize, ETFilter filter) throws ETSdkException {
        String s;
        ETResponse response = new ETResponse();
        ETRestConnection connection = client.getRestConnection();
        client.refreshToken();
        RestObject annotations = type.getAnnotation(RestObject.class);
        assert (annotations != null);
        String path = annotations.path();
        String primaryKey = annotations.primaryKey();
        String collection = annotations.collection();
        String totalCount = annotations.totalCount();
        logger.trace((Object)("path: " + path));
        logger.trace((Object)("primaryKey: " + primaryKey));
        logger.trace((Object)("collection: " + collection));
        logger.trace((Object)("totalCount: " + totalCount));
        StringBuilder stringBuilder = new StringBuilder(path);
        boolean firstQueryParameter = true;
        if (page != null && pageSize != null) {
            firstQueryParameter = false;
            stringBuilder.append("?");
            stringBuilder.append("$page=");
            stringBuilder.append(page);
            stringBuilder.append("&");
            stringBuilder.append("$pagesize=");
            stringBuilder.append(pageSize);
        }
        logger.trace((Object)("filter: " + filter));
        ETExpression expression = filter.getExpression();
        if (expression.getOperator() != null) {
            logger.trace((Object)("expression: " + filter.getExpression()));
            if (expression.getOperator() == ETExpression.Operator.EQUALS && expression.getProperty().equals(primaryKey)) {
                s = "/" + expression.getValue();
                stringBuilder.append(s);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("appended primary key: " + s));
                }
            } else {
                if (firstQueryParameter) {
                    firstQueryParameter = false;
                    stringBuilder.append("?");
                } else {
                    stringBuilder.append("&");
                }
                Method method = null;
                try {
                    method = type.getMethod("toFilterString", ETExpression.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException ex) {
                    throw new ETSdkException(ex);
                }
                if (method != null) {
                    try {
                        String s2 = (String)method.invoke(null, expression);
                        stringBuilder.append(s2);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("appended $filter: " + s2));
                        }
                    }
                    catch (Exception ex) {
                        throw new ETSdkException(ex);
                    }
                }
            }
        }
        if (filter.getOrderBy().size() != 0) {
            s = null;
            boolean firstOrderBy = true;
            for (String orderBy : filter.getOrderBy()) {
                if (firstOrderBy) {
                    firstOrderBy = false;
                    if (firstQueryParameter) {
                        firstQueryParameter = false;
                        stringBuilder.append("?");
                    } else {
                        stringBuilder.append("&");
                    }
                    s = "$orderby=";
                } else {
                    s = s + ",";
                }
                s = s + orderBy;
                if (filter.getOrderByAsc().booleanValue()) {
                    s = s + "%20asc";
                    continue;
                }
                s = s + "%20desc";
            }
            stringBuilder.append(s);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("appended $orderby: " + s));
            }
        }
        if (filter.getProperties().size() != 0) {
            s = null;
            boolean firstProperty = true;
            for (String property : filter.getProperties()) {
                if (firstProperty) {
                    firstProperty = false;
                    if (firstQueryParameter) {
                        firstQueryParameter = false;
                        stringBuilder.append("?");
                    } else {
                        stringBuilder.append("&");
                    }
                    s = "$fields=";
                } else {
                    s = s + ",";
                }
                s = s + property;
            }
            stringBuilder.append(s);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("appended $fields: " + s));
            }
        }
        path = stringBuilder.toString();
        logger.trace((Object)("GET " + path));
        ETRestConnection.Response r = connection.get(path);
        response.setRequestId(r.getRequestId());
        if (r.getResponseCode() >= 200 && r.getResponseCode() <= 299) {
            response.setStatus(ETResult.Status.OK);
        } else if (r.getResponseCode() >= 400 && r.getResponseCode() <= 599) {
            response.setStatus(ETResult.Status.ERROR);
        }
        response.setResponseCode(r.getResponseCode().toString());
        response.setResponseMessage(r.getResponseMessage());
        Gson gson = client.getGson();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(r.getResponsePayload()).getAsJsonObject();
        if (jsonObject.get("page") != null) {
            response.setPage(jsonObject.get("page").getAsInt());
            logger.trace((Object)("page = " + response.getPage()));
            response.setPageSize(jsonObject.get("pageSize").getAsInt());
            logger.trace((Object)("pageSize = " + response.getPageSize()));
            response.setTotalCount(jsonObject.get(totalCount).getAsInt());
            logger.trace((Object)("totalCount = " + response.getTotalCount()));
            if (response.getPage() * response.getPageSize() < response.getTotalCount()) {
                response.setMoreResults(true);
            }
            JsonArray elements = jsonObject.get(collection).getAsJsonArray();
            for (JsonElement element : elements) {
                ETRestObject object = (ETRestObject)gson.fromJson(element, type);
                object.setClient(client);
                ETResult<ETRestObject> result = new ETResult<ETRestObject>();
                result.setObject(object);
                response.addResult(result);
            }
        } else {
            ETRestObject object = (ETRestObject)gson.fromJson((JsonElement)jsonObject, type);
            object.setClient(client);
            ETResult<ETRestObject> result = new ETResult<ETRestObject>();
            result.setObject(object);
            response.addResult(result);
        }
        return response;
    }

    public static <T extends ETRestObject> ETResponse<T> create(ETClient client, List<T> objects) throws ETSdkException {
        return ETRestObject.createUpdateDelete(client, ETRestConnection.Method.POST, objects);
    }

    public static <T extends ETRestObject> ETResponse<T> update(ETClient client, List<T> objects) throws ETSdkException {
        return ETRestObject.createUpdateDelete(client, ETRestConnection.Method.PATCH, objects);
    }

    public static <T extends ETRestObject> ETResponse<T> delete(ETClient client, List<T> objects) throws ETSdkException {
        return ETRestObject.createUpdateDelete(client, ETRestConnection.Method.DELETE, objects);
    }

    private static <T extends ETRestObject> ETResponse<T> createUpdateDelete(ETClient client, ETRestConnection.Method method, List<T> objects) throws ETSdkException {
        ETResponse response = new ETResponse();
        if (objects == null || objects.size() == 0) {
            response.setStatus(ETResult.Status.OK);
            return response;
        }
        ETRestConnection connection = client.getRestConnection();
        client.refreshToken();
        RestObject annotations = ((ETRestObject)objects.get(0)).getClass().getAnnotation(RestObject.class);
        assert (annotations != null);
        String path = annotations.path();
        String primaryKey = annotations.primaryKey();
        String collection = annotations.collection();
        String totalCount = annotations.totalCount();
        logger.trace((Object)("path: " + path));
        logger.trace((Object)("primaryKey: " + primaryKey));
        logger.trace((Object)("collection: " + collection));
        logger.trace((Object)("totalCount: " + totalCount));
        Gson gson = client.getGson();
        for (ETRestObject object : objects) {
            switch (method) {
                case POST: {
                    logger.trace((Object)("POST " + path));
                    break;
                }
                case PATCH: {
                    logger.trace((Object)("PATCH " + path + "/" + object.getId()));
                    break;
                }
                case DELETE: {
                    logger.trace((Object)("DELETE " + path + "/" + object.getId()));
                    break;
                }
                default: {
                    throw new ETSdkException("invalid method: " + (Object)((Object)method));
                }
            }
            String requestPayload = null;
            if (method != ETRestConnection.Method.DELETE) {
                requestPayload = gson.toJson((Object)object);
                if (logger.isTraceEnabled()) {
                    JsonParser jsonParser = new JsonParser();
                    JsonObject jsonObject = jsonParser.parse(requestPayload).getAsJsonObject();
                    String jsonPrettyPrinted = gson.toJson((JsonElement)jsonObject);
                    for (String line : jsonPrettyPrinted.split("\\n")) {
                        logger.trace((Object)line);
                    }
                }
            }
            ETRestConnection.Response r = null;
            switch (method) {
                case POST: {
                    r = connection.post(path, requestPayload);
                    break;
                }
                case PATCH: {
                    r = connection.patch(path + "/" + object.getId(), requestPayload);
                    break;
                }
                case DELETE: {
                    r = connection.delete(path + "/" + object.getId());
                    break;
                }
                default: {
                    throw new ETSdkException("invalid method: " + (Object)((Object)method));
                }
            }
            ETResult<ETRestObject> result = new ETResult<ETRestObject>();
            result.setRequestId(r.getRequestId());
            if (r.getResponseCode() >= 200 && r.getResponseCode() <= 299) {
                result.setStatus(ETResult.Status.OK);
            } else if (r.getResponseCode() >= 400 && r.getResponseCode() <= 599) {
                result.setStatus(ETResult.Status.ERROR);
            }
            result.setResponseCode(r.getResponseCode().toString());
            result.setResponseMessage(r.getResponseMessage());
            if (method != ETRestConnection.Method.DELETE) {
                String responsePayload = r.getResponsePayload();
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = jsonParser.parse(responsePayload).getAsJsonObject();
                if (logger.isTraceEnabled()) {
                    String jsonPrettyPrinted = gson.toJson((JsonElement)jsonObject);
                    for (String line : jsonPrettyPrinted.split("\\n")) {
                        logger.trace((Object)line);
                    }
                }
                ETRestObject responseObject = (ETRestObject)gson.fromJson(responsePayload, object.getClass());
                responseObject.setClient(client);
                result.setObject(responseObject);
            }
            response.addResult(result);
            object.setClient(client);
        }
        return response;
    }

    public String serialize() {
        Gson gson = this.getClient().getGson();
        return gson.toJson((Object)this);
    }

    public static <T extends ETRestObject> T deserialize(ETClient client, String payload, Class<T> type) {
        Gson gson = client.getGson();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(payload).getAsJsonObject();
        ETRestObject object = (ETRestObject)gson.fromJson((JsonElement)jsonObject, type);
        object.setClient(client);
        return (T)object;
    }

    public static <T extends ETRestObject> ETResponse<T> deserialize(ETClient client, String payload, Class<T> type, String totalCount, String collection) {
        ETResponse response = new ETResponse();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(payload).getAsJsonObject();
        if (jsonObject.get("page") != null) {
            response.setPage(jsonObject.get("page").getAsInt());
            logger.trace((Object)("page = " + response.getPage()));
            response.setPageSize(jsonObject.get("pageSize").getAsInt());
            logger.trace((Object)("pageSize = " + response.getPageSize()));
            response.setTotalCount(jsonObject.get(totalCount).getAsInt());
            logger.trace((Object)("totalCount = " + response.getTotalCount()));
            if (response.getPage() * response.getPageSize() < response.getTotalCount()) {
                response.setMoreResults(true);
            }
            JsonArray elements = jsonObject.get(collection).getAsJsonArray();
            for (JsonElement element : elements) {
                ETResult<T> result = new ETResult<T>();
                result.setObject(ETRestObject.deserialize(client, element.toString(), type));
                response.addResult(result);
            }
        } else {
            ETResult<T> result = new ETResult<T>();
            result.setObject(ETRestObject.deserialize(client, jsonObject.toString(), type));
            response.addResult(result);
        }
        return response;
    }

    protected static String getInternalProperty(Class<? extends ETRestObject> type, String name) throws ETSdkException {
        String internalProperty = null;
        Class<? extends ETRestObject> externalType = type;
        Field externalField = ETRestObject.getField(externalType, name);
        SerializedName serializedNameAnnotation = externalField.getAnnotation(SerializedName.class);
        internalProperty = serializedNameAnnotation != null ? serializedNameAnnotation.value() : externalField.getName();
        return internalProperty;
    }

    private static String toFilterString(String value) throws ETSdkException {
        return ETRestObject.toFilterString(value, false);
    }

    private static String toFilterString(String value, boolean forceQuotes) throws ETSdkException {
        if (value.equals("")) {
            forceQuotes = true;
        }
        if (value.contains("*")) {
            forceQuotes = true;
        }
        if (value.contains("-")) {
            forceQuotes = true;
        }
        boolean quotes = forceQuotes;
        if (!forceQuotes) {
            for (int i = 0; i < value.length(); ++i) {
                if (!Character.isWhitespace(value.charAt(i))) continue;
                quotes = true;
                break;
            }
        }
        String v = null;
        v = quotes ? "'" + value + "'" : value.toString();
        try {
            return URLEncoder.encode(v, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ETSdkException("error URL encoding " + v, ex);
        }
    }

    public static String toFilterString(ETExpression expression) throws ETSdkException {
        return ETRestObject.toFilterString(expression, true);
    }

    private static String toFilterString(ETExpression expression, boolean first) throws ETSdkException {
        ETExpression.Operator operator;
        StringBuilder stringBuilder = new StringBuilder();
        if (first) {
            stringBuilder.append("$filter=");
        }
        if ((operator = expression.getOperator()) == null) {
            return null;
        }
        switch (operator) {
            case AND: {
                stringBuilder.append(ETRestObject.toFilterString(expression.getSubexpressions().get(0), false));
                stringBuilder.append("%20");
                stringBuilder.append("and");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getSubexpressions().get(1), false));
                break;
            }
            case OR: {
                stringBuilder.append(ETRestObject.toFilterString(expression.getSubexpressions().get(0), false));
                stringBuilder.append("%20");
                stringBuilder.append("or");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getSubexpressions().get(1), false));
                break;
            }
            case NOT: {
                stringBuilder.append("not");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getSubexpressions().get(0), false));
                break;
            }
            case EQUALS: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("eq");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValue(), false));
                break;
            }
            case NOT_EQUALS: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("neq");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValue(), false));
                break;
            }
            case LESS_THAN: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("lt");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValue(), false));
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("lte");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValue(), false));
                break;
            }
            case GREATER_THAN: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("gt");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValue(), false));
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("gte");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValue(), false));
                break;
            }
            case IS_NULL: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("is");
                stringBuilder.append("%20");
                stringBuilder.append("null");
                break;
            }
            case IS_NOT_NULL: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("is");
                stringBuilder.append("%20");
                stringBuilder.append("not");
                stringBuilder.append("%20");
                stringBuilder.append("null");
                break;
            }
            case IN: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("in");
                stringBuilder.append("%20");
                stringBuilder.append("(");
                boolean firstValue = true;
                for (String value : expression.getValues()) {
                    if (firstValue) {
                        firstValue = false;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(ETRestObject.toFilterString(value));
                }
                stringBuilder.append(")");
                break;
            }
            case BETWEEN: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("between");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValues().get(0), false));
                stringBuilder.append("%20");
                stringBuilder.append("and");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValues().get(1), false));
                break;
            }
            case LIKE: {
                stringBuilder.append(expression.getProperty());
                stringBuilder.append("%20");
                stringBuilder.append("like");
                stringBuilder.append("%20");
                stringBuilder.append(ETRestObject.toFilterString(expression.getValue(), true));
                break;
            }
            default: {
                throw new ETSdkException("unsupported operator: " + (Object)((Object)operator));
            }
        }
        return stringBuilder.toString();
    }
}

