/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETDataExtension;
import com.exacttarget.fuelsdk.ETEmail;
import com.exacttarget.fuelsdk.ETList;
import com.exacttarget.fuelsdk.ETResponse;
import com.exacttarget.fuelsdk.ETResult;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.ETSoapConnection;
import com.exacttarget.fuelsdk.ETSoapObject;
import com.exacttarget.fuelsdk.ETSubscriber;
import com.exacttarget.fuelsdk.annotations.ExternalName;
import com.exacttarget.fuelsdk.annotations.InternalName;
import com.exacttarget.fuelsdk.annotations.InternalProperty;
import com.exacttarget.fuelsdk.annotations.SoapObject;
import com.exacttarget.fuelsdk.internal.APIObject;
import com.exacttarget.fuelsdk.internal.CreateOptions;
import com.exacttarget.fuelsdk.internal.CreateRequest;
import com.exacttarget.fuelsdk.internal.CreateResponse;
import com.exacttarget.fuelsdk.internal.CreateResult;
import com.exacttarget.fuelsdk.internal.SendClassification;
import com.exacttarget.fuelsdk.internal.Soap;
import com.exacttarget.fuelsdk.internal.Subscriber;
import com.exacttarget.fuelsdk.internal.TriggeredSend;
import com.exacttarget.fuelsdk.internal.TriggeredSendDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

@SoapObject(internalType=TriggeredSendDefinition.class, unretrievable={"SendSourceDataExtension"})
public class ETTriggeredEmail
extends ETSoapObject {
    private static Logger logger = Logger.getLogger(ETTriggeredEmail.class);
    @ExternalName(value="id")
    @InternalName(value="objectID")
    private String id = null;
    @ExternalName(value="key")
    @InternalName(value="customerKey")
    private String key = null;
    @ExternalName(value="name")
    private String name = null;
    @ExternalName(value="description")
    private String description = null;
    @ExternalName(value="createdDate")
    private Date createdDate = null;
    @ExternalName(value="modifiedDate")
    private Date modifiedDate = null;
    @ExternalName(value="folderId")
    @InternalName(value="categoryID")
    private Integer folderId = null;
    @ExternalName(value="email")
    @InternalProperty(value="Email.ID")
    private ETEmail email = null;
    @ExternalName(value="list")
    @InternalProperty(value="List.ID")
    private ETList list = null;
    @ExternalName(value="dataExtension")
    @InternalName(value="sendSourceDataExtension")
    private ETDataExtension dataExtension = null;
    @ExternalName(value="subject")
    @InternalName(value="emailSubject")
    private String subject = null;
    @ExternalName(value="priority")
    private String priority = null;
    @ExternalName(value="status")
    @InternalName(value="triggeredSendStatus")
    private Status status = null;
    @ExternalName(value="autoAddSubscribers")
    private Boolean autoAddSubscribers = null;
    @ExternalName(value="autoUpdateSubscribers")
    private Boolean autoUpdateSubscribers = null;
    @ExternalName(value="isMultipart")
    private Boolean isMultipart = null;
    @ExternalName(value="isWrapped")
    private Boolean isWrapped = null;
    @ExternalName(value="suppressTracking")
    private Boolean suppressTracking = null;
    @ExternalName(value="sendClassification")
    @InternalName(value="sendClassification")
    private SendClassification sendClassification = null;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Integer getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Integer folderId) {
        this.folderId = folderId;
    }

    public ETEmail getEmail() {
        return this.email;
    }

    public void setEmail(ETEmail email) {
        this.email = email;
    }

    public ETList getList() {
        return this.list;
    }

    public void setList(ETList list) {
        this.list = list;
    }

    public ETDataExtension getDataExtension() {
        return this.dataExtension;
    }

    public void setDataExtension(ETDataExtension dataExtension) {
        this.dataExtension = dataExtension;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Boolean getAutoAddSubscribers() {
        return this.autoAddSubscribers;
    }

    public void setAutoAddSubscribers(Boolean autoAddSubscribers) {
        this.autoAddSubscribers = autoAddSubscribers;
    }

    public Boolean getAutoUpdateSubscribers() {
        return this.autoUpdateSubscribers;
    }

    public void setAutoUpdateSubscribers(Boolean autoUpdateSubscribers) {
        this.autoUpdateSubscribers = autoUpdateSubscribers;
    }

    public Boolean getIsMultipart() {
        return this.isMultipart;
    }

    public void setIsMultipart(Boolean isMultipart) {
        this.isMultipart = isMultipart;
    }

    public Boolean getIsWrapped() {
        return this.isWrapped;
    }

    public void setIsWrapped(Boolean isWrapped) {
        this.isWrapped = isWrapped;
    }

    public Boolean getSuppressTracking() {
        return this.suppressTracking;
    }

    public void setSuppressTracking(Boolean suppressTracking) {
        this.suppressTracking = suppressTracking;
    }

    public SendClassification getSendClassification() {
        return this.sendClassification;
    }

    public void setSendClassification(SendClassification sendClassification) {
        this.sendClassification = sendClassification;
    }

    public ETResponse<ETTriggeredEmail> send(String ... addresses) throws ETSdkException {
        ArrayList<ETSubscriber> subscribers = new ArrayList<ETSubscriber>();
        for (String address : addresses) {
            ETSubscriber subscriber = new ETSubscriber();
            subscriber.setKey(address);
            subscriber.setEmailAddress(address);
            subscribers.add(subscriber);
        }
        return this.send(subscribers);
    }

    public ETResponse<ETTriggeredEmail> send(ETSubscriber ... subscribers) throws ETSdkException {
        return this.send(Arrays.asList(subscribers));
    }

    public ETResponse<ETTriggeredEmail> send(List<ETSubscriber> subscribers) throws ETSdkException {
        ETResponse<ETTriggeredEmail> response = new ETResponse<ETTriggeredEmail>();
        if (subscribers == null || subscribers.size() == 0) {
            response.setStatus(ETResult.Status.OK);
            return response;
        }
        ETSoapConnection connection = this.getClient().getSoapConnection();
        this.getClient().refreshToken();
        Soap soap = connection.getSoap();
        CreateRequest createRequest = new CreateRequest();
        createRequest.setOptions(new CreateOptions());
        TriggeredSend triggeredSend = new TriggeredSend();
        TriggeredSendDefinition triggeredSendDefinition = new TriggeredSendDefinition();
        triggeredSendDefinition.setCustomerKey(this.getKey());
        triggeredSend.setTriggeredSendDefinition(triggeredSendDefinition);
        for (ETSubscriber subscriber : subscribers) {
            triggeredSend.getSubscribers().add((Subscriber)subscriber.toInternal());
        }
        createRequest.getObjects().add(triggeredSend);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"CreateRequest:");
            logger.trace((Object)"  objects = {");
            for (APIObject object : createRequest.getObjects()) {
                logger.trace((Object)("    " + object));
            }
            logger.trace((Object)"  }");
        }
        logger.trace((Object)"calling soap.create...");
        CreateResponse createResponse = soap.create(createRequest);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"CreateResponse:");
            logger.trace((Object)("  requestId = " + createResponse.getRequestID()));
            logger.trace((Object)("  overallStatus = " + createResponse.getOverallStatus()));
            logger.trace((Object)"  results = {");
            for (CreateResult result : createResponse.getResults()) {
                logger.trace((Object)("    " + result));
            }
            logger.trace((Object)"  }");
        }
        response.setRequestId(createResponse.getRequestID());
        if (createResponse.getOverallStatus().equals("OK")) {
            response.setStatus(ETResult.Status.OK);
        } else if (createResponse.getOverallStatus().equals("Error")) {
            response.setStatus(ETResult.Status.ERROR);
        }
        response.setResponseCode(createResponse.getOverallStatus());
        response.setResponseMessage(createResponse.getOverallStatus());
        for (CreateResult createResult : createResponse.getResults()) {
            ETResult result = new ETResult();
            if (createResult.getStatusCode().equals("OK")) {
                result.setStatus(ETResult.Status.OK);
            } else if (createResult.getStatusCode().equals("Error")) {
                result.setStatus(ETResult.Status.ERROR);
            }
            result.setResponseCode(createResult.getStatusCode());
            result.setResponseMessage(createResult.getStatusMessage());
            result.setErrorCode(createResult.getErrorCode());
            response.addResult(result);
        }
        return response;
    }

    @Deprecated
    public String getCustomerKey() {
        return this.getKey();
    }

    @Deprecated
    public void setCustomerKey(String customerKey) {
        this.setKey(customerKey);
    }

    @Deprecated
    public Integer getCategoryId() {
        return this.getFolderId();
    }

    @Deprecated
    public void setCategoryId(Integer categoryId) {
        this.setFolderId(categoryId);
    }

    public static enum Status {
        ACTIVE("Active"),
        CANCELED("Canceled"),
        DELETED("Deleted"),
        INACTIVE("Inactive"),
        MOVED("Moved"),
        NEW("NEW");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

