/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.annotations.ExternalName;
import com.exacttarget.fuelsdk.annotations.PrettyPrint;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class ETObject {
    private ETClient client = null;
    private Boolean toStringMultiLine = true;
    private Integer toStringMultiLineIndentAmount = 4;
    private Boolean toStringSpaceAroundEquals = this.toStringMultiLine;
    private static int currentIndentLevel = 0;

    public ETClient getClient() {
        return this.client;
    }

    public void setClient(ETClient client) {
        this.client = client;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[");
        if (this.toStringMultiLine.booleanValue()) {
            stringBuilder.append(System.getProperty("line.separator"));
        }
        currentIndentLevel += this.toStringMultiLineIndentAmount.intValue();
        boolean first = true;
        for (Field field : this.getAllFields()) {
            PrettyPrint prettyPrintAnnotation = field.getAnnotation(PrettyPrint.class);
            ExternalName externalNameAnnotation = field.getAnnotation(ExternalName.class);
            if (prettyPrintAnnotation == null && externalNameAnnotation == null) continue;
            String name = null;
            name = externalNameAnnotation != null ? externalNameAnnotation.value() : field.getName();
            String value = null;
            try {
                boolean isAccessible = field.isAccessible();
                if (!isAccessible) {
                    field.setAccessible(true);
                }
                if (field.get(this) != null) {
                    value = field.get(this).toString();
                }
                field.setAccessible(isAccessible);
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError((Object)"should never ever get here");
            }
            if (value == null) continue;
            if (this.toStringMultiLine.booleanValue()) {
                for (int i = 0; i < currentIndentLevel; ++i) {
                    stringBuilder.append(" ");
                }
            } else if (first) {
                first = false;
            } else {
                stringBuilder.append(",");
            }
            if (this.toStringSpaceAroundEquals.booleanValue()) {
                stringBuilder.append(name + " = " + value);
            } else {
                stringBuilder.append(name + "=" + value);
            }
            if (!this.toStringMultiLine.booleanValue()) continue;
            stringBuilder.append(System.getProperty("line.separator"));
        }
        currentIndentLevel -= this.toStringMultiLineIndentAmount.intValue();
        if (this.toStringMultiLine.booleanValue()) {
            for (int i = 0; i < currentIndentLevel; ++i) {
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected Field getField(String property) {
        for (Field field : this.getAllFields()) {
            ExternalName externalName = field.getAnnotation(ExternalName.class);
            if (externalName == null || !externalName.value().equals(property)) continue;
            return field;
        }
        return null;
    }

    protected static Field getField(Class<?> type, String name) throws ETSdkException {
        Field field = null;
        for (Class<?> t = type; t != null; t = t.getSuperclass()) {
            try {
                field = t.getDeclaredField(name);
                break;
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
        }
        if (field == null) {
            throw new ETSdkException("field \"" + name + "\" does not exist in class " + type.getName());
        }
        return field;
    }

    protected List<Field> getAllFields() {
        return ETObject.getAllFields(this.getClass());
    }

    protected static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList types = new ArrayList();
        for (Class<?> t = type; t != null; t = t.getSuperclass()) {
            types.add(t);
        }
        ListIterator li = types.listIterator(types.size());
        while (li.hasPrevious()) {
            Class t = (Class)li.previous();
            for (Field field : t.getDeclaredFields()) {
                fields.add(field);
            }
        }
        return fields;
    }
}

