/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.build.ContainerFactory;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.build.Sam2CramRecordFactory;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScorePreservation;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringLineReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CRAMFileWriter
extends SAMFileWriterImpl {
    private static final int REF_SEQ_INDEX_NOT_INITIALIZED = -2;
    static int DEFAULT_RECORDS_PER_SLICE = 10000;
    private static final int DEFAULT_SLICES_PER_CONTAINER = 1;
    private static final Version cramVersion = CramVersions.CRAM_v2_1;
    private final String fileName;
    private final List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ContainerFactory containerFactory;
    protected final int recordsPerSlice = DEFAULT_RECORDS_PER_SLICE;
    protected final int containerSize = this.recordsPerSlice * 1;
    private final OutputStream outputStream;
    private ReferenceSource source;
    private int refSeqIndex = -2;
    private static final Log log = Log.getInstance(CRAMFileWriter.class);
    private final SAMFileHeader samFileHeader;
    private boolean preserveReadNames = true;
    private QualityScorePreservation preservation = null;
    private boolean captureAllTags = true;
    private Set<String> captureTags = new TreeSet<String>();
    private Set<String> ignoreTags = new TreeSet<String>();
    private CRAMIndexer indexer;
    private long offset;

    public CRAMFileWriter(OutputStream outputStream, ReferenceSource referenceSource, SAMFileHeader sAMFileHeader, String string) {
        this(outputStream, null, referenceSource, sAMFileHeader, string);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream outputStream2, ReferenceSource referenceSource, SAMFileHeader sAMFileHeader, String string) {
        this.outputStream = outputStream;
        this.source = referenceSource;
        this.samFileHeader = sAMFileHeader;
        this.fileName = string;
        this.setSortOrder(sAMFileHeader.getSortOrder(), true);
        this.setHeader(sAMFileHeader);
        if (this.source == null) {
            this.source = new ReferenceSource(Defaults.REFERENCE_FASTA);
        }
        this.containerFactory = new ContainerFactory(sAMFileHeader, this.recordsPerSlice);
        if (outputStream2 != null) {
            this.indexer = new CRAMIndexer(outputStream2, sAMFileHeader);
        }
    }

    protected boolean shouldFlushContainer(SAMRecord sAMRecord) {
        return this.samRecords.size() >= this.containerSize || this.refSeqIndex != -2 && this.refSeqIndex != sAMRecord.getReferenceIndex();
    }

    private static void updateTracks(List<SAMRecord> list, ReferenceTracks referenceTracks) {
        for (SAMRecord sAMRecord : list) {
            if (sAMRecord.getAlignmentStart() == 0) continue;
            int n = sAMRecord.getAlignmentStart();
            int n2 = 0;
            for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                int n3;
                if (cigarElement.getOperator().consumesReferenceBases()) {
                    for (n3 = 0; n3 < cigarElement.getLength(); ++n3) {
                        referenceTracks.addCoverage(n + n3, 1);
                    }
                }
                switch (cigarElement.getOperator()) {
                    case M: 
                    case X: 
                    case EQ: {
                        for (n3 = n2; n3 < cigarElement.getLength(); ++n3) {
                            byte by;
                            byte by2 = sAMRecord.getReadBases()[n2 + n3];
                            if (by2 == (by = referenceTracks.baseAt(n + n3))) continue;
                            referenceTracks.addMismatches(n + n3, 1);
                        }
                        break;
                    }
                }
                n2 += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                n += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void flushContainer() throws IllegalArgumentException, IllegalAccessException, IOException {
        byte[] byArray;
        String string = null;
        if (this.refSeqIndex == -1) {
            byArray = new byte[]{};
        } else {
            SAMSequenceRecord sAMSequenceRecord = this.samFileHeader.getSequence(this.refSeqIndex);
            byArray = this.source.getReferenceBases(sAMSequenceRecord, true);
            string = sAMSequenceRecord.getSequenceName();
        }
        int n = 0;
        int n2 = 0;
        for (SAMRecord cloneable2 : this.samRecords) {
            if (cloneable2.getAlignmentStart() == 0) continue;
            if (n == 0) {
                n = cloneable2.getAlignmentStart();
            }
            n = Math.min(cloneable2.getAlignmentStart(), n);
            n2 = Math.max(cloneable2.getAlignmentEnd(), n2);
        }
        Object object3 = null;
        if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
            object3 = new ReferenceTracks(this.refSeqIndex, string, byArray);
            ((ReferenceTracks)object3).ensureRange(n, n2 - n + 1);
            CRAMFileWriter.updateTracks(this.samRecords, (ReferenceTracks)object3);
        }
        ArrayList<CramCompressionRecord> arrayList = new ArrayList<CramCompressionRecord>(this.samRecords.size());
        Sam2CramRecordFactory sam2CramRecordFactory = new Sam2CramRecordFactory(byArray, this.samFileHeader, cramVersion);
        sam2CramRecordFactory.preserveReadNames = this.preserveReadNames;
        sam2CramRecordFactory.captureAllTags = this.captureAllTags;
        sam2CramRecordFactory.captureTags.addAll(this.captureTags);
        sam2CramRecordFactory.ignoreTags.addAll(this.ignoreTags);
        this.containerFactory.setPreserveReadNames(this.preserveReadNames);
        int n3 = 0;
        int n4 = n;
        for (SAMRecord sAMRecord : this.samRecords) {
            Iterator<Object> iterator = sam2CramRecordFactory.createCramRecord(sAMRecord);
            ((CramCompressionRecord)((Object)iterator)).index = ++n3;
            ((CramCompressionRecord)((Object)iterator)).alignmentDelta = sAMRecord.getAlignmentStart() - n4;
            ((CramCompressionRecord)((Object)iterator)).alignmentStart = sAMRecord.getAlignmentStart();
            n4 = sAMRecord.getAlignmentStart();
            arrayList.add((CramCompressionRecord)((Object)iterator));
            if (this.preservation != null) {
                this.preservation.addQualityScores(sAMRecord, (CramCompressionRecord)((Object)iterator), (ReferenceTracks)object3);
                continue;
            }
            if (((CramCompressionRecord)((Object)iterator)).qualityScores == SAMRecord.NULL_QUALS) continue;
            ((CramCompressionRecord)((Object)iterator)).setForcePreserveQualityScores(true);
        }
        if (sam2CramRecordFactory.getBaseCount() < 3L * sam2CramRecordFactory.getFeatureCount()) {
            log.warn("Abnormally high number of mismatches, possibly wrong reference.");
        }
        if (this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate) {
            TreeMap bl = new TreeMap();
            TreeMap treeMap = new TreeMap();
            for (Object object : arrayList) {
                if (!((CramCompressionRecord)object).isMultiFragment()) {
                    ((CramCompressionRecord)object).setDetached(true);
                    ((CramCompressionRecord)object).setHasMateDownStream(false);
                    ((CramCompressionRecord)object).recordsToNextFragment = -1;
                    ((CramCompressionRecord)object).next = null;
                    ((CramCompressionRecord)object).previous = null;
                    continue;
                }
                String string2 = ((CramCompressionRecord)object).readName;
                Object object2 = ((CramCompressionRecord)object).isSecondaryAlignment() ? treeMap : bl;
                CramCompressionRecord cramCompressionRecord = (CramCompressionRecord)object2.get(string2);
                if (cramCompressionRecord == null) {
                    object2.put(string2, object);
                    continue;
                }
                CramCompressionRecord cramCompressionRecord2 = cramCompressionRecord;
                while (cramCompressionRecord2.next != null) {
                    cramCompressionRecord2 = cramCompressionRecord2.next;
                }
                cramCompressionRecord2.recordsToNextFragment = ((CramCompressionRecord)object).index - cramCompressionRecord2.index - 1;
                cramCompressionRecord2.next = object;
                ((CramCompressionRecord)object).previous = cramCompressionRecord2;
                ((CramCompressionRecord)object).previous.setHasMateDownStream(true);
                ((CramCompressionRecord)object).setHasMateDownStream(false);
                ((CramCompressionRecord)object).setDetached(false);
                ((CramCompressionRecord)object).previous.setDetached(false);
            }
            for (Object object : arrayList) {
                void var14_32;
                if (((CramCompressionRecord)object).next == null || ((CramCompressionRecord)object).previous != null) continue;
                CramCompressionRecord cramCompressionRecord = object;
                while (var14_32.next != null) {
                    CramCompressionRecord cramCompressionRecord3 = var14_32.next;
                }
                if (((CramCompressionRecord)object).isFirstSegment() && var14_32.isLastSegment()) {
                    void var14_35;
                    int n5 = CramNormalizer.computeInsertSize((CramCompressionRecord)object, (CramCompressionRecord)var14_32);
                    if (((CramCompressionRecord)object).templateSize != n5) continue;
                    CramCompressionRecord cramCompressionRecord4 = ((CramCompressionRecord)object).next;
                    while (var14_35.next != null && var14_35.templateSize == -n5) {
                        CramCompressionRecord cramCompressionRecord5 = var14_35.next;
                    }
                    if (var14_35.templateSize == -n5) continue;
                    CRAMFileWriter.detach((CramCompressionRecord)object);
                    continue;
                }
                CRAMFileWriter.detach((CramCompressionRecord)object);
            }
            for (Object object : bl.values()) {
                if (((CramCompressionRecord)object).next != null) continue;
                ((CramCompressionRecord)object).setDetached(true);
                ((CramCompressionRecord)object).setHasMateDownStream(false);
                ((CramCompressionRecord)object).recordsToNextFragment = -1;
                ((CramCompressionRecord)object).next = null;
                ((CramCompressionRecord)object).previous = null;
            }
            for (Object object : treeMap.values()) {
                if (((CramCompressionRecord)object).next != null) continue;
                ((CramCompressionRecord)object).setDetached(true);
                ((CramCompressionRecord)object).setHasMateDownStream(false);
                ((CramCompressionRecord)object).recordsToNextFragment = -1;
                ((CramCompressionRecord)object).next = null;
                ((CramCompressionRecord)object).previous = null;
            }
        } else {
            for (CramCompressionRecord cramCompressionRecord : arrayList) {
                cramCompressionRecord.setDetached(true);
            }
        }
        boolean container = false;
        if (!$assertionsDisabled) {
            container = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (container) {
            Cram2SamRecordFactory cram2SamRecordFactory = new Cram2SamRecordFactory(this.samFileHeader);
            for (int i = 0; i < this.samRecords.size(); ++i) {
                Object object;
                object = cram2SamRecordFactory.create((CramCompressionRecord)arrayList.get(i));
                assert (((SAMRecord)object).getAlignmentStart() == this.samRecords.get(i).getAlignmentStart());
                assert (((SAMRecord)object).getReferenceName().equals(this.samRecords.get(i).getReferenceName()));
                assert (((SAMRecord)object).getReadString().equals(this.samRecords.get(i).getReadString()));
                assert (((SAMRecord)object).getBaseQualityString().equals(this.samRecords.get(i).getBaseQualityString()));
            }
        }
        Container container2 = this.containerFactory.buildContainer(arrayList);
        for (Slice slice : container2.slices) {
            slice.setRefMD5(byArray);
        }
        container2.offset = this.offset;
        this.offset += (long)ContainerIO.writeContainer(cramVersion, container2, this.outputStream);
        if (this.indexer != null) {
            for (Slice slice : container2.slices) {
                this.indexer.processAlignment(slice);
            }
        }
        this.samRecords.clear();
    }

    private static void detach(CramCompressionRecord cramCompressionRecord) {
        do {
            cramCompressionRecord.setDetached(true);
            cramCompressionRecord.setHasMateDownStream(false);
            cramCompressionRecord.recordsToNextFragment = -1;
        } while ((cramCompressionRecord = cramCompressionRecord.next) != null);
    }

    @Override
    protected void writeAlignment(SAMRecord sAMRecord) {
        if (this.shouldFlushContainer(sAMRecord)) {
            try {
                this.flushContainer();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.updateReferenceContext(sAMRecord.getReferenceIndex());
        this.samRecords.add(sAMRecord);
    }

    private void updateReferenceContext(int n) {
        if (this.refSeqIndex == -2) {
            this.refSeqIndex = n;
        } else if (this.refSeqIndex != n) {
            this.refSeqIndex = n;
        }
    }

    @Override
    protected void writeHeader(String string) {
        SAMFileHeader sAMFileHeader = new SAMTextHeaderCodec().decode(new StringLineReader(string), this.fileName != null ? this.fileName : null);
        this.containerFactory = new ContainerFactory(sAMFileHeader, this.recordsPerSlice);
        CramHeader cramHeader = new CramHeader(cramVersion, this.fileName, sAMFileHeader);
        try {
            this.offset = CramIO.writeCramHeader(cramHeader, this.outputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void finish() {
        try {
            if (!this.samRecords.isEmpty()) {
                this.flushContainer();
            }
            CramIO.issueEOF(cramVersion, this.outputStream);
            this.outputStream.flush();
            if (this.indexer != null) {
                this.indexer.finish();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected String getFilename() {
        return this.fileName;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean bl) {
        this.preserveReadNames = bl;
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        if (this.preservation == null) {
            this.preservation = new QualityScorePreservation("*8");
        }
        return this.preservation.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.captureAllTags;
    }

    public void setCaptureAllTags(boolean bl) {
        this.captureAllTags = bl;
    }

    public Set<String> getCaptureTags() {
        return this.captureTags;
    }

    public void setCaptureTags(Set<String> set) {
        this.captureTags = set;
    }

    public Set<String> getIgnoreTags() {
        return this.ignoreTags;
    }

    public void setIgnoreTags(Set<String> set) {
        this.ignoreTags = set;
    }
}

