/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAMRecordDuplicateComparator
implements SAMRecordComparator {
    private static final byte FF = 0;
    private static final byte FR = 1;
    private static final byte F = 2;
    private static final byte RF = 3;
    private static final byte RR = 4;
    private static final byte R = 5;
    private final Map<String, Short> libraryIds = new HashMap<String, Short>();
    private short nextLibraryId = 1;
    private DuplicateScoringStrategy.ScoringStrategy scoringStrategy = DuplicateScoringStrategy.ScoringStrategy.TOTAL_MAPPED_REFERENCE_LENGTH;

    public SAMRecordDuplicateComparator() {
    }

    public SAMRecordDuplicateComparator(List<SAMFileHeader> list) {
        for (SAMFileHeader sAMFileHeader : list) {
            for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
                short s;
                String string = sAMReadGroupRecord.getLibrary();
                if (null == string) continue;
                this.nextLibraryId = (short)(this.nextLibraryId + 1);
                this.libraryIds.put(string, s);
            }
        }
    }

    public void setScoringStrategy(DuplicateScoringStrategy.ScoringStrategy scoringStrategy) {
        this.scoringStrategy = scoringStrategy;
    }

    private static String getLibraryName(SAMRecord sAMRecord) {
        String string;
        SAMReadGroupRecord sAMReadGroupRecord;
        String string2 = (String)sAMRecord.getAttribute("RG");
        if (string2 != null && (sAMReadGroupRecord = sAMRecord.getHeader().getReadGroup(string2)) != null && null != (string = sAMReadGroupRecord.getLibrary())) {
            return string;
        }
        return "Unknown Library";
    }

    private short getLibraryId(SAMRecord sAMRecord) {
        String string = SAMRecordDuplicateComparator.getLibraryName(sAMRecord);
        Short s = this.libraryIds.get(string);
        if (s == null) {
            short s2 = this.nextLibraryId;
            this.nextLibraryId = (short)(s2 + 1);
            s = s2;
            this.libraryIds.put(string, s);
        }
        return s;
    }

    private int compareOrientationByteCollapseOrientation(int n, int n2) {
        if (2 == n || 5 == n) {
            if (2 == n ? 2 == n2 || 1 == n2 || 0 == n2 : 5 == n2 || 3 == n2 || 4 == n2) {
                return 0;
            }
        } else if (2 == n2 || 5 == n2) {
            return -this.compareOrientationByteCollapseOrientation(n2, n);
        }
        return n - n2;
    }

    private static byte getPairedOrientationByte(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return 4;
            }
            return 3;
        }
        if (bl2) {
            return 1;
        }
        return 0;
    }

    private int getFragmentOrientation(SAMRecord sAMRecord) {
        return sAMRecord.getReadNegativeStrandFlag() ? 5 : 2;
    }

    private int getPairedOrientation(SAMRecord sAMRecord) {
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag()) {
            return SAMRecordDuplicateComparator.getPairedOrientationByte(sAMRecord.getReadNegativeStrandFlag(), sAMRecord.getMateNegativeStrandFlag());
        }
        return this.getFragmentOrientation(sAMRecord);
    }

    private int getMateReferenceIndex(SAMRecord sAMRecord) {
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag()) {
            return sAMRecord.getMateReferenceIndex();
        }
        return -1;
    }

    private int getMateCoordinate(SAMRecord sAMRecord) {
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag()) {
            return sAMRecord.getMateNegativeStrandFlag() ? SAMUtils.getMateUnclippedEnd(sAMRecord) : SAMUtils.getMateUnclippedStart(sAMRecord);
        }
        return -1;
    }

    private boolean hasUnmappedEnd(SAMRecord sAMRecord) {
        return sAMRecord.getReadUnmappedFlag() || sAMRecord.getReadPairedFlag() && sAMRecord.getMateUnmappedFlag();
    }

    private boolean hasMappedEnd(SAMRecord sAMRecord) {
        return !sAMRecord.getReadUnmappedFlag() || sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag();
    }

    private boolean pairedEndAndBothMapped(SAMRecord sAMRecord) {
        return sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag();
    }

    @Override
    public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        int n = this.fileOrderCompare(sAMRecord, sAMRecord2);
        if (n == 0) {
            n = DuplicateScoringStrategy.compare(sAMRecord, sAMRecord2, this.scoringStrategy, true);
        }
        if (n == 0) {
            n = sAMRecord.getReadName().compareTo(sAMRecord2.getReadName());
        }
        if (n == 0 && sAMRecord.getReadPairedFlag() && sAMRecord2.getReadPairedFlag()) {
            int n2 = sAMRecord.getFirstOfPairFlag() ? 0 : 1;
            int n3 = sAMRecord2.getFirstOfPairFlag() ? 0 : 1;
            n = n2 - n3;
        }
        return n;
    }

    private int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2, boolean bl, boolean bl2) {
        int n;
        int n2 = this.getLibraryId(sAMRecord);
        int n3 = n2 - (n = this.getLibraryId(sAMRecord2));
        if (n3 == 0) {
            n2 = sAMRecord.getReferenceIndex();
            n = sAMRecord2.getReferenceIndex();
            n3 = n2 == -1 ? (n == -1 ? 0 : 1) : (n == -1 ? -1 : n2 - n);
        }
        if (n3 == 0) {
            n2 = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getUnclippedEnd() : sAMRecord.getUnclippedStart();
            n = sAMRecord2.getReadNegativeStrandFlag() ? sAMRecord2.getUnclippedEnd() : sAMRecord2.getUnclippedStart();
            n3 = n2 - n;
        }
        if (n3 == 0) {
            n2 = this.getPairedOrientation(sAMRecord);
            n = this.getPairedOrientation(sAMRecord2);
            n3 = bl ? this.compareOrientationByteCollapseOrientation(n2, n) : n2 - n;
        }
        if (this.pairedEndAndBothMapped(sAMRecord) && this.pairedEndAndBothMapped(sAMRecord2)) {
            if (n3 == 0) {
                n2 = this.getMateReferenceIndex(sAMRecord);
                n = this.getMateReferenceIndex(sAMRecord2);
                n3 = n2 - n;
            }
            if (n3 == 0) {
                n2 = this.getMateCoordinate(sAMRecord);
                n = this.getMateCoordinate(sAMRecord2);
                n3 = n2 - n;
            }
        }
        if (n3 == 0) {
            n2 = this.hasMappedEnd(sAMRecord) ? 0 : 1;
            n = this.hasMappedEnd(sAMRecord2) ? 0 : 1;
            n3 = n2 - n;
        }
        if (n3 == 0 && bl2) {
            if (sAMRecord.getReadPairedFlag() == sAMRecord2.getReadPairedFlag()) {
                n2 = this.hasUnmappedEnd(sAMRecord) ? 1 : 0;
                n = this.hasUnmappedEnd(sAMRecord2) ? 1 : 0;
                n3 = n2 - n;
            } else {
                n3 = sAMRecord.getReadPairedFlag() ? -1 : 1;
            }
        }
        return n3;
    }

    public int duplicateSetCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return this.fileOrderCompare(sAMRecord, sAMRecord2, true, false);
    }

    @Override
    public int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return this.fileOrderCompare(sAMRecord, sAMRecord2, false, true);
    }
}

