/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMSequenceRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SAMSequenceDictionary
implements Serializable {
    public static final long serialVersionUID = 1L;
    private List<SAMSequenceRecord> mSequences = new ArrayList<SAMSequenceRecord>();
    private final Map<String, SAMSequenceRecord> mSequenceMap = new HashMap<String, SAMSequenceRecord>();
    private static String DICT_MISMATCH_TEMPLATE = "SAM dictionaries are not the same: %s.";

    public SAMSequenceDictionary() {
    }

    public SAMSequenceDictionary(List<SAMSequenceRecord> list) {
        this();
        this.setSequences(list);
    }

    public List<SAMSequenceRecord> getSequences() {
        return Collections.unmodifiableList(this.mSequences);
    }

    public SAMSequenceRecord getSequence(String string) {
        return this.mSequenceMap.get(string);
    }

    public void setSequences(List<SAMSequenceRecord> list) {
        this.mSequences = list;
        this.mSequenceMap.clear();
        int n = 0;
        for (SAMSequenceRecord sAMSequenceRecord : list) {
            sAMSequenceRecord.setSequenceIndex(n++);
            if (this.mSequenceMap.put(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord) == null) continue;
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sAMSequenceRecord.getSequenceName());
        }
    }

    public void addSequence(SAMSequenceRecord sAMSequenceRecord) {
        if (this.mSequenceMap.containsKey(sAMSequenceRecord.getSequenceName())) {
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sAMSequenceRecord.getSequenceName());
        }
        sAMSequenceRecord.setSequenceIndex(this.mSequences.size());
        this.mSequences.add(sAMSequenceRecord);
        this.mSequenceMap.put(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord);
    }

    public SAMSequenceRecord getSequence(int n) {
        if (n < 0 || n >= this.mSequences.size()) {
            return null;
        }
        return this.mSequences.get(n);
    }

    public int getSequenceIndex(String string) {
        SAMSequenceRecord sAMSequenceRecord = this.mSequenceMap.get(string);
        if (sAMSequenceRecord == null) {
            return -1;
        }
        return sAMSequenceRecord.getSequenceIndex();
    }

    public int size() {
        return this.mSequences.size();
    }

    public long getReferenceLength() {
        long l = 0L;
        for (SAMSequenceRecord sAMSequenceRecord : this.getSequences()) {
            l += (long)sAMSequenceRecord.getSequenceLength();
        }
        return l;
    }

    public boolean isEmpty() {
        return this.mSequences.isEmpty();
    }

    public void assertSameDictionary(SAMSequenceDictionary sAMSequenceDictionary) {
        if (this == sAMSequenceDictionary) {
            return;
        }
        Iterator<SAMSequenceRecord> iterator = sAMSequenceDictionary.mSequences.iterator();
        for (SAMSequenceRecord sAMSequenceRecord : this.mSequences) {
            if (!iterator.hasNext()) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, sAMSequenceRecord + " is present in only one dictionary"));
            }
            SAMSequenceRecord sAMSequenceRecord2 = iterator.next();
            if (!sAMSequenceRecord2.isSameSequence(sAMSequenceRecord)) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, sAMSequenceRecord2 + " was found when " + sAMSequenceRecord + " was expected"));
            }
        }
        if (iterator.hasNext()) {
            throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, iterator.next() + " is present in only one dictionary"));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SAMSequenceDictionary sAMSequenceDictionary = (SAMSequenceDictionary)object;
        return this.mSequences.equals(sAMSequenceDictionary.mSequences);
    }

    public int hashCode() {
        return this.mSequences.hashCode();
    }
}

