/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class CramIO {
    public static final byte[] ZERO_B_EOF_MARKER = CramIO.bytesFromHex("0b 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00 00 01 00 06 06 01 00 01 00 01 00");
    public static final byte[] ZERO_F_EOF_MARKER = CramIO.bytesFromHex("0f 00 00 00 ff ff ff ff 0f e0 45 4f 46 00 00 00 00 01 00 05 bd d9 4f 00 01 00 06 06 01 00 01 00 01 00 ee 63 01 4b");
    private static final int DEFINITION_LENGTH = 26;
    private static final Log log = Log.getInstance(CramIO.class);

    private static byte[] bytesFromHex(String string) {
        String string2 = string.replaceAll("[^0-9a-fA-F]", "");
        if (string2.length() % 2 != 0) {
            throw new RuntimeException("Not a hex string: " + string);
        }
        byte[] byArray = new byte[string2.length() / 2];
        for (int i = 0; i < string2.length(); i += 2) {
            byArray[i / 2] = Integer.decode("0x" + string2.charAt(i) + string2.charAt(i + 1)).byteValue();
        }
        return byArray;
    }

    public static long issueEOF(Version version, OutputStream outputStream) throws IOException {
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            outputStream.write(ZERO_F_EOF_MARKER);
            return ZERO_F_EOF_MARKER.length;
        }
        if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
            outputStream.write(ZERO_B_EOF_MARKER);
            return ZERO_B_EOF_MARKER.length;
        }
        return 0L;
    }

    private static boolean streamEndsWith(SeekableStream seekableStream, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[ZERO_B_EOF_MARKER.length];
        seekableStream.seek(seekableStream.length() - (long)byArray.length);
        InputStreamUtils.readFully(seekableStream, byArray2, 0, byArray2.length);
        byArray2[8] = (byte)(byArray2[8] | 0xF0);
        return Arrays.equals(byArray2, byArray);
    }

    private static boolean checkEOF(Version version, SeekableStream seekableStream) throws IOException {
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_B_EOF_MARKER);
        }
        if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_F_EOF_MARKER);
        }
        return false;
    }

    public static boolean checkHeaderAndEOF(File file) throws IOException {
        SeekableFileStream seekableFileStream = new SeekableFileStream(file);
        CramHeader cramHeader = CramIO.readCramHeader(seekableFileStream);
        return CramIO.checkEOF(cramHeader.getVersion(), seekableFileStream);
    }

    public static long writeCramHeader(CramHeader cramHeader, OutputStream outputStream) throws IOException {
        outputStream.write("CRAM".getBytes("US-ASCII"));
        outputStream.write(cramHeader.getVersion().major);
        outputStream.write(cramHeader.getVersion().minor);
        outputStream.write(cramHeader.getId());
        for (int i = cramHeader.getId().length; i < 20; ++i) {
            outputStream.write(0);
        }
        long l = CramIO.writeContainerForSamFileHeader(cramHeader.getVersion().major, cramHeader.getSamFileHeader(), outputStream);
        return 26L + l;
    }

    private static CramHeader readFormatDefinition(InputStream inputStream) throws IOException {
        for (byte by : CramHeader.MAGIC) {
            if (by == inputStream.read()) continue;
            throw new RuntimeException("Unknown file format.");
        }
        Version version = new Version(inputStream.read(), inputStream.read(), 0);
        CramHeader cramHeader = new CramHeader(version, null, null);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(cramHeader.getId());
        return cramHeader;
    }

    public static CramHeader readCramHeader(InputStream inputStream) throws IOException {
        CramHeader cramHeader = CramIO.readFormatDefinition(inputStream);
        SAMFileHeader sAMFileHeader = CramIO.readSAMFileHeader(cramHeader.getVersion(), inputStream, new String(cramHeader.getId()));
        return new CramHeader(cramHeader.getVersion(), new String(cramHeader.getId()), sAMFileHeader);
    }

    private static byte[] toByteArray(SAMFileHeader sAMFileHeader) {
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(exposedByteArrayOutputStream);
        new SAMTextHeaderCodec().encode(outputStreamWriter, sAMFileHeader);
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(exposedByteArrayOutputStream.size());
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static long writeContainerForSamFileHeader(int n, SAMFileHeader sAMFileHeader, OutputStream outputStream) throws IOException {
        byte[] byArray = CramIO.toByteArray(sAMFileHeader);
        int n2 = Math.max(1024, byArray.length + byArray.length / 2);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n2));
        Block block = Block.buildNewFileHeaderBlock(byArray2);
        Container container = new Container();
        container.blockCount = 1;
        container.blocks = new Block[]{block};
        container.landmarks = new int[0];
        container.slices = new Slice[0];
        container.alignmentSpan = 0;
        container.alignmentStart = 0;
        container.bases = 0L;
        container.globalRecordCounter = 0L;
        container.nofRecords = 0;
        container.sequenceId = 0;
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        block.write(n, exposedByteArrayOutputStream);
        container.containerByteSize = exposedByteArrayOutputStream.size();
        int n3 = ContainerIO.writeContainerHeader(n, container, outputStream);
        outputStream.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
        return n3 + exposedByteArrayOutputStream.size();
    }

    private static SAMFileHeader readSAMFileHeader(Version version, InputStream inputStream, String string) throws IOException {
        int n;
        Block block;
        Object object;
        Container container = ContainerIO.readContainerHeader(version.major, inputStream);
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            object = new byte[container.containerByteSize];
            InputStreamUtils.readFully(inputStream, (byte[])object, 0, ((byte[])object).length);
            block = Block.readFromInputStream(version.major, new ByteArrayInputStream((byte[])object));
        } else {
            block = Block.readFromInputStream(version.major, inputStream);
        }
        inputStream = new ByteArrayInputStream(block.getRawContent());
        object = ByteBuffer.allocate(4);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        for (n = 0; n < 4; ++n) {
            ((ByteBuffer)object).put((byte)inputStream.read());
        }
        ((ByteBuffer)object).flip();
        n = ((ByteBuffer)object).asIntBuffer().get();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        BufferedLineReader bufferedLineReader = new BufferedLineReader(new ByteArrayInputStream(byArray));
        SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
        return sAMTextHeaderCodec.decode(bufferedLineReader, string);
    }

    public static boolean replaceCramHeader(File file, CramHeader cramHeader) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(new FileInputStream(file));
        CramHeader cramHeader2 = CramIO.readFormatDefinition(countingInputStream);
        Container container = ContainerIO.readContainerHeader(cramHeader2.getVersion().major, countingInputStream);
        long l = countingInputStream.getCount();
        countingInputStream.close();
        Block block = Block.buildNewFileHeaderBlock(CramIO.toByteArray(cramHeader.getSamFileHeader()));
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = new ExposedByteArrayOutputStream();
        block.write(cramHeader.getVersion().major, exposedByteArrayOutputStream);
        if (exposedByteArrayOutputStream.size() > container.containerByteSize) {
            log.error("Failed to replace CRAM header because the new header does not fit.");
            return false;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.seek(l);
        randomAccessFile.write(exposedByteArrayOutputStream.getBuffer(), 0, exposedByteArrayOutputStream.size());
        randomAccessFile.close();
        return true;
    }
}

