/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanBitCode;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class HuffmanByteHelper {
    TreeMap<Integer, HuffmanBitCode> codes;
    private final int[] values;
    private final int[] bitLengths;
    private TreeMap<Integer, SortedSet<Integer>> codeBook;
    private final HuffmanBitCode[] sortedCodes;
    private final int[] sortedValuesByBitCode;
    private final int[] sortedBitLensByBitCode;
    private final int[] bitCodeToValue;
    private final HuffmanBitCode[] valueToCode;
    private static final Comparator<HuffmanBitCode> bitCodeComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode huffmanBitCode, HuffmanBitCode huffmanBitCode2) {
            int n = huffmanBitCode.bitLength - huffmanBitCode2.bitLength;
            if (n == 0) {
                return huffmanBitCode.bitCode - huffmanBitCode2.bitCode;
            }
            return n;
        }
    };

    HuffmanByteHelper(byte[] byArray, int[] nArray) {
        int n;
        this.values = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.values[i] = 0xFF & byArray[i];
        }
        this.bitLengths = nArray;
        this.buildCodeBook();
        this.buildCodes();
        ArrayList<HuffmanBitCode> arrayList = new ArrayList<HuffmanBitCode>(this.codes.size());
        arrayList.addAll(this.codes.values());
        Collections.sort(arrayList, bitCodeComparator);
        this.sortedCodes = arrayList.toArray(new HuffmanBitCode[arrayList.size()]);
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Arrays.sort(byArray2);
        this.sortedValuesByBitCode = new int[this.sortedCodes.length];
        this.sortedBitLensByBitCode = new int[this.sortedCodes.length];
        int n2 = 0;
        for (n = 0; n < this.sortedCodes.length; ++n) {
            this.sortedValuesByBitCode[n] = this.sortedCodes[n].value;
            this.sortedBitLensByBitCode[n] = this.sortedCodes[n].bitLength;
            if (n2 >= this.sortedCodes[n].bitCode) continue;
            n2 = this.sortedCodes[n].bitCode;
        }
        this.bitCodeToValue = new int[n2 + 1];
        Arrays.fill(this.bitCodeToValue, -1);
        for (n = 0; n < this.sortedCodes.length; ++n) {
            this.bitCodeToValue[this.sortedCodes[n].bitCode] = n;
        }
        this.valueToCode = new HuffmanBitCode[255];
        Arrays.fill(this.valueToCode, null);
        HuffmanBitCode[] huffmanBitCodeArray = this.sortedCodes;
        int n3 = huffmanBitCodeArray.length;
        for (int i = 0; i < n3; ++i) {
            HuffmanBitCode huffmanBitCode;
            this.valueToCode[huffmanBitCode.value] = huffmanBitCode = huffmanBitCodeArray[i];
        }
    }

    private void buildCodeBook() {
        this.codeBook = new TreeMap();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.codeBook.containsKey(this.bitLengths[i])) {
                this.codeBook.get(this.bitLengths[i]).add(this.values[i]);
                continue;
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(this.values[i]);
            this.codeBook.put(this.bitLengths[i], treeSet);
        }
    }

    private void buildCodes() {
        this.codes = new TreeMap();
        int n = 0;
        int n2 = -1;
        for (Integer n3 : this.codeBook.keySet()) {
            SortedSet<Integer> sortedSet = this.codeBook.get(n3);
            int n4 = Integer.parseInt(((Object)n3).toString());
            for (Integer n5 : sortedSet) {
                HuffmanBitCode huffmanBitCode = new HuffmanBitCode();
                huffmanBitCode.bitLength = n4;
                huffmanBitCode.value = n5;
                ++n2;
                int n6 = n4 - n;
                huffmanBitCode.bitCode = n2 <<= n6;
                n += n6;
                if (HuffmanByteHelper.NumberOfSetBits(n2) > n4) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(n5, huffmanBitCode);
            }
        }
    }

    final long write(BitOutputStream bitOutputStream, byte by) throws IOException {
        HuffmanBitCode huffmanBitCode = this.valueToCode[by];
        if (huffmanBitCode.value != by) {
            throw new RuntimeException(String.format("Searching for %d but found %s.", by, huffmanBitCode.toString()));
        }
        bitOutputStream.write(huffmanBitCode.bitCode, huffmanBitCode.bitLength);
        return huffmanBitCode.bitLength;
    }

    final byte read(BitInputStream bitInputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.sortedCodes.length; ++i) {
            int n3 = this.sortedCodes[i].bitLength;
            n2 <<= n3 - n;
            n = n3;
            int n4 = this.bitCodeToValue[n2 |= bitInputStream.readBits(n3 - n)];
            if (n4 > -1 && this.sortedBitLensByBitCode[n4] == n3) {
                return (byte)(0xFF & this.sortedValuesByBitCode[n4]);
            }
            for (int j = i; this.sortedCodes[j + 1].bitLength == n3 && j < this.sortedCodes.length; ++j) {
                ++i;
            }
        }
        throw new RuntimeException("Not found.");
    }

    private static int NumberOfSetBits(int n) {
        n -= n >> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >> 2 & 0x33333333);
        return (n + (n >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }
}

