/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.encoding.rans.RANS;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;

public class ExternalCompression {
    private static final int GZIP_COMPRESSION_LEVEL = Integer.valueOf(System.getProperty("gzip.compression.level", "5"));

    public static byte[] gzip(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream){
            {
                this.def.setLevel(GZIP_COMPRESSION_LEVEL);
            }
        };
        IOUtil.copyStream(new ByteArrayInputStream(byArray), gZIPOutputStream);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gunzip(byte[] byArray) throws IOException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
        return InputStreamUtils.readFully(gZIPInputStream);
    }

    public static byte[] bzip2(byte[] byArray) throws IOException {
        return InputStreamUtils.readFully((InputStream)new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(byArray)));
    }

    public static byte[] unbzip2(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream.read();
        byteArrayInputStream.read();
        return InputStreamUtils.readFully((InputStream)new CBZip2InputStream((InputStream)byteArrayInputStream));
    }

    public static byte[] rans(byte[] byArray, RANS.ORDER oRDER) {
        ByteBuffer byteBuffer = RANS.compress(ByteBuffer.wrap(byArray), oRDER, null);
        return ExternalCompression.toByteArray(byteBuffer);
    }

    public static byte[] rans(byte[] byArray, int n) {
        ByteBuffer byteBuffer = RANS.compress(ByteBuffer.wrap(byArray), RANS.ORDER.fromInt(n), null);
        return ExternalCompression.toByteArray(byteBuffer);
    }

    public static byte[] unrans(byte[] byArray) {
        ByteBuffer byteBuffer = RANS.uncompress(ByteBuffer.wrap(byArray), null);
        return ExternalCompression.toByteArray(byteBuffer);
    }

    public static byte[] xz(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        XZCompressorOutputStream xZCompressorOutputStream = new XZCompressorOutputStream((OutputStream)byteArrayOutputStream);
        xZCompressorOutputStream.write(byArray);
        xZCompressorOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unxz(byte[] byArray) throws IOException {
        XZCompressorInputStream xZCompressorInputStream = new XZCompressorInputStream((InputStream)new ByteArrayInputStream(byArray));
        return InputStreamUtils.readFully((InputStream)xZCompressorInputStream);
    }

    private static byte[] toByteArray(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0 && byteBuffer.array().length == byteBuffer.limit()) {
            return byteBuffer.array();
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }
}

