/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;

public class InsertSizeFilter
implements SamRecordFilter {
    final int minInsertSize;
    final int maxInsertSize;

    public InsertSizeFilter(int n, int n2) {
        if (n > n2) {
            throw new SAMException("Cannot have minInsertSize > maxInsertSize");
        }
        this.minInsertSize = n;
        this.maxInsertSize = n2;
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord) {
        if (!sAMRecord.getReadPairedFlag()) {
            return true;
        }
        int n = Math.abs(sAMRecord.getInferredInsertSize());
        return n < this.minInsertSize || n > this.maxInsertSize;
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return this.filterOut(sAMRecord) || this.filterOut(sAMRecord2);
    }
}

