/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

import htsjdk.tribble.util.RemoteURLHelper;
import htsjdk.tribble.util.URLHelper;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ParsingUtils {
    public static Map<Object, Color> colorCache = new WeakHashMap<Object, Color>(100);
    static Map<String, String> colorSymbols = new HashMap<String, String>();
    private static final Class defaultUrlHelperClass = RemoteURLHelper.class;
    public static Class urlHelperClass = defaultUrlHelperClass;

    public static InputStream openInputStream(String string) throws IOException {
        InputStream inputStream;
        if (string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:")) {
            inputStream = ParsingUtils.getURLHelper(new URL(string)).openInputStream();
        } else {
            File file = new File(string);
            inputStream = new FileInputStream(file);
        }
        return inputStream;
    }

    public static <T> String join(String string, Collection<T> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        Iterator<T> iterator = collection.iterator();
        StringBuilder stringBuilder = new StringBuilder(iterator.next().toString());
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next().toString());
        }
        return stringBuilder.toString();
    }

    public static <T extends Comparable> List<T> sortList(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static <T extends Comparable<T>, V> String sortedString(Map<T, V> map) {
        ArrayList<T> arrayList = new ArrayList<T>(map.keySet());
        Collections.sort(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Comparable comparable : arrayList) {
            arrayList2.add(comparable + "=" + map.get(comparable));
        }
        return "{" + ParsingUtils.join(", ", arrayList2.toArray(new String[arrayList2.size()])) + "}";
    }

    public static String join(String string, String[] stringArray) {
        return ParsingUtils.join(string, stringArray, 0, stringArray.length);
    }

    public static String join(String string, String[] stringArray, int n, int n2) {
        if (n2 - n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[n]);
        for (int i = n + 1; i < n2; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static List<String> split(String string, char c) {
        if (string.isEmpty()) {
            return Arrays.asList("");
        }
        ArrayList<String> arrayList = new ArrayList<String>(1 + string.length() / 2);
        int n = -1;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            arrayList.add(string.substring(n + 1, n2));
            n = n2;
            n2 = string.indexOf(c, n + 1);
        }
        arrayList.add(string.substring(n + 1));
        return arrayList;
    }

    public static int split(String string, String[] stringArray, char c) {
        return ParsingUtils.split(string, stringArray, c, false);
    }

    public static int split(String string, String[] stringArray, char c, boolean bl) {
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(c);
        if (n4 == 0) {
            if (string.length() > 1) {
                n3 = 1;
                n4 = string.indexOf(c, n3);
            } else {
                return 0;
            }
        }
        if (n4 < 0) {
            stringArray[n2++] = string.substring(n3);
            return n2;
        }
        while (n4 > 0 && n2 < n) {
            stringArray[n2++] = string.substring(n3, n4);
            n3 = n4 + 1;
            n4 = string.indexOf(c, n3);
        }
        if (bl && n2 == n) {
            stringArray[n2 - 1] = stringArray[n2 - 1] + c + string.substring(n3);
        } else if (n2 < n) {
            String string2 = string.substring(n3);
            stringArray[n2++] = string2;
        }
        return n2;
    }

    public static String trim(String string, char c) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        for (n2 = 0; n2 < cArray.length && cArray[n2] == c; ++n2) {
        }
        for (n = cArray.length - 1; n > n2 && cArray[n] == c; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public static int splitWhitespace(String string, String[] stringArray) {
        int n;
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.indexOf(9);
        int n6 = string.indexOf(32);
        int n7 = n5 < 0 ? n6 : (n = n6 < 0 ? n5 : Math.min(n6, n5));
        while (n > 0 && n3 < n2) {
            stringArray[n3++] = string.substring(n4, n);
            for (n4 = n + 1; n4 < string.length() && string.charAt(n4) == ' '; ++n4) {
            }
            n5 = string.indexOf(9, n4);
            n6 = string.indexOf(32, n4);
            n = n5 < 0 ? n6 : (n6 < 0 ? n5 : Math.min(n6, n5));
        }
        if (n3 < n2) {
            String string2 = string.substring(n4);
            stringArray[n3++] = string2;
        }
        return n3;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            if (comparable.compareTo(comparable2) > 0) {
                return false;
            }
            comparable = comparable2;
        }
        return true;
    }

    public static Color parseColor(String string) {
        try {
            Color color = colorCache.get(string);
            if (color == null) {
                if (string.contains(",")) {
                    String[] stringArray = string.split(",");
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    color = new Color(n, n2, n3);
                } else if (string.startsWith("#")) {
                    color = ParsingUtils.hexToColor(string.substring(1));
                } else {
                    String string2 = colorSymbols.get(string.toLowerCase());
                    if (string2 != null) {
                        color = ParsingUtils.hexToColor(string2);
                    }
                }
                if (color == null) {
                    color = Color.black;
                }
                colorCache.put(string, color);
            }
            return color;
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    private static Color hexToColor(String string) {
        if (string.length() == 6) {
            int n = Integer.parseInt(string.substring(0, 2), 16);
            int n2 = Integer.parseInt(string.substring(2, 4), 16);
            int n3 = Integer.parseInt(string.substring(4, 6), 16);
            return new Color(n, n2, n3);
        }
        return null;
    }

    public static boolean resourceExists(String string) throws IOException {
        boolean bl;
        boolean bl2 = bl = string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://");
        if (bl) {
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            URLHelper uRLHelper = ParsingUtils.getURLHelper(uRL);
            return uRLHelper.exists();
        }
        return new File(string).exists();
    }

    public static URLHelper getURLHelper(URL uRL) {
        try {
            return ParsingUtils.getURLHelper(urlHelperClass, uRL);
        }
        catch (Exception exception) {
            return ParsingUtils.getURLHelper(defaultUrlHelperClass, uRL);
        }
    }

    private static URLHelper getURLHelper(Class clazz, URL uRL) {
        try {
            Constructor constructor = clazz.getConstructor(URL.class);
            return (URLHelper)constructor.newInstance(uRL);
        }
        catch (Exception exception) {
            String string = "Error instantiating url helper for class: " + clazz;
            throw new IllegalStateException(string, exception);
        }
    }

    public static void registerHelperClass(Class clazz) {
        if (!URLHelper.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("helperClass must implement URLHelper");
        }
        urlHelperClass = clazz;
    }

    public static String appendToPath(String string, String string2) {
        String string3 = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null) {
            String string4 = uRL.getPath();
            String string5 = string4 + string2;
            string3 = string.replace(string4, string5);
        } else {
            string3 = string + string2;
        }
        return string3;
    }

    static {
        colorSymbols.put("white", "FFFFFF");
        colorSymbols.put("silver", "C0C0C0");
        colorSymbols.put("gray", "808080");
        colorSymbols.put("black", "000000");
        colorSymbols.put("red", "FF0000");
        colorSymbols.put("maroon", "800000");
        colorSymbols.put("yellow", "FFFF00");
        colorSymbols.put("olive", "808000");
        colorSymbols.put("lime", "00FF00");
        colorSymbols.put("green", "008000");
        colorSymbols.put("aqua", "00FFFF");
        colorSymbols.put("teal", "008080");
        colorSymbols.put("blue", "0000FF");
        colorSymbols.put("navy", "000080");
        colorSymbols.put("fuchsia", "FF00FF");
        colorSymbols.put("purple", "800080");
        colorSymbols.put("orange", "FFA500");
        colorSymbols.put("magenta", "FF00FF");
    }
}

