/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class VCFHeader
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Set<VCFHeaderLine> mMetaData = new LinkedHashSet<VCFHeaderLine>();
    private final Map<String, VCFInfoHeaderLine> mInfoMetaData = new LinkedHashMap<String, VCFInfoHeaderLine>();
    private final Map<String, VCFFormatHeaderLine> mFormatMetaData = new LinkedHashMap<String, VCFFormatHeaderLine>();
    private final Map<String, VCFFilterHeaderLine> mFilterMetaData = new LinkedHashMap<String, VCFFilterHeaderLine>();
    private final Map<String, VCFHeaderLine> mOtherMetaData = new LinkedHashMap<String, VCFHeaderLine>();
    private final List<VCFContigHeaderLine> contigMetaData = new ArrayList<VCFContigHeaderLine>();
    private final List<String> mGenotypeSampleNames = new ArrayList<String>();
    public static final String METADATA_INDICATOR = "##";
    public static final String HEADER_INDICATOR = "#";
    public static final String SOURCE_KEY = "source";
    public static final String REFERENCE_KEY = "reference";
    public static final String CONTIG_KEY = "contig";
    public static final String INTERVALS_KEY = "intervals";
    public static final String EXCLUDE_INTERVALS_KEY = "excludeIntervals";
    public static final String INTERVAL_MERGING_KEY = "interval_merging";
    public static final String INTERVAL_SET_RULE_KEY = "interval_set_rule";
    public static final String INTERVAL_PADDING_KEY = "interval_padding";
    private boolean samplesWereAlreadySorted = true;
    private ArrayList<String> sampleNamesInOrder = null;
    private HashMap<String, Integer> sampleNameToOffset = null;
    private boolean writeEngineHeaders = true;
    private boolean writeCommandLine = true;

    public VCFHeader() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public VCFHeader(Set<VCFHeaderLine> set) {
        this.mMetaData.addAll(set);
        this.removeVCFVersionLines(this.mMetaData);
        this.createLookupEntriesForAllHeaderLines();
        this.checkForDeprecatedGenotypeLikelihoodsKey();
    }

    public VCFHeader(VCFHeader vCFHeader) {
        this(vCFHeader.mMetaData, vCFHeader.mGenotypeSampleNames);
    }

    public VCFHeader(Set<VCFHeaderLine> set, Set<String> set2) {
        this(set, new ArrayList<String>(set2));
    }

    public VCFHeader(Set<VCFHeaderLine> set, List<String> list) {
        this(set);
        if (list.size() != new HashSet<String>(list).size()) {
            throw new TribbleException.InvalidHeader("BUG: VCF header has duplicate sample names");
        }
        this.mGenotypeSampleNames.addAll(list);
        this.samplesWereAlreadySorted = ParsingUtils.isSorted(list);
        this.buildVCFReaderMaps(list);
    }

    private void buildVCFReaderMaps(Collection<String> collection) {
        this.sampleNamesInOrder = new ArrayList(collection.size());
        this.sampleNameToOffset = new HashMap(collection.size());
        int n = 0;
        for (String string : collection) {
            this.sampleNamesInOrder.add(string);
            this.sampleNameToOffset.put(string, n++);
        }
        Collections.sort(this.sampleNamesInOrder);
    }

    public void addMetaDataLine(VCFHeaderLine vCFHeaderLine) {
        if (this.addMetadataLineLookupEntry(vCFHeaderLine)) {
            this.mMetaData.add(vCFHeaderLine);
            this.checkForDeprecatedGenotypeLikelihoodsKey();
        }
    }

    public List<VCFContigHeaderLine> getContigLines() {
        return Collections.unmodifiableList(this.contigMetaData);
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        List<VCFContigHeaderLine> list = this.getContigLines();
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<SAMSequenceRecord> arrayList = new ArrayList<SAMSequenceRecord>(list.size());
        for (VCFContigHeaderLine vCFContigHeaderLine : list) {
            arrayList.add(vCFContigHeaderLine.getSAMSequenceRecord());
        }
        return new SAMSequenceDictionary(arrayList);
    }

    public void setSequenceDictionary(SAMSequenceDictionary sAMSequenceDictionary) {
        this.contigMetaData.clear();
        ArrayList<VCFHeaderLine> arrayList = new ArrayList<VCFHeaderLine>();
        for (VCFHeaderLine serializable : this.mMetaData) {
            if (!(serializable instanceof VCFContigHeaderLine)) continue;
            arrayList.add(serializable);
        }
        this.mMetaData.removeAll(arrayList);
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            this.contigMetaData.add(new VCFContigHeaderLine(sAMSequenceRecord, sAMSequenceRecord.getAssembly()));
        }
        this.mMetaData.addAll(this.contigMetaData);
    }

    public VariantContextComparator getVCFRecordComparator() {
        return new VariantContextComparator((Collection<VCFContigHeaderLine>)this.getContigLines());
    }

    public List<VCFFilterHeaderLine> getFilterLines() {
        ArrayList<VCFFilterHeaderLine> arrayList = new ArrayList<VCFFilterHeaderLine>();
        for (VCFHeaderLine vCFHeaderLine : this.mMetaData) {
            if (!(vCFHeaderLine instanceof VCFFilterHeaderLine)) continue;
            arrayList.add((VCFFilterHeaderLine)vCFHeaderLine);
        }
        return arrayList;
    }

    public List<VCFIDHeaderLine> getIDHeaderLines() {
        ArrayList<VCFIDHeaderLine> arrayList = new ArrayList<VCFIDHeaderLine>();
        for (VCFHeaderLine vCFHeaderLine : this.mMetaData) {
            if (!(vCFHeaderLine instanceof VCFIDHeaderLine)) continue;
            arrayList.add((VCFIDHeaderLine)((Object)vCFHeaderLine));
        }
        return arrayList;
    }

    private void removeVCFVersionLines(Set<VCFHeaderLine> set) {
        ArrayList<VCFHeaderLine> arrayList = new ArrayList<VCFHeaderLine>();
        for (VCFHeaderLine vCFHeaderLine : set) {
            if (!VCFHeaderVersion.isFormatString(vCFHeaderLine.getKey())) continue;
            arrayList.add(vCFHeaderLine);
        }
        set.removeAll(arrayList);
    }

    private void createLookupEntriesForAllHeaderLines() {
        for (VCFHeaderLine vCFHeaderLine : this.mMetaData) {
            this.addMetadataLineLookupEntry(vCFHeaderLine);
        }
    }

    private boolean addMetadataLineLookupEntry(VCFHeaderLine vCFHeaderLine) {
        if (vCFHeaderLine instanceof VCFInfoHeaderLine) {
            VCFInfoHeaderLine vCFInfoHeaderLine = (VCFInfoHeaderLine)vCFHeaderLine;
            return this.addMetaDataLineMapLookupEntry(this.mInfoMetaData, vCFInfoHeaderLine.getID(), vCFInfoHeaderLine);
        }
        if (vCFHeaderLine instanceof VCFFormatHeaderLine) {
            VCFFormatHeaderLine vCFFormatHeaderLine = (VCFFormatHeaderLine)vCFHeaderLine;
            return this.addMetaDataLineMapLookupEntry(this.mFormatMetaData, vCFFormatHeaderLine.getID(), vCFFormatHeaderLine);
        }
        if (vCFHeaderLine instanceof VCFFilterHeaderLine) {
            VCFFilterHeaderLine vCFFilterHeaderLine = (VCFFilterHeaderLine)vCFHeaderLine;
            return this.addMetaDataLineMapLookupEntry(this.mFilterMetaData, vCFFilterHeaderLine.getID(), vCFFilterHeaderLine);
        }
        if (vCFHeaderLine instanceof VCFContigHeaderLine) {
            return this.addContigMetaDataLineLookupEntry((VCFContigHeaderLine)vCFHeaderLine);
        }
        return this.addMetaDataLineMapLookupEntry(this.mOtherMetaData, vCFHeaderLine.getKey(), vCFHeaderLine);
    }

    private boolean addContigMetaDataLineLookupEntry(VCFContigHeaderLine vCFContigHeaderLine) {
        for (VCFContigHeaderLine vCFContigHeaderLine2 : this.contigMetaData) {
            if (!vCFContigHeaderLine2.getID().equals(vCFContigHeaderLine.getID())) continue;
            return false;
        }
        this.contigMetaData.add(vCFContigHeaderLine);
        return true;
    }

    private <T extends VCFHeaderLine> boolean addMetaDataLineMapLookupEntry(Map<String, T> map, String string, T t) {
        if (map.containsKey(string)) {
            return false;
        }
        map.put(string, t);
        return true;
    }

    private void checkForDeprecatedGenotypeLikelihoodsKey() {
        if (this.hasFormatLine("GL") && !this.hasFormatLine("PL")) {
            this.addMetaDataLine(new VCFFormatHeaderLine("PL", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Normalized, Phred-scaled likelihoods for genotypes as defined in the VCF specification"));
        }
    }

    public Set<HEADER_FIELDS> getHeaderFields() {
        return new LinkedHashSet<HEADER_FIELDS>(Arrays.asList(HEADER_FIELDS.values()));
    }

    public Set<VCFHeaderLine> getMetaDataInInputOrder() {
        return VCFHeader.makeGetMetaDataSet(this.mMetaData);
    }

    public Set<VCFHeaderLine> getMetaDataInSortedOrder() {
        return VCFHeader.makeGetMetaDataSet(new TreeSet<VCFHeaderLine>(this.mMetaData));
    }

    private static Set<VCFHeaderLine> makeGetMetaDataSet(Set<VCFHeaderLine> set) {
        LinkedHashSet<VCFHeaderLine> linkedHashSet = new LinkedHashSet<VCFHeaderLine>();
        linkedHashSet.add(new VCFHeaderLine(VCFHeaderVersion.VCF4_1.getFormatString(), VCFHeaderVersion.VCF4_1.getVersionString()));
        linkedHashSet.addAll(set);
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public VCFHeaderLine getMetaDataLine(String string) {
        for (VCFHeaderLine vCFHeaderLine : this.mMetaData) {
            if (!vCFHeaderLine.getKey().equals(string)) continue;
            return vCFHeaderLine;
        }
        return null;
    }

    public List<String> getGenotypeSamples() {
        return this.mGenotypeSampleNames;
    }

    public int getNGenotypeSamples() {
        return this.mGenotypeSampleNames.size();
    }

    public boolean hasGenotypingData() {
        return this.getNGenotypeSamples() > 0;
    }

    public boolean samplesWereAlreadySorted() {
        return this.samplesWereAlreadySorted;
    }

    public int getColumnCount() {
        return HEADER_FIELDS.values().length + (this.hasGenotypingData() ? this.mGenotypeSampleNames.size() + 1 : 0);
    }

    public Collection<VCFInfoHeaderLine> getInfoHeaderLines() {
        return this.mInfoMetaData.values();
    }

    public Collection<VCFFormatHeaderLine> getFormatHeaderLines() {
        return this.mFormatMetaData.values();
    }

    public VCFInfoHeaderLine getInfoHeaderLine(String string) {
        return this.mInfoMetaData.get(string);
    }

    public VCFFormatHeaderLine getFormatHeaderLine(String string) {
        return this.mFormatMetaData.get(string);
    }

    public VCFFilterHeaderLine getFilterHeaderLine(String string) {
        return this.mFilterMetaData.get(string);
    }

    public boolean hasInfoLine(String string) {
        return this.getInfoHeaderLine(string) != null;
    }

    public boolean hasFormatLine(String string) {
        return this.getFormatHeaderLine(string) != null;
    }

    public boolean hasFilterLine(String string) {
        return this.getFilterHeaderLine(string) != null;
    }

    public VCFHeaderLine getOtherHeaderLine(String string) {
        return this.mOtherMetaData.get(string);
    }

    public Collection<VCFHeaderLine> getOtherHeaderLines() {
        return this.mOtherMetaData.values();
    }

    public boolean isWriteEngineHeaders() {
        return this.writeEngineHeaders;
    }

    public void setWriteEngineHeaders(boolean bl) {
        this.writeEngineHeaders = bl;
    }

    public boolean isWriteCommandLine() {
        return this.writeCommandLine;
    }

    public void setWriteCommandLine(boolean bl) {
        this.writeCommandLine = bl;
    }

    public ArrayList<String> getSampleNamesInOrder() {
        return this.sampleNamesInOrder;
    }

    public HashMap<String, Integer> getSampleNameToOffset() {
        return this.sampleNameToOffset;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[VCFHeader:");
        for (VCFHeaderLine vCFHeaderLine : this.mMetaData) {
            stringBuilder.append("\n\t").append(vCFHeaderLine);
        }
        return stringBuilder.append("\n]").toString();
    }

    public static enum HEADER_FIELDS {
        CHROM,
        POS,
        ID,
        REF,
        ALT,
        QUAL,
        FILTER,
        INFO;

    }
}

