/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.DiskBasedBAMFileIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.StringLineReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

class BAMFileReader
extends SamReader.ReaderImplementation {
    private boolean mIsSeekable = false;
    private BinaryCodec mStream = null;
    private final BlockCompressedInputStream mCompressedInputStream;
    private SAMFileHeader mFileHeader = null;
    private File mIndexFile = null;
    private SeekableStream mIndexStream = null;
    private BAMIndex mIndex = null;
    private long mFirstRecordPointer = 0L;
    private CloseableIterator<SAMRecord> mCurrentIterator = null;
    private boolean eagerDecode;
    private ValidationStringency mValidationStringency;
    private SAMRecordFactory samRecordFactory;
    private boolean mEnableIndexCaching = false;
    private boolean mEnableIndexMemoryMapping = true;
    private SamReader mReader = null;

    BAMFileReader(InputStream inputStream, File file, boolean bl, ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this.mIndexFile = file;
        this.mIsSeekable = false;
        this.mCompressedInputStream = new BlockCompressedInputStream(inputStream);
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = bl;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = sAMRecordFactory;
        this.mFileHeader = BAMFileReader.readHeader(this.mStream, this.mValidationStringency, null);
    }

    BAMFileReader(File file, File file2, boolean bl, ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this(new BlockCompressedInputStream(file), file2 != null ? file2 : SamFiles.findIndex(file), bl, file.getAbsolutePath(), validationStringency, sAMRecordFactory);
        if (this.mIndexFile != null && this.mIndexFile.lastModified() < file.lastModified()) {
            System.err.println("WARNING: BAM index file " + this.mIndexFile.getAbsolutePath() + " is older than BAM " + file.getAbsolutePath());
        }
        this.mStream.setInputFileName(file.getAbsolutePath());
    }

    BAMFileReader(SeekableStream seekableStream, File file, boolean bl, ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this(new BlockCompressedInputStream(seekableStream), file, bl, seekableStream.getSource(), validationStringency, sAMRecordFactory);
    }

    BAMFileReader(SeekableStream seekableStream, SeekableStream seekableStream2, boolean bl, ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this(new BlockCompressedInputStream(seekableStream), seekableStream2, bl, seekableStream.getSource(), validationStringency, sAMRecordFactory);
    }

    private BAMFileReader(BlockCompressedInputStream blockCompressedInputStream, File file, boolean bl, String string, ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this.mIndexFile = file;
        this.mIsSeekable = true;
        this.mCompressedInputStream = blockCompressedInputStream;
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = bl;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = sAMRecordFactory;
        this.mFileHeader = BAMFileReader.readHeader(this.mStream, this.mValidationStringency, string);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    private BAMFileReader(BlockCompressedInputStream blockCompressedInputStream, SeekableStream seekableStream, boolean bl, String string, ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) throws IOException {
        this.mIndexStream = seekableStream;
        this.mIsSeekable = true;
        this.mCompressedInputStream = blockCompressedInputStream;
        this.mStream = new BinaryCodec(new DataInputStream(this.mCompressedInputStream));
        this.eagerDecode = bl;
        this.mValidationStringency = validationStringency;
        this.samRecordFactory = sAMRecordFactory;
        this.mFileHeader = BAMFileReader.readHeader(this.mStream, this.mValidationStringency, string);
        this.mFirstRecordPointer = this.mCompressedInputStream.getFilePointer();
    }

    static long findVirtualOffsetOfFirstRecord(File file) throws IOException {
        BAMFileReader bAMFileReader = new BAMFileReader(file, null, false, ValidationStringency.SILENT, (SAMRecordFactory)new DefaultSAMRecordFactory());
        long l = bAMFileReader.mFirstRecordPointer;
        bAMFileReader.close();
        return l;
    }

    @Override
    void enableFileSource(SamReader samReader, boolean bl) {
        this.mReader = bl ? samReader : null;
    }

    @Override
    protected void enableIndexCaching(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mEnableIndexCaching = bl;
    }

    @Override
    protected void enableIndexMemoryMapping(boolean bl) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to change index memory mapping; index file has already been loaded.");
        }
        this.mEnableIndexMemoryMapping = bl;
    }

    @Override
    void enableCrcChecking(boolean bl) {
        this.mCompressedInputStream.setCheckCrcs(bl);
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
        this.samRecordFactory = sAMRecordFactory;
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.BAM_TYPE;
    }

    @Override
    public boolean hasIndex() {
        return this.mIsSeekable && (this.mIndexFile != null || this.mIndexStream != null);
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            this.mIndex = this.mIndexFile != null ? (this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, this.getFileHeader().getSequenceDictionary(), this.mEnableIndexMemoryMapping)) : (this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexStream, this.getFileHeader().getSequenceDictionary()) : new DiskBasedBAMFileIndex(this.mIndexStream, this.getFileHeader().getSequenceDictionary()));
        }
        return this.mIndex;
    }

    public void setEagerDecode(boolean bl) {
        this.eagerDecode = bl;
    }

    @Override
    public void close() {
        if (this.mCompressedInputStream != null) {
            try {
                this.mCompressedInputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Exception closing compressed input stream.", iOException);
            }
        }
        if (this.mStream != null) {
            this.mStream.close();
        }
        if (this.mIndex != null) {
            this.mIndex.close();
        }
        this.mStream = null;
        this.mFileHeader = null;
        this.mIndex = null;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (this.mIsSeekable) {
            try {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException.getMessage(), iOException);
            }
        }
        this.mCurrentIterator = new BAMFileIterator();
        return this.mCurrentIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan sAMFileSpan) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!(sAMFileSpan instanceof BAMFileSpan)) {
            throw new IllegalStateException("BAMFileReader cannot handle this type of file span.");
        }
        this.mCurrentIterator = new BAMFileIndexIterator(((BAMFileSpan)sAMFileSpan).toCoordinateArray());
        return this.mCurrentIterator;
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        return new BAMFileSpan(new Chunk(this.mFirstRecordPointer, Long.MAX_VALUE));
    }

    CloseableIterator<SAMRecord> query(String string, int n, int n2, boolean bl) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        int n3 = this.mFileHeader.getSequenceIndex(string);
        if (n3 == -1) {
            this.mCurrentIterator = new EmptyBamIterator();
        } else {
            QueryInterval[] queryIntervalArray = new QueryInterval[]{new QueryInterval(n3, n, n2)};
            this.mCurrentIterator = this.createIndexIterator(queryIntervalArray, bl);
        }
        return this.mCurrentIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] queryIntervalArray, boolean bl) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        this.mCurrentIterator = this.createIndexIterator(queryIntervalArray, bl);
        return this.mCurrentIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String string, int n) {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        int n2 = this.mFileHeader.getSequenceIndex(string);
        this.mCurrentIterator = n2 == -1 ? new EmptyBamIterator() : this.createStartingAtIndexIterator(n2, n);
        return this.mCurrentIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        if (this.mStream == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mCurrentIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (!this.mIsSeekable) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        try {
            long l = this.getIndex().getStartOfLastLinearBin();
            if (l != -1L) {
                this.mCompressedInputStream.seek(l);
            } else {
                this.mCompressedInputStream.seek(this.mFirstRecordPointer);
            }
            this.mCurrentIterator = new BAMFileIndexUnmappedIterator();
            return this.mCurrentIterator;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("IOException seeking to unmapped reads", iOException);
        }
    }

    protected static SAMFileHeader readHeader(BinaryCodec binaryCodec, ValidationStringency validationStringency, String string) throws IOException {
        byte[] byArray = new byte[4];
        binaryCodec.readBytes(byArray);
        if (!Arrays.equals(byArray, BAMFileConstants.BAM_MAGIC)) {
            throw new IOException("Invalid BAM file header");
        }
        int n = binaryCodec.readInt();
        String string2 = binaryCodec.readString(n);
        SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
        sAMTextHeaderCodec.setValidationStringency(validationStringency);
        SAMFileHeader sAMFileHeader = sAMTextHeaderCodec.decode(new StringLineReader(string2), string);
        int n2 = binaryCodec.readInt();
        if (!sAMFileHeader.getSequenceDictionary().isEmpty()) {
            if (n2 != sAMFileHeader.getSequenceDictionary().size()) {
                throw new SAMFormatException("Number of sequences in text header (" + sAMFileHeader.getSequenceDictionary().size() + ") != number of sequences in binary header (" + n2 + ") for file " + string);
            }
            for (int i = 0; i < n2; ++i) {
                SAMSequenceRecord sAMSequenceRecord = BAMFileReader.readSequenceRecord(binaryCodec, string);
                SAMSequenceRecord sAMSequenceRecord2 = sAMFileHeader.getSequence(i);
                if (!sAMSequenceRecord2.getSequenceName().equals(sAMSequenceRecord.getSequenceName())) {
                    throw new SAMFormatException("For sequence " + i + ", text and binary have different names in file " + string);
                }
                if (sAMSequenceRecord2.getSequenceLength() == sAMSequenceRecord.getSequenceLength()) continue;
                throw new SAMFormatException("For sequence " + i + ", text and binary have different lengths in file " + string);
            }
        } else {
            ArrayList<SAMSequenceRecord> arrayList = new ArrayList<SAMSequenceRecord>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(BAMFileReader.readSequenceRecord(binaryCodec, string));
            }
            sAMFileHeader.setSequenceDictionary(new SAMSequenceDictionary(arrayList));
        }
        return sAMFileHeader;
    }

    private static SAMSequenceRecord readSequenceRecord(BinaryCodec binaryCodec, String string) {
        int n = binaryCodec.readInt();
        if (n <= 1) {
            throw new SAMFormatException("Invalid BAM file header: missing sequence name in file " + string);
        }
        String string2 = binaryCodec.readString(n - 1);
        binaryCodec.readByte();
        int n2 = binaryCodec.readInt();
        return new SAMSequenceRecord(SAMSequenceRecord.truncateSequenceName(string2), n2);
    }

    private CloseableIterator<SAMRecord> createStartingAtIndexIterator(int n, int n2) {
        BAMIndex bAMIndex = this.getIndex();
        BAMFileSpan bAMFileSpan = bAMIndex.getSpanOverlapping(n, n2, 0);
        long[] lArray = bAMFileSpan != null ? bAMFileSpan.toCoordinateArray() : null;
        BAMFileIndexIterator bAMFileIndexIterator = new BAMFileIndexIterator(lArray);
        return new BAMQueryFilteringIterator(bAMFileIndexIterator, new BAMStartingAtIteratorFilter(n, n2));
    }

    private void assertIntervalsOptimized(QueryInterval[] queryIntervalArray) {
        if (queryIntervalArray.length == 0) {
            return;
        }
        for (int i = 1; i < queryIntervalArray.length; ++i) {
            QueryInterval queryInterval = queryIntervalArray[i - 1];
            QueryInterval queryInterval2 = queryIntervalArray[i];
            if (queryInterval.compareTo(queryInterval2) >= 0) {
                throw new IllegalArgumentException(String.format("List of intervals is not sorted: %s >= %s", queryInterval, queryInterval2));
            }
            if (queryInterval.overlaps(queryInterval2)) {
                throw new IllegalArgumentException(String.format("List of intervals is not optimized: %s intersects %s", queryInterval, queryInterval2));
            }
            if (!queryInterval.abuts(queryInterval2)) continue;
            throw new IllegalArgumentException(String.format("List of intervals is not optimized: %s abuts %s", queryInterval, queryInterval2));
        }
    }

    private CloseableIterator<SAMRecord> createIndexIterator(QueryInterval[] queryIntervalArray, boolean bl) {
        Object object;
        this.assertIntervalsOptimized(queryIntervalArray);
        BAMFileSpan[] bAMFileSpanArray = new BAMFileSpan[queryIntervalArray.length];
        BAMIndex bAMIndex = this.getIndex();
        for (int i = 0; i < queryIntervalArray.length; ++i) {
            BAMFileSpan bAMFileSpan;
            object = queryIntervalArray[i];
            bAMFileSpanArray[i] = bAMFileSpan = bAMIndex.getSpanOverlapping(((QueryInterval)object).referenceIndex, ((QueryInterval)object).start, ((QueryInterval)object).end);
        }
        long[] lArray = bAMFileSpanArray.length > 0 ? BAMFileSpan.merge(bAMFileSpanArray).toCoordinateArray() : null;
        object = new BAMFileIndexIterator(lArray);
        return new BAMQueryFilteringIterator((CloseableIterator<SAMRecord>)object, new BAMQueryMultipleIntervalsIteratorFilter(queryIntervalArray, bl));
    }

    private static enum FilteringIteratorState {
        MATCHES_FILTER,
        STOP_ITERATION,
        CONTINUE_ITERATION;

    }

    private static enum IntervalComparison {
        BEFORE,
        AFTER,
        OVERLAPPING,
        CONTAINED;

    }

    private class BAMQueryMultipleIntervalsIteratorFilter
    implements BAMIteratorFilter {
        final QueryInterval[] intervals;
        final boolean contained;
        int intervalIndex = 0;

        public BAMQueryMultipleIntervalsIteratorFilter(QueryInterval[] queryIntervalArray, boolean bl) {
            this.contained = bl;
            this.intervals = queryIntervalArray;
        }

        @Override
        public FilteringIteratorState compareToFilter(SAMRecord sAMRecord) {
            while (this.intervalIndex < this.intervals.length) {
                IntervalComparison intervalComparison = this.compareIntervalToRecord(this.intervals[this.intervalIndex], sAMRecord);
                switch (intervalComparison) {
                    case BEFORE: {
                        ++this.intervalIndex;
                        break;
                    }
                    case AFTER: {
                        return FilteringIteratorState.CONTINUE_ITERATION;
                    }
                    case CONTAINED: {
                        return FilteringIteratorState.MATCHES_FILTER;
                    }
                    case OVERLAPPING: {
                        return this.contained ? FilteringIteratorState.CONTINUE_ITERATION : FilteringIteratorState.MATCHES_FILTER;
                    }
                }
            }
            return FilteringIteratorState.STOP_ITERATION;
        }

        private IntervalComparison compareIntervalToRecord(QueryInterval queryInterval, SAMRecord sAMRecord) {
            int n = queryInterval.end <= 0 ? Integer.MAX_VALUE : queryInterval.end;
            int n2 = sAMRecord.getReadUnmappedFlag() && sAMRecord.getAlignmentStart() != 0 ? sAMRecord.getAlignmentStart() : sAMRecord.getAlignmentEnd();
            if (queryInterval.referenceIndex < sAMRecord.getReferenceIndex()) {
                return IntervalComparison.BEFORE;
            }
            if (queryInterval.referenceIndex > sAMRecord.getReferenceIndex()) {
                return IntervalComparison.AFTER;
            }
            if (n < sAMRecord.getAlignmentStart()) {
                return IntervalComparison.BEFORE;
            }
            if (n2 < queryInterval.start) {
                return IntervalComparison.AFTER;
            }
            if (CoordMath.encloses(queryInterval.start, n, sAMRecord.getAlignmentStart(), n2)) {
                return IntervalComparison.CONTAINED;
            }
            return IntervalComparison.OVERLAPPING;
        }
    }

    private class BAMFileIndexUnmappedIterator
    extends BAMFileIterator {
        private BAMFileIndexUnmappedIterator() {
            while (this.hasNext() && this.peek().getReferenceIndex() != -1) {
                this.advance();
            }
        }
    }

    private class BAMStartingAtIteratorFilter
    implements BAMIteratorFilter {
        private final int mReferenceIndex;
        private final int mRegionStart;

        public BAMStartingAtIteratorFilter(int n, int n2) {
            this.mReferenceIndex = n;
            this.mRegionStart = n2;
        }

        @Override
        public FilteringIteratorState compareToFilter(SAMRecord sAMRecord) {
            int n = sAMRecord.getReferenceIndex();
            if (n < 0 || n > this.mReferenceIndex) {
                return FilteringIteratorState.STOP_ITERATION;
            }
            if (n < this.mReferenceIndex) {
                return FilteringIteratorState.CONTINUE_ITERATION;
            }
            int n2 = sAMRecord.getAlignmentStart();
            if (n2 > this.mRegionStart) {
                return FilteringIteratorState.STOP_ITERATION;
            }
            if (n2 == this.mRegionStart) {
                return FilteringIteratorState.MATCHES_FILTER;
            }
            return FilteringIteratorState.CONTINUE_ITERATION;
        }
    }

    static interface BAMIteratorFilter {
        public FilteringIteratorState compareToFilter(SAMRecord var1);
    }

    public class BAMQueryFilteringIterator
    extends AbstractBamIterator {
        protected final CloseableIterator<SAMRecord> wrappedIterator;
        protected SAMRecord mNextRecord;
        private final BAMIteratorFilter iteratorFilter;

        public BAMQueryFilteringIterator(CloseableIterator<SAMRecord> closeableIterator, BAMIteratorFilter bAMIteratorFilter) {
            this.wrappedIterator = closeableIterator;
            this.iteratorFilter = bAMIteratorFilter;
            this.mNextRecord = this.advance();
        }

        @Override
        public boolean hasNext() {
            this.assertOpen();
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("BAMQueryFilteringIterator: no next element available");
            }
            SAMRecord sAMRecord = this.mNextRecord;
            this.mNextRecord = this.advance();
            return sAMRecord;
        }

        SAMRecord advance() {
            block5: while (true) {
                if (!this.wrappedIterator.hasNext()) {
                    return null;
                }
                SAMRecord sAMRecord = (SAMRecord)this.wrappedIterator.next();
                switch (this.iteratorFilter.compareToFilter(sAMRecord)) {
                    case MATCHES_FILTER: {
                        return sAMRecord;
                    }
                    case STOP_ITERATION: {
                        return null;
                    }
                    case CONTINUE_ITERATION: {
                        continue block5;
                    }
                }
                break;
            }
            throw new SAMException("Unexpected return from compareToFilter");
        }
    }

    private class BAMFileIndexIterator
    extends BAMFileIterator {
        private long[] mFilePointers;
        private int mFilePointerIndex;
        private long mFilePointerLimit;

        BAMFileIndexIterator(long[] lArray) {
            super(false);
            this.mFilePointers = null;
            this.mFilePointerIndex = 0;
            this.mFilePointerLimit = -1L;
            this.mFilePointers = lArray;
            this.advance();
        }

        @Override
        SAMRecord getNextRecord() throws IOException {
            while (BAMFileReader.this.mCompressedInputStream.getFilePointer() >= this.mFilePointerLimit) {
                if (this.mFilePointers == null || this.mFilePointerIndex >= this.mFilePointers.length) {
                    return null;
                }
                long l = this.mFilePointers[this.mFilePointerIndex++];
                long l2 = this.mFilePointers[this.mFilePointerIndex++];
                BAMFileReader.this.mCompressedInputStream.seek(l);
                this.mFilePointerLimit = l2;
            }
            return super.getNextRecord();
        }
    }

    private class BAMFileIterator
    extends AbstractBamIterator {
        private SAMRecord mNextRecord;
        private final BAMRecordCodec bamRecordCodec;
        private long samRecordIndex;

        BAMFileIterator() {
            this(true);
        }

        BAMFileIterator(boolean bl) {
            this.mNextRecord = null;
            this.samRecordIndex = 0L;
            this.bamRecordCodec = new BAMRecordCodec(BAMFileReader.this.getFileHeader(), BAMFileReader.this.samRecordFactory);
            this.bamRecordCodec.setInputStream(BAMFileReader.this.mStream.getInputStream(), BAMFileReader.this.mStream.getInputFileName());
            if (bl) {
                this.advance();
            }
        }

        @Override
        public boolean hasNext() {
            this.assertOpen();
            return this.mNextRecord != null;
        }

        @Override
        public SAMRecord next() {
            this.assertOpen();
            SAMRecord sAMRecord = this.mNextRecord;
            this.advance();
            return sAMRecord;
        }

        void advance() {
            try {
                this.mNextRecord = this.getNextRecord();
                if (this.mNextRecord != null) {
                    ++this.samRecordIndex;
                    this.mNextRecord.setValidationStringency(BAMFileReader.this.mValidationStringency);
                    if (BAMFileReader.this.mValidationStringency != ValidationStringency.SILENT) {
                        List<SAMValidationError> list = this.mNextRecord.isValid(BAMFileReader.this.mValidationStringency == ValidationStringency.STRICT);
                        SAMUtils.processValidationErrors(list, this.samRecordIndex, BAMFileReader.this.getValidationStringency());
                    }
                }
                if (BAMFileReader.this.eagerDecode && this.mNextRecord != null) {
                    this.mNextRecord.eagerDecode();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException.getMessage(), iOException);
            }
        }

        SAMRecord getNextRecord() throws IOException {
            long l = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            SAMRecord sAMRecord = this.bamRecordCodec.decode();
            long l2 = BAMFileReader.this.mCompressedInputStream.getFilePointer();
            if (BAMFileReader.this.mReader != null && sAMRecord != null) {
                sAMRecord.setFileSource(new SAMFileSource(BAMFileReader.this.mReader, new BAMFileSpan(new Chunk(l, l2))));
            }
            return sAMRecord;
        }

        protected SAMRecord peek() {
            return this.mNextRecord;
        }
    }

    private class EmptyBamIterator
    extends AbstractBamIterator {
        private EmptyBamIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new NoSuchElementException("next called on empty iterator");
        }
    }

    private abstract class AbstractBamIterator
    implements CloseableIterator<SAMRecord> {
        private boolean isClosed = false;

        private AbstractBamIterator() {
        }

        @Override
        public void close() {
            if (!this.isClosed) {
                if (BAMFileReader.this.mCurrentIterator != null && this != BAMFileReader.this.mCurrentIterator) {
                    throw new IllegalStateException("Attempt to close non-current iterator");
                }
                BAMFileReader.this.mCurrentIterator = null;
                this.isClosed = true;
            }
        }

        protected void assertOpen() {
            if (this.isClosed) {
                throw new AssertionError((Object)"Iterator has been closed");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }
    }
}

