/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BinaryCigarCodec;
import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BAMRecord
extends SAMRecord {
    private static final int READ_NAME_OFFSET = 0;
    private byte[] mRestOfBinaryData = null;
    private int mReadLength = 0;
    private boolean mReadLengthValid = true;
    private final short mReadNameLength;
    private boolean mReadNameLengthValid = true;
    private final int mCigarLength;
    private boolean mCigarLengthValid = true;
    private boolean mAttributesDecoded = false;
    private boolean mCigarDecoded = false;
    private boolean mBinaryDataStale;

    protected BAMRecord(SAMFileHeader sAMFileHeader, int n, int n2, short s, short s2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray) {
        super(sAMFileHeader);
        this.setReferenceIndex(n);
        this.setAlignmentStart(n2);
        this.mReadNameLength = s;
        this.setMappingQuality(s2);
        this.mCigarLength = n4;
        this.setFlags(n5);
        this.mReadLength = n6;
        this.setMateReferenceIndex(n7);
        this.setMateAlignmentStart(n8);
        this.setInferredInsertSize(n9);
        this.mRestOfBinaryData = byArray;
        super.setReadName(null);
        super.setCigarString(null);
        super.setReadBases(null);
        super.setBaseQualities(null);
        this.setIndexingBin(n3);
        this.mBinaryDataStale = false;
    }

    @Override
    protected void eagerDecode() {
        this.getReadName();
        this.getCigar();
        this.getReadBases();
        this.getBaseQualities();
        this.getBinaryAttributes();
        super.eagerDecode();
        this.mRestOfBinaryData = null;
    }

    @Override
    public byte[] getVariableBinaryRepresentation() {
        if (this.mBinaryDataStale) {
            return null;
        }
        return this.mRestOfBinaryData;
    }

    @Override
    public int getAttributesBinarySize() {
        if (this.mBinaryDataStale || this.mRestOfBinaryData == null) {
            return -1;
        }
        int n = this.readNameSize() + this.cigarSize() + this.basesSize() + this.qualsSize();
        return this.mRestOfBinaryData.length - n;
    }

    @Override
    public void setReadName(String string) {
        super.setReadName(string);
        this.mBinaryDataStale = true;
        this.mReadNameLengthValid = false;
    }

    @Override
    public void setCigar(Cigar cigar) {
        super.setCigar(cigar);
        this.mBinaryDataStale = true;
        this.mCigarLengthValid = false;
        this.mCigarDecoded = true;
    }

    @Override
    public void setCigarString(String string) {
        super.setCigarString(string);
        this.mBinaryDataStale = true;
        this.mCigarLengthValid = false;
        this.mCigarDecoded = true;
    }

    @Override
    public void setReadBases(byte[] byArray) {
        super.setReadBases(byArray);
        this.mBinaryDataStale = true;
        this.mReadLengthValid = false;
    }

    @Override
    public void setBaseQualities(byte[] byArray) {
        super.setBaseQualities(byArray);
        this.mBinaryDataStale = true;
    }

    @Override
    protected void setAttribute(short s, Object object, boolean bl) {
        this.getBinaryAttributes();
        super.setAttribute(s, object, bl);
        this.mBinaryDataStale = true;
    }

    @Override
    public void clearAttributes() {
        this.mAttributesDecoded = true;
        this.mBinaryDataStale = true;
        super.clearAttributes();
    }

    @Override
    public int getReadLength() {
        if (this.mReadLengthValid) {
            return this.mReadLength;
        }
        return super.getReadLength();
    }

    @Override
    public String getReadName() {
        String string = super.getReadName();
        if (this.mRestOfBinaryData != null && string == null) {
            string = this.decodeReadName();
            super.setReadName(string);
        }
        return string;
    }

    @Override
    public int getReadNameLength() {
        if (this.mReadNameLengthValid) {
            return this.mReadNameLength - 1;
        }
        return super.getReadNameLength();
    }

    @Override
    public Cigar getCigar() {
        if (this.mRestOfBinaryData != null && !this.mCigarDecoded) {
            int n = this.readNameSize();
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.mRestOfBinaryData, n, this.cigarSize());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            super.initializeCigar(BinaryCigarCodec.decode(byteBuffer));
            this.mCigarDecoded = true;
            if (null != this.getHeader() && this.getValidationStringency() != ValidationStringency.SILENT && !this.getReadUnmappedFlag()) {
                SAMUtils.processValidationErrors(this.validateCigar(-1L), -1L, this.getValidationStringency());
            }
        }
        return super.getCigar();
    }

    @Override
    public int getCigarLength() {
        if (this.mCigarLengthValid) {
            return this.mCigarLength;
        }
        return super.getCigarLength();
    }

    @Override
    public byte[] getReadBases() {
        byte[] byArray = super.getReadBases();
        if (this.mRestOfBinaryData != null && byArray == null) {
            byArray = this.decodeReadBases();
            super.setReadBases(byArray);
        }
        return byArray;
    }

    @Override
    public byte[] getBaseQualities() {
        byte[] byArray = super.getBaseQualities();
        if (this.mRestOfBinaryData != null && byArray == null) {
            byArray = this.decodeBaseQualities();
            super.setBaseQualities(byArray);
        }
        return byArray;
    }

    @Override
    public Object getAttribute(short s) {
        if (!this.mAttributesDecoded) {
            this.decodeAttributes();
        }
        return super.getAttribute(s);
    }

    @Override
    protected SAMBinaryTagAndValue getBinaryAttributes() {
        if (!this.mAttributesDecoded) {
            this.decodeAttributes();
        }
        return super.getBinaryAttributes();
    }

    private void decodeAttributes() {
        if (this.mAttributesDecoded) {
            return;
        }
        this.mAttributesDecoded = true;
        int n = this.readNameSize() + this.cigarSize() + this.basesSize() + this.qualsSize();
        int n2 = this.mRestOfBinaryData.length - n;
        SAMBinaryTagAndValue sAMBinaryTagAndValue = BinaryTagCodec.readTags(this.mRestOfBinaryData, n, n2, this.getValidationStringency());
        this.setAttributes(sAMBinaryTagAndValue);
    }

    private byte[] decodeBaseQualities() {
        if (this.mReadLength == 0) {
            return SAMRecord.NULL_QUALS;
        }
        int n = this.readNameSize() + this.cigarSize() + this.basesSize();
        byte[] byArray = new byte[this.qualsSize()];
        System.arraycopy(this.mRestOfBinaryData, n, byArray, 0, this.qualsSize());
        if (byArray.length > 0 && byArray[0] == -1) {
            return NULL_QUALS;
        }
        return byArray;
    }

    private String decodeReadName() {
        return StringUtil.bytesToString(this.mRestOfBinaryData, 0, this.mReadNameLength - 1);
    }

    private byte[] decodeReadBases() {
        if (this.mReadLength == 0) {
            return NULL_SEQUENCE;
        }
        int n = this.readNameSize() + this.cigarSize();
        return SAMUtils.compressedBasesToBytes(this.mReadLength, this.mRestOfBinaryData, n);
    }

    private int readNameSize() {
        return this.mReadNameLength;
    }

    private int cigarSize() {
        return this.mCigarLength * 4;
    }

    private int basesSize() {
        return (this.mReadLength + 1) / 2;
    }

    private int qualsSize() {
        return this.mReadLength;
    }
}

