/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import java.util.Arrays;
import java.util.List;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SamReader samReader) {
        if (samReader.indexing().hasBrowseableIndex()) {
            CachingBAMFileIndex cachingBAMFileIndex = (CachingBAMFileIndex)samReader.indexing().getBrowseableIndex();
            int n = cachingBAMFileIndex.getNumberOfReferences();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                BAMIndexContent bAMIndexContent = cachingBAMFileIndex.getQueryResults(i);
                for (Chunk chunk : bAMIndexContent.getAllChunks()) {
                    SAMRecordIterator sAMRecordIterator = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).iterator(new BAMFileSpan(chunk));
                    ++n2;
                    SAMRecord sAMRecord = null;
                    try {
                        sAMRecord = (SAMRecord)sAMRecordIterator.next();
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + sAMRecord + " in chunk " + chunk + " chunkCount=" + n2, exception);
                    }
                }
                LinearIndex linearIndex = bAMIndexContent.getLinearIndex();
                for (long l : linearIndex.getIndexEntries()) {
                    try {
                        if (l == 0L) continue;
                        SAMRecordIterator sAMRecordIterator = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                        SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
                        ++n3;
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + n3, exception);
                    }
                }
            }
            return n2;
        }
        return 0;
    }

    public static int lessExhaustivelyTestIndex(SamReader samReader) {
        if (samReader.indexing().hasBrowseableIndex()) {
            CachingBAMFileIndex cachingBAMFileIndex = (CachingBAMFileIndex)samReader.indexing().getBrowseableIndex();
            int n = cachingBAMFileIndex.getNumberOfReferences();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                BAMIndexContent bAMIndexContent = cachingBAMFileIndex.getQueryResults(i);
                List<Chunk> list = bAMIndexContent.getAllChunks();
                int n4 = list.size();
                Object object = Arrays.asList(0, n4 - 1).iterator();
                while (object.hasNext()) {
                    int n5 = object.next();
                    ++n2;
                    Chunk chunk = list.get(n5);
                    SAMRecordIterator sAMRecordIterator = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).iterator(new BAMFileSpan(chunk));
                    try {
                        SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception querying chunk " + n5 + " from reference index " + i, exception);
                    }
                }
                object = bAMIndexContent.getLinearIndex().getIndexEntries();
                for (int n6 : Arrays.asList(0, ((Object)object).length - 1)) {
                    ++n3;
                    Object object2 = object[n6];
                    try {
                        if (object2 == 0L) continue;
                        SAMRecordIterator sAMRecordIterator = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).iterator(new BAMFileSpan(new Chunk((long)object2, (long)(object2 + 1L))));
                        SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + (long)object2 + " indexCount=" + n3, exception);
                    }
                }
            }
            return n2;
        }
        return 0;
    }

    public static enum IndexValidationStringency {
        EXHAUSTIVE,
        LESS_EXHAUSTIVE,
        NONE;

    }
}

