/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.StringLineReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SAMFileHeader
extends AbstractSAMHeaderRecord {
    public static final String VERSION_TAG = "VN";
    public static final String SORT_ORDER_TAG = "SO";
    public static final String GROUP_ORDER_TAG = "GO";
    public static final String CURRENT_VERSION = "1.5";
    public static final Set<String> ACCEPTABLE_VERSIONS = new HashSet<String>(Arrays.asList("1.0", "1.3", "1.4", "1.5"));
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("VN", "SO", "GO"));
    private List<SAMReadGroupRecord> mReadGroups = new ArrayList<SAMReadGroupRecord>();
    private List<SAMProgramRecord> mProgramRecords = new ArrayList<SAMProgramRecord>();
    private final Map<String, SAMReadGroupRecord> mReadGroupMap = new HashMap<String, SAMReadGroupRecord>();
    private final Map<String, SAMProgramRecord> mProgramRecordMap = new HashMap<String, SAMProgramRecord>();
    private SAMSequenceDictionary mSequenceDictionary = new SAMSequenceDictionary();
    private final List<String> mComments = new ArrayList<String>();
    private String textHeader;
    private final List<SAMValidationError> mValidationErrors = new ArrayList<SAMValidationError>();

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    public SAMFileHeader() {
        this.setAttribute(VERSION_TAG, CURRENT_VERSION);
    }

    public String getVersion() {
        return this.getAttribute(VERSION_TAG);
    }

    public String getCreator() {
        return this.getAttribute("CR");
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.mSequenceDictionary;
    }

    public List<SAMReadGroupRecord> getReadGroups() {
        return Collections.unmodifiableList(this.mReadGroups);
    }

    public SAMSequenceRecord getSequence(String string) {
        return this.mSequenceDictionary.getSequence(string);
    }

    public SAMReadGroupRecord getReadGroup(String string) {
        return this.mReadGroupMap.get(string);
    }

    public void setSequenceDictionary(SAMSequenceDictionary sAMSequenceDictionary) {
        this.mSequenceDictionary = sAMSequenceDictionary;
    }

    public void addSequence(SAMSequenceRecord sAMSequenceRecord) {
        this.mSequenceDictionary.addSequence(sAMSequenceRecord);
    }

    public SAMSequenceRecord getSequence(int n) {
        return this.mSequenceDictionary.getSequence(n);
    }

    public int getSequenceIndex(String string) {
        return this.mSequenceDictionary.getSequenceIndex(string);
    }

    public void setReadGroups(List<SAMReadGroupRecord> list) {
        this.mReadGroups = list;
        this.mReadGroupMap.clear();
        for (SAMReadGroupRecord sAMReadGroupRecord : list) {
            this.mReadGroupMap.put(sAMReadGroupRecord.getReadGroupId(), sAMReadGroupRecord);
        }
    }

    public void addReadGroup(SAMReadGroupRecord sAMReadGroupRecord) {
        if (this.mReadGroupMap.containsKey(sAMReadGroupRecord.getReadGroupId())) {
            throw new IllegalArgumentException("Read group with group id " + sAMReadGroupRecord.getReadGroupId() + " already exists in SAMFileHeader!");
        }
        this.mReadGroups.add(sAMReadGroupRecord);
        this.mReadGroupMap.put(sAMReadGroupRecord.getReadGroupId(), sAMReadGroupRecord);
    }

    public List<SAMProgramRecord> getProgramRecords() {
        return Collections.unmodifiableList(this.mProgramRecords);
    }

    public void addProgramRecord(SAMProgramRecord sAMProgramRecord) {
        if (this.mProgramRecordMap.containsKey(sAMProgramRecord.getProgramGroupId())) {
            throw new IllegalArgumentException("Program record with group id " + sAMProgramRecord.getProgramGroupId() + " already exists in SAMFileHeader!");
        }
        this.mProgramRecords.add(sAMProgramRecord);
        this.mProgramRecordMap.put(sAMProgramRecord.getProgramGroupId(), sAMProgramRecord);
    }

    public SAMProgramRecord getProgramRecord(String string) {
        return this.mProgramRecordMap.get(string);
    }

    public void setProgramRecords(List<SAMProgramRecord> list) {
        this.mProgramRecords = list;
        this.mProgramRecordMap.clear();
        for (SAMProgramRecord sAMProgramRecord : this.mProgramRecords) {
            this.mProgramRecordMap.put(sAMProgramRecord.getProgramGroupId(), sAMProgramRecord);
        }
    }

    public SAMProgramRecord createProgramRecord() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String string = Integer.toString(i);
            if (this.mProgramRecordMap.containsKey(string)) continue;
            SAMProgramRecord sAMProgramRecord = new SAMProgramRecord(string);
            this.addProgramRecord(sAMProgramRecord);
            return sAMProgramRecord;
        }
        throw new IllegalStateException("Surprising number of SAMProgramRecords");
    }

    public SortOrder getSortOrder() {
        String string = this.getAttribute(SORT_ORDER_TAG);
        if (string == null || string.equals("unknown")) {
            return SortOrder.unsorted;
        }
        return SortOrder.valueOf(string);
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.setAttribute(SORT_ORDER_TAG, sortOrder.name());
    }

    public GroupOrder getGroupOrder() {
        if (this.getAttribute(GROUP_ORDER_TAG) == null) {
            return GroupOrder.none;
        }
        return GroupOrder.valueOf(this.getAttribute(GROUP_ORDER_TAG));
    }

    public void setGroupOrder(GroupOrder groupOrder) {
        this.setAttribute(GROUP_ORDER_TAG, groupOrder.name());
    }

    public String getTextHeader() {
        return this.textHeader;
    }

    public void setTextHeader(String string) {
        this.textHeader = string;
    }

    public List<String> getComments() {
        return Collections.unmodifiableList(this.mComments);
    }

    public void addComment(String string) {
        if (!string.startsWith(SAMTextHeaderCodec.COMMENT_PREFIX)) {
            string = SAMTextHeaderCodec.COMMENT_PREFIX + string;
        }
        this.mComments.add(string);
    }

    public void setComments(Collection<String> collection) {
        this.mComments.clear();
        for (String string : collection) {
            this.addComment(string);
        }
    }

    public List<SAMValidationError> getValidationErrors() {
        return Collections.unmodifiableList(this.mValidationErrors);
    }

    public void addValidationError(SAMValidationError sAMValidationError) {
        this.mValidationErrors.add(sAMValidationError);
    }

    public void setValidationErrors(Collection<SAMValidationError> collection) {
        this.mValidationErrors.clear();
        this.mValidationErrors.addAll(collection);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SAMFileHeader sAMFileHeader = (SAMFileHeader)object;
        if (!this.attributesEqual(sAMFileHeader)) {
            return false;
        }
        if (this.mProgramRecords != null ? !this.mProgramRecords.equals(sAMFileHeader.mProgramRecords) : sAMFileHeader.mProgramRecords != null) {
            return false;
        }
        if (this.mReadGroups != null ? !this.mReadGroups.equals(sAMFileHeader.mReadGroups) : sAMFileHeader.mReadGroups != null) {
            return false;
        }
        return !(this.mSequenceDictionary != null ? !this.mSequenceDictionary.equals(sAMFileHeader.mSequenceDictionary) : sAMFileHeader.mSequenceDictionary != null);
    }

    public int hashCode() {
        int n = this.attributesHashCode();
        n = 31 * n + (this.mSequenceDictionary != null ? this.mSequenceDictionary.hashCode() : 0);
        n = 31 * n + (this.mReadGroups != null ? this.mReadGroups.hashCode() : 0);
        n = 31 * n + (this.mProgramRecords != null ? this.mProgramRecords.hashCode() : 0);
        return n;
    }

    public final SAMFileHeader clone() {
        SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
        sAMTextHeaderCodec.setValidationStringency(ValidationStringency.SILENT);
        StringWriter stringWriter = new StringWriter();
        sAMTextHeaderCodec.encode(stringWriter, this);
        return sAMTextHeaderCodec.decode(new StringLineReader(stringWriter.toString()), "SAMFileHeader.clone");
    }

    public static class PgIdGenerator {
        private int recordCounter;
        private final Set<String> idsThatAreAlreadyTaken = new HashSet<String>();

        public PgIdGenerator(SAMFileHeader sAMFileHeader) {
            for (SAMProgramRecord sAMProgramRecord : sAMFileHeader.getProgramRecords()) {
                this.idsThatAreAlreadyTaken.add(sAMProgramRecord.getProgramGroupId());
            }
            this.recordCounter = this.idsThatAreAlreadyTaken.size();
        }

        public String getNonCollidingId(String string) {
            String string2;
            if (!this.idsThatAreAlreadyTaken.contains(string)) {
                this.idsThatAreAlreadyTaken.add(string);
                ++this.recordCounter;
                return string;
            }
            while (this.idsThatAreAlreadyTaken.contains(string2 = string + "." + SamFileHeaderMerger.positiveFourDigitBase36Str(this.recordCounter++))) {
            }
            this.idsThatAreAlreadyTaken.add(string2);
            return string2;
        }
    }

    public static enum GroupOrder {
        none,
        query,
        reference;

    }

    public static enum SortOrder {
        unsorted(null),
        queryname(SAMRecordQueryNameComparator.class),
        coordinate(SAMRecordCoordinateComparator.class),
        duplicate(SAMRecordDuplicateComparator.class);

        private final Class<? extends SAMRecordComparator> comparator;

        private SortOrder(Class<? extends SAMRecordComparator> clazz) {
            this.comparator = clazz;
        }

        public Class<? extends SAMRecordComparator> getComparator() {
            return this.comparator;
        }

        public SAMRecordComparator getComparatorInstance() {
            if (this.comparator != null) {
                try {
                    Constructor<? extends SAMRecordComparator> constructor = this.comparator.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Could not instantiate a comparator for sort order: " + this.name(), exception);
                }
            }
            return null;
        }
    }
}

