/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMTag;
import java.io.Serializable;

public class SAMRecordQueryNameComparator
implements SAMRecordComparator,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        int n = this.fileOrderCompare(sAMRecord, sAMRecord2);
        if (n != 0) {
            return n;
        }
        boolean bl = sAMRecord.getReadPairedFlag();
        boolean bl2 = sAMRecord2.getReadPairedFlag();
        if (bl || bl2) {
            if (!bl) {
                return 1;
            }
            if (!bl2) {
                return -1;
            }
            if (sAMRecord.getFirstOfPairFlag() && sAMRecord2.getSecondOfPairFlag()) {
                return -1;
            }
            if (sAMRecord.getSecondOfPairFlag() && sAMRecord2.getFirstOfPairFlag()) {
                return 1;
            }
        }
        if (sAMRecord.getReadNegativeStrandFlag() != sAMRecord2.getReadNegativeStrandFlag()) {
            return sAMRecord.getReadNegativeStrandFlag() ? 1 : -1;
        }
        if (sAMRecord.getNotPrimaryAlignmentFlag() != sAMRecord2.getNotPrimaryAlignmentFlag()) {
            return sAMRecord2.getNotPrimaryAlignmentFlag() ? -1 : 1;
        }
        if (sAMRecord.getSupplementaryAlignmentFlag() != sAMRecord2.getSupplementaryAlignmentFlag()) {
            return sAMRecord2.getSupplementaryAlignmentFlag() ? -1 : 1;
        }
        Integer n2 = sAMRecord.getIntegerAttribute(SAMTag.HI.name());
        Integer n3 = sAMRecord2.getIntegerAttribute(SAMTag.HI.name());
        if (n2 != null) {
            if (n3 == null) {
                return 1;
            }
            n = n2.compareTo(n3);
            if (n != 0) {
                return n;
            }
        } else if (n3 != null) {
            return -1;
        }
        return 0;
    }

    @Override
    public int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return SAMRecordQueryNameComparator.compareReadNames(sAMRecord.getReadName(), sAMRecord2.getReadName());
    }

    public static int compareReadNames(String string, String string2) {
        return string.compareTo(string2);
    }
}

