/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMHeaderRecordComparator;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordUtil;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CigarUtil;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class SAMUtils {
    private static final byte COMPRESSED_EQUAL_LOW = 0;
    private static final byte COMPRESSED_A_LOW = 1;
    private static final byte COMPRESSED_C_LOW = 2;
    private static final byte COMPRESSED_M_LOW = 3;
    private static final byte COMPRESSED_G_LOW = 4;
    private static final byte COMPRESSED_R_LOW = 5;
    private static final byte COMPRESSED_S_LOW = 6;
    private static final byte COMPRESSED_V_LOW = 7;
    private static final byte COMPRESSED_T_LOW = 8;
    private static final byte COMPRESSED_W_LOW = 9;
    private static final byte COMPRESSED_Y_LOW = 10;
    private static final byte COMPRESSED_H_LOW = 11;
    private static final byte COMPRESSED_K_LOW = 12;
    private static final byte COMPRESSED_D_LOW = 13;
    private static final byte COMPRESSED_B_LOW = 14;
    private static final byte COMPRESSED_N_LOW = 15;
    private static final byte COMPRESSED_EQUAL_HIGH = 0;
    private static final byte COMPRESSED_A_HIGH = 16;
    private static final byte COMPRESSED_C_HIGH = 32;
    private static final byte COMPRESSED_G_HIGH = 64;
    private static final byte COMPRESSED_T_HIGH = -128;
    private static final byte COMPRESSED_N_HIGH = -16;
    private static final byte COMPRESSED_M_HIGH = 48;
    private static final byte COMPRESSED_R_HIGH = 80;
    private static final byte COMPRESSED_S_HIGH = 96;
    private static final byte COMPRESSED_V_HIGH = 112;
    private static final byte COMPRESSED_W_HIGH = -112;
    private static final byte COMPRESSED_Y_HIGH = -96;
    private static final byte COMPRESSED_H_HIGH = -80;
    private static final byte COMPRESSED_K_HIGH = -64;
    private static final byte COMPRESSED_D_HIGH = -48;
    private static final byte COMPRESSED_B_HIGH = -32;
    private static final byte[] COMPRESSED_LOOKUP_TABLE = new byte[]{61, 65, 67, 77, 71, 82, 83, 86, 84, 87, 89, 72, 75, 68, 66, 78};
    public static final int MAX_PHRED_SCORE = 93;
    private static final SAMHeaderRecordComparator<SAMReadGroupRecord> HEADER_RECORD_COMPARATOR = new SAMHeaderRecordComparator("PU", "LB", "DT", "SM", "CN", "PL", "DS", "ID");

    static byte[] bytesToCompressedBases(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[(byArray.length + 1) / 2];
        for (n = 1; n < byArray.length; n += 2) {
            byArray2[n / 2] = (byte)(SAMUtils.charToCompressedBaseHigh(byArray[n - 1]) | SAMUtils.charToCompressedBaseLow(byArray[n]));
        }
        if (n == byArray.length) {
            byArray2[n / 2] = SAMUtils.charToCompressedBaseHigh((char)byArray[n - 1]);
        }
        return byArray2;
    }

    public static byte[] compressedBasesToBytes(int n, byte[] byArray, int n2) {
        int n3;
        byte[] byArray2 = new byte[n];
        for (n3 = 1; n3 < n; n3 += 2) {
            int n4 = n3 / 2 + n2;
            byArray2[n3 - 1] = SAMUtils.compressedBaseToByteHigh(byArray[n4]);
            byArray2[n3] = SAMUtils.compressedBaseToByteLow(byArray[n4]);
        }
        if (n3 == n) {
            byArray2[n3 - 1] = SAMUtils.compressedBaseToByteHigh(byArray[n3 / 2 + n2]);
        }
        return byArray2;
    }

    private static byte charToCompressedBaseLow(int n) {
        switch (n) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 71: 
            case 103: {
                return 4;
            }
            case 84: 
            case 116: {
                return 8;
            }
            case 46: 
            case 78: 
            case 110: {
                return 15;
            }
            case 77: 
            case 109: {
                return 3;
            }
            case 82: 
            case 114: {
                return 5;
            }
            case 83: 
            case 115: {
                return 6;
            }
            case 86: 
            case 118: {
                return 7;
            }
            case 87: 
            case 119: {
                return 9;
            }
            case 89: 
            case 121: {
                return 10;
            }
            case 72: 
            case 104: {
                return 11;
            }
            case 75: 
            case 107: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 66: 
            case 98: {
                return 14;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + n);
    }

    private static byte charToCompressedBaseHigh(int n) {
        switch (n) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 16;
            }
            case 67: 
            case 99: {
                return 32;
            }
            case 71: 
            case 103: {
                return 64;
            }
            case 84: 
            case 116: {
                return -128;
            }
            case 46: 
            case 78: 
            case 110: {
                return -16;
            }
            case 77: 
            case 109: {
                return 48;
            }
            case 82: 
            case 114: {
                return 80;
            }
            case 83: 
            case 115: {
                return 96;
            }
            case 86: 
            case 118: {
                return 112;
            }
            case 87: 
            case 119: {
                return -112;
            }
            case 89: 
            case 121: {
                return -96;
            }
            case 72: 
            case 104: {
                return -80;
            }
            case 75: 
            case 107: {
                return -64;
            }
            case 68: 
            case 100: {
                return -48;
            }
            case 66: 
            case 98: {
                return -32;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + n);
    }

    private static byte compressedBaseToByte(byte by) {
        try {
            return COMPRESSED_LOOKUP_TABLE[by];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + by);
        }
    }

    private static byte compressedBaseToByteLow(int n) {
        return SAMUtils.compressedBaseToByte((byte)(n & 0xF));
    }

    private static byte compressedBaseToByteHigh(int n) {
        return SAMUtils.compressedBaseToByte((byte)(n >> 4 & 0xF));
    }

    static void normalizeBases(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = StringUtil.toUpperCase(byArray[i]);
            if (byArray[i] != 46) continue;
            byArray[i] = 78;
        }
    }

    public static String phredToFastq(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return SAMUtils.phredToFastq(byArray, 0, byArray.length);
    }

    public static String phredToFastq(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = SAMUtils.phredToFastq(byArray[n + i] & 0xFF);
        }
        return new String(cArray);
    }

    public static char phredToFastq(int n) {
        if (n < 0 || n > 93) {
            throw new IllegalArgumentException("Cannot encode phred score: " + n);
        }
        return (char)(33 + n);
    }

    public static byte[] fastqToPhred(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)SAMUtils.fastqToPhred(string.charAt(i));
        }
        return byArray;
    }

    public static void fastqToPhred(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)SAMUtils.fastqToPhred((char)(byArray[i] & 0xFF));
        }
    }

    public static int fastqToPhred(char c) {
        if (c < '!' || c > '~') {
            throw new IllegalArgumentException("Invalid fastq character: " + c);
        }
        return c - 33;
    }

    static int reg2bin(int n, int n2) {
        return GenomicIndexUtil.reg2bin(n, n2);
    }

    public static void processValidationErrors(List<SAMValidationError> list, long l, ValidationStringency validationStringency) {
        if (list != null && !list.isEmpty()) {
            for (SAMValidationError sAMValidationError : list) {
                sAMValidationError.setRecordNumber(l);
            }
            if (validationStringency == ValidationStringency.STRICT) {
                throw new SAMFormatException("SAM validation error: " + list.get(0));
            }
            if (validationStringency == ValidationStringency.LENIENT) {
                for (SAMValidationError sAMValidationError : list) {
                    System.err.println("Ignoring SAM validation error: " + sAMValidationError);
                }
            }
        }
    }

    public static void processValidationError(SAMValidationError sAMValidationError, ValidationStringency validationStringency) {
        if (validationStringency == ValidationStringency.STRICT) {
            throw new SAMFormatException("SAM validation error: " + sAMValidationError);
        }
        if (validationStringency == ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error: " + sAMValidationError);
        }
    }

    public static String calculateReadGroupRecordChecksum(File file, File file2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("No MD5 algorithm was available in a Java JDK? Unheard-of!");
        }
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(file2).open(file);
        ArrayList<SAMReadGroupRecord> arrayList = new ArrayList<SAMReadGroupRecord>(samReader.getFileHeader().getReadGroups());
        Collections.sort(arrayList, HEADER_RECORD_COMPARATOR);
        for (SAMReadGroupRecord sAMReadGroupRecord : arrayList) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : sAMReadGroupRecord.getAttributes()) {
                treeMap.put(entry.getKey(), entry.getValue());
            }
            try {
                for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                    if (entry.getKey().equals("ID")) continue;
                    messageDigest.update(entry.getKey().getBytes("UTF-8"));
                    messageDigest.update(entry.getValue().getBytes("UTF-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("No UTF-8!? WTH?");
            }
        }
        StringBuilder stringBuilder = new StringBuilder(new BigInteger(1, messageDigest.digest()).toString(16));
        while (stringBuilder.length() < 32) {
            stringBuilder.insert(0, "0");
        }
        CloserUtil.close(samReader);
        return stringBuilder.toString();
    }

    public static void chainSAMProgramRecord(SAMFileHeader sAMFileHeader, SAMProgramRecord sAMProgramRecord) {
        List<SAMProgramRecord> list = sAMFileHeader.getProgramRecords();
        if (!list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SAMProgramRecord sAMProgramRecord2 : list) {
                if (sAMProgramRecord2.getPreviousProgramGroupId() == null) continue;
                arrayList.add(sAMProgramRecord2.getPreviousProgramGroupId());
            }
            for (SAMProgramRecord sAMProgramRecord2 : list) {
                if (sAMProgramRecord2.getProgramGroupId().equals(sAMProgramRecord.getProgramGroupId()) || arrayList.contains(sAMProgramRecord2.getProgramGroupId())) continue;
                sAMProgramRecord.setPreviousProgramGroupId(sAMProgramRecord2.getProgramGroupId());
                break;
            }
        }
    }

    public static void makeReadUnmapped(SAMRecord sAMRecord) {
        if (sAMRecord.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement(sAMRecord);
            sAMRecord.setReadNegativeStrandFlag(false);
        }
        sAMRecord.setDuplicateReadFlag(false);
        sAMRecord.setReferenceIndex(-1);
        sAMRecord.setAlignmentStart(0);
        sAMRecord.setCigarString("*");
        sAMRecord.setMappingQuality(0);
        sAMRecord.setInferredInsertSize(0);
        sAMRecord.setNotPrimaryAlignmentFlag(false);
        sAMRecord.setSupplementaryAlignmentFlag(false);
        sAMRecord.setProperPairFlag(false);
        sAMRecord.setReadUnmappedFlag(true);
    }

    public static void makeReadUnmappedWithOriginalTags(SAMRecord sAMRecord) {
        if (!SAMUtils.hasOriginalMappingInformation(sAMRecord)) {
            sAMRecord.setAttribute(SAMTag.OP.name(), (Object)sAMRecord.getAlignmentStart());
            sAMRecord.setAttribute(SAMTag.OC.name(), (Object)sAMRecord.getCigarString());
            sAMRecord.setAttribute(SAMTag.OF.name(), (Object)sAMRecord.getFlags());
            sAMRecord.setAttribute(SAMTag.OR.name(), (Object)sAMRecord.getReferenceName());
        }
        SAMUtils.makeReadUnmapped(sAMRecord);
    }

    public static boolean hasOriginalMappingInformation(SAMRecord sAMRecord) {
        return sAMRecord.getAttribute(SAMTag.OP.name()) != null || sAMRecord.getAttribute(SAMTag.OC.name()) != null || sAMRecord.getAttribute(SAMTag.OF.name()) != null || sAMRecord.getAttribute(SAMTag.OR.name()) != null;
    }

    public static boolean cigarMapsNoBasesToRef(Cigar cigar) {
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            if (!cigarElement.getOperator().consumesReadBases() || !cigarElement.getOperator().consumesReferenceBases()) continue;
            return false;
        }
        return true;
    }

    public static boolean recordMapsEntirelyBeyondEndOfReference(SAMRecord sAMRecord) {
        if (sAMRecord.getHeader() == null) {
            throw new SAMException("A non-null SAMHeader is required to resolve the mapping position: " + sAMRecord.getReadName());
        }
        return sAMRecord.getHeader().getSequence(sAMRecord.getReferenceIndex()).getSequenceLength() < sAMRecord.getAlignmentStart();
    }

    public static int compareMapqs(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n == 0) {
            return -1;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n == 255) {
            return -1;
        }
        if (n2 == 255) {
            return 1;
        }
        return n - n2;
    }

    public static int combineMapqs(int n, int n2) {
        n = n == 255 ? 1 : (n *= 100);
        n2 = n2 == 255 ? 1 : (n2 *= 100);
        return n + n2;
    }

    public static long findVirtualOffsetOfFirstRecordInBam(File file) {
        try {
            return BAMFileReader.findVirtualOffsetOfFirstRecord(file);
        }
        catch (IOException iOException) {
            throw new RuntimeEOFException(iOException);
        }
    }

    public static List<AlignmentBlock> getAlignmentBlocks(Cigar cigar, int n, String string) {
        if (cigar == null) {
            return Collections.emptyList();
        }
        ArrayList<AlignmentBlock> arrayList = new ArrayList<AlignmentBlock>();
        int n2 = 1;
        int n3 = n;
        block9: for (CigarElement cigarElement : cigar.getCigarElements()) {
            switch (cigarElement.getOperator()) {
                case H: {
                    continue block9;
                }
                case P: {
                    continue block9;
                }
                case S: {
                    n2 += cigarElement.getLength();
                    continue block9;
                }
                case N: {
                    n3 += cigarElement.getLength();
                    continue block9;
                }
                case D: {
                    n3 += cigarElement.getLength();
                    continue block9;
                }
                case I: {
                    n2 += cigarElement.getLength();
                    continue block9;
                }
                case M: 
                case EQ: 
                case X: {
                    int n4 = cigarElement.getLength();
                    arrayList.add(new AlignmentBlock(n2, n3, n4));
                    n2 += n4;
                    n3 += n4;
                    continue block9;
                }
            }
            throw new IllegalStateException("Case statement didn't deal with " + string + " op: " + (Object)((Object)cigarElement.getOperator()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static int getUnclippedStart(int n, Cigar cigar) {
        CigarElement cigarElement;
        CigarOperator cigarOperator;
        int n2 = n;
        Iterator<CigarElement> iterator = cigar.getCigarElements().iterator();
        while (iterator.hasNext() && ((cigarOperator = (cigarElement = iterator.next()).getOperator()) == CigarOperator.SOFT_CLIP || cigarOperator == CigarOperator.HARD_CLIP)) {
            n2 -= cigarElement.getLength();
        }
        return n2;
    }

    public static int getUnclippedEnd(int n, Cigar cigar) {
        CigarElement cigarElement;
        CigarOperator cigarOperator;
        int n2 = n;
        List<CigarElement> list = cigar.getCigarElements();
        for (int i = list.size() - 1; i >= 0 && ((cigarOperator = (cigarElement = list.get(i)).getOperator()) == CigarOperator.SOFT_CLIP || cigarOperator == CigarOperator.HARD_CLIP); --i) {
            n2 += cigarElement.getLength();
        }
        return n2;
    }

    public static String getMateCigarString(SAMRecord sAMRecord) {
        return sAMRecord.getStringAttribute(SAMTag.MC.name());
    }

    public static Cigar getMateCigar(SAMRecord sAMRecord, boolean bl) {
        String string = SAMUtils.getMateCigarString(sAMRecord);
        Cigar cigar = null;
        if (string != null) {
            cigar = TextCigarCodec.decode(string);
            if (bl && sAMRecord.getValidationStringency() != ValidationStringency.SILENT) {
                List<AlignmentBlock> list = SAMUtils.getAlignmentBlocks(cigar, sAMRecord.getMateAlignmentStart(), "mate cigar");
                SAMUtils.processValidationErrors(SAMUtils.validateCigar(sAMRecord, cigar, sAMRecord.getMateReferenceIndex(), list, -1L, "Mate CIGAR"), -1L, sAMRecord.getValidationStringency());
            }
        }
        return cigar;
    }

    public static Cigar getMateCigar(SAMRecord sAMRecord) {
        return SAMUtils.getMateCigar(sAMRecord, false);
    }

    public static int getMateCigarLength(SAMRecord sAMRecord) {
        Cigar cigar = SAMUtils.getMateCigar(sAMRecord);
        return cigar != null ? cigar.numCigarElements() : 0;
    }

    public static int getMateAlignmentEnd(SAMRecord sAMRecord) {
        if (sAMRecord.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateAlignmentEnd called on an unmapped mate.");
        }
        Cigar cigar = SAMUtils.getMateCigar(sAMRecord);
        if (cigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found.");
        }
        return CoordMath.getEnd(sAMRecord.getMateAlignmentStart(), cigar.getReferenceLength());
    }

    public static int getMateUnclippedStart(SAMRecord sAMRecord) {
        if (sAMRecord.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateUnclippedStart called on an unmapped mate.");
        }
        Cigar cigar = SAMUtils.getMateCigar(sAMRecord);
        if (cigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found.");
        }
        return SAMUtils.getUnclippedStart(sAMRecord.getMateAlignmentStart(), cigar);
    }

    public static int getMateUnclippedEnd(SAMRecord sAMRecord) {
        if (sAMRecord.getMateUnmappedFlag()) {
            throw new RuntimeException("getMateUnclippedEnd called on an unmapped mate.");
        }
        Cigar cigar = SAMUtils.getMateCigar(sAMRecord);
        if (cigar == null) {
            throw new SAMException("Mate CIGAR (Tag MC) not found.");
        }
        return SAMUtils.getUnclippedEnd(SAMUtils.getMateAlignmentEnd(sAMRecord), cigar);
    }

    public static List<AlignmentBlock> getMateAlignmentBlocks(SAMRecord sAMRecord) {
        return SAMUtils.getAlignmentBlocks(SAMUtils.getMateCigar(sAMRecord), sAMRecord.getMateAlignmentStart(), "mate cigar");
    }

    public static List<SAMValidationError> validateCigar(SAMRecord sAMRecord, Cigar cigar, Integer n, List<AlignmentBlock> list, long l, String string) {
        List<SAMValidationError> list2 = cigar.isValid(sAMRecord.getReadName(), l);
        if (n != -1) {
            SAMFileHeader sAMFileHeader = sAMRecord.getHeader();
            if (null == sAMFileHeader) {
                if (list2 == null) {
                    list2 = new ArrayList<SAMValidationError>();
                }
                list2.add(new SAMValidationError(SAMValidationError.Type.MISSING_HEADER, string + " A non-null SAMHeader is required to validate cigar elements for: ", sAMRecord.getReadName(), l));
            } else {
                SAMSequenceRecord sAMSequenceRecord = sAMFileHeader.getSequence(n);
                int n2 = sAMSequenceRecord.getSequenceLength();
                for (AlignmentBlock alignmentBlock : list) {
                    if (alignmentBlock.getReferenceStart() + alignmentBlock.getLength() - 1 <= n2) continue;
                    if (list2 == null) {
                        list2 = new ArrayList<SAMValidationError>();
                    }
                    list2.add(new SAMValidationError(SAMValidationError.Type.CIGAR_MAPS_OFF_REFERENCE, string + " M operator maps off end of reference", sAMRecord.getReadName(), l));
                    break;
                }
            }
        }
        return list2;
    }

    public static List<SAMValidationError> validateMateCigar(SAMRecord sAMRecord, long l) {
        List<SAMValidationError> list = null;
        if (sAMRecord.getValidationStringency() != ValidationStringency.SILENT) {
            if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag()) {
                if (SAMUtils.getMateCigarString(sAMRecord) != null) {
                    list = SAMUtils.validateCigar(sAMRecord, SAMUtils.getMateCigar(sAMRecord), sAMRecord.getMateReferenceIndex(), SAMUtils.getMateAlignmentBlocks(sAMRecord), l, "Mate CIGAR");
                }
            } else if (SAMUtils.getMateCigarString(sAMRecord) != null) {
                list = new ArrayList<SAMValidationError>();
                if (!sAMRecord.getReadPairedFlag()) {
                    list.add(new SAMValidationError(SAMValidationError.Type.MATE_CIGAR_STRING_INVALID_PRESENCE, "Mate CIGAR String (MC Attribute) present for a read that is not paired", sAMRecord.getReadName(), l));
                } else {
                    list.add(new SAMValidationError(SAMValidationError.Type.MATE_CIGAR_STRING_INVALID_PRESENCE, "Mate CIGAR String (MC Attribute) present for a read whose mate is unmapped", sAMRecord.getReadName(), l));
                }
            }
        }
        return list;
    }

    public static boolean hasMateCigar(SAMRecord sAMRecord) {
        return sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag() && null != SAMUtils.getMateCigarString(sAMRecord);
    }

    public static String getCanonicalRecordName(SAMRecord sAMRecord) {
        String string = sAMRecord.getStringAttribute(ReservedTagConstants.READ_GROUP_ID);
        string = null == string ? sAMRecord.getReadName() : string + ":" + sAMRecord.getReadName();
        return string;
    }

    public static int getNumOverlappingAlignedBasesToClip(SAMRecord sAMRecord) {
        if (!sAMRecord.getReadPairedFlag() || sAMRecord.getReadUnmappedFlag() || sAMRecord.getMateUnmappedFlag()) {
            return 0;
        }
        if (sAMRecord.getMateAlignmentStart() < sAMRecord.getAlignmentStart()) {
            return 0;
        }
        if (sAMRecord.getMateAlignmentStart() == sAMRecord.getAlignmentStart() && sAMRecord.getFirstOfPairFlag()) {
            return 0;
        }
        int n = 0;
        int n2 = sAMRecord.getMateAlignmentStart();
        Cigar cigar = sAMRecord.getCigar();
        int n3 = sAMRecord.getAlignmentStart();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            int n4;
            CigarOperator cigarOperator = cigarElement.getOperator();
            int n5 = n4 = cigarOperator.consumesReferenceBases() ? cigarElement.getLength() : 0;
            if (n2 <= n3 + n4 - 1) {
                if (cigarOperator == CigarOperator.MATCH_OR_MISMATCH) {
                    n = n2 < n3 ? (n += n4) : (n += n3 + n4 - n2);
                } else if (cigarOperator != CigarOperator.SOFT_CLIP && cigarOperator != CigarOperator.HARD_CLIP && cigarOperator != CigarOperator.PADDING && cigarOperator != CigarOperator.SKIPPED_REGION) {
                    n += cigarOperator.consumesReadBases() ? cigarElement.getLength() : 0;
                }
            }
            n3 += n4;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public static SAMRecord clipOverlappingAlignedBases(SAMRecord sAMRecord, boolean bl) {
        return SAMUtils.clipOverlappingAlignedBases(sAMRecord, SAMUtils.getNumOverlappingAlignedBasesToClip(sAMRecord), bl);
    }

    public static SAMRecord clipOverlappingAlignedBases(SAMRecord sAMRecord, int n, boolean bl) {
        if (n <= 0 || sAMRecord.getReadUnmappedFlag() || sAMRecord.getMateUnmappedFlag()) {
            return sAMRecord;
        }
        try {
            SAMRecord sAMRecord2;
            SAMRecord sAMRecord3 = sAMRecord2 = bl ? (SAMRecord)sAMRecord.clone() : sAMRecord;
            if (sAMRecord2.getMateAlignmentStart() <= sAMRecord2.getAlignmentStart()) {
                sAMRecord2.setReadUnmappedFlag(true);
                return sAMRecord2;
            }
            int n2 = sAMRecord2.getReadLength() - n + 1;
            CigarElement cigarElement = sAMRecord2.getCigar().getCigarElement(sAMRecord2.getCigarLength() - 1);
            if (CigarOperator.SOFT_CLIP == cigarElement.getOperator()) {
                n2 -= cigarElement.getLength();
            }
            sAMRecord2.setCigar(new Cigar(CigarUtil.softClipEndOfRead(n2, sAMRecord2.getCigar().getCigarElements())));
            return sAMRecord2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SAMException(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
    }

    public static boolean isValidUnsignedIntegerAttribute(long l) {
        return l >= 0L && l <= 0xFFFFFFFFL;
    }
}

