/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

public class SQTagUtil {
    private static final int COMPLEMENT_MASK = 3;
    private static final int QUALITY_MASK = 63;
    public static final byte MAX_QUALITY = 63;
    private static final int BASE_INDEX_SHIFT = 6;

    public static byte sqScaledProbabilityRatio(double d, double d2) {
        if (d >= 1.0 || d2 <= 0.0 || d2 > d) {
            throw new IllegalArgumentException("Likelihoods out of range.  second best: " + d + "; third best: " + d2);
        }
        return (byte)Math.min(Math.round(-10.0 * Math.log10(d2 / d)), 63L);
    }

    public static byte baseAndProbDiffToSqValue(SQBase sQBase, byte by) {
        return SQTagUtil.baseAndProbDiffToSqValue(sQBase.ordinal(), by);
    }

    public static byte baseAndProbDiffToSqValue(int n, byte by) {
        return (byte)(n << 6 | Math.min(by, 63));
    }

    public static byte sqValueToProbRatio(byte by) {
        return (byte)(by & 0x3F);
    }

    public static SQBase sqValueToBase(byte by) {
        return SQBase.values()[SQTagUtil.sqValueToBaseOrdinal(by)];
    }

    public static int sqValueToBaseOrdinal(byte by) {
        return (by & 0xFF) >>> 6;
    }

    public static void reverseComplementSqArray(byte[] byArray) {
        int n = byArray.length - 1;
        int n2 = 0;
        for (int i = n; n2 < i; ++n2, --i) {
            byte by = SQTagUtil.complementSqValue(byArray[n2]);
            byArray[n2] = SQTagUtil.complementSqValue(byArray[i]);
            byArray[i] = by;
        }
        if (byArray.length % 2 == 1) {
            byArray[n2] = SQTagUtil.complementSqValue(byArray[n2]);
        }
    }

    private static byte complementSqValue(byte by) {
        byte by2 = SQTagUtil.sqValueToProbRatio(by);
        int n = SQTagUtil.sqValueToBaseOrdinal(by);
        int n2 = 3 & ~n;
        return SQTagUtil.baseAndProbDiffToSqValue(n2, by2);
    }

    public static enum SQBase {
        SQ_A(Character.valueOf('A')),
        SQ_C(Character.valueOf('C')),
        SQ_G(Character.valueOf('G')),
        SQ_T(Character.valueOf('T'));

        private final Character base;

        private SQBase(Character c) {
            this.base = c;
        }

        public Character getBase() {
            return this.base;
        }
    }
}

