/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import gov.nih.nlm.ncbi.ngs.NGS;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SRAIndex;
import htsjdk.samtools.SRAIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.sra.ReferenceCache;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Log;
import java.util.List;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.ReadGroupIterator;

public class SRAFileReader
extends SamReader.ReaderImplementation
implements SamReader.Indexing {
    private static final Log log = Log.getInstance(SRAFileReader.class);
    private SRAAccession acc;
    private SAMFileHeader virtualHeader;
    private ReadCollection run;
    private ValidationStringency validationStringency;
    private SRAIterator.RecordRangeInfo recordRangeInfo;
    private SRAIndex index;
    private ReferenceCache cachedReferences;

    public SRAFileReader(SRAAccession sRAAccession) {
        this.acc = sRAAccession;
        if (!sRAAccession.isValid()) {
            throw new IllegalArgumentException("Invalid SRA accession was passed to SRA reader: " + sRAAccession);
        }
        try {
            this.run = NGS.openReadCollection((String)sRAAccession.toString());
            this.virtualHeader = this.loadSamHeader();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.cachedReferences = new ReferenceCache(this.run, this.virtualHeader);
        this.recordRangeInfo = SRAIterator.getRecordsRangeInfo(this.run);
        this.index = new SRAIndex(this.virtualHeader, this.recordRangeInfo);
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.SRA_TYPE;
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public BAMIndex getIndex() {
        return this.index;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.virtualHeader;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator() {
        return this.getIterator(this.getFilePointerSpanningReads());
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan sAMFileSpan) {
        if (this.run == null) {
            throw new RuntimeException("Cannot create iterator - SRA run is uninitialized");
        }
        if (this.virtualHeader == null) {
            throw new RuntimeException("Cannot create iterator - SAM file header is uninitialized");
        }
        List<Chunk> list = ((BAMFileSpan)sAMFileSpan).getChunks();
        SRAIterator sRAIterator = new SRAIterator(this.acc, this.run, this.virtualHeader, this.cachedReferences, this.recordRangeInfo, list);
        if (this.validationStringency != null) {
            sRAIterator.setValidationStringency(this.validationStringency);
        }
        return sRAIterator;
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        if (this.recordRangeInfo.getTotalRecordRangeLength() <= 0L) {
            throw new RuntimeException("Cannot create file span - SRA file is empty");
        }
        return new BAMFileSpan(new Chunk(0L, this.recordRangeInfo.getTotalRecordRangeLength()));
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] queryIntervalArray, boolean bl) {
        BAMFileSpan bAMFileSpan = new BAMFileSpan();
        BrowseableBAMIndex browseableBAMIndex = this.getBrowseableIndex();
        for (QueryInterval queryInterval : queryIntervalArray) {
            BAMFileSpan bAMFileSpan2 = !bl ? browseableBAMIndex.getSpanOverlapping(queryInterval.referenceIndex, queryInterval.start, queryInterval.end) : this.getSpanContained(queryInterval.referenceIndex, queryInterval.start, queryInterval.end);
            bAMFileSpan.add(bAMFileSpan2);
        }
        return this.getIterator(bAMFileSpan);
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String string, int n) {
        int n2 = this.virtualHeader.getSequenceIndex(string);
        if (n2 == -1) {
            throw new IllegalArgumentException("Unknown sequence '" + string + "' was passed to SRAFileReader");
        }
        return this.getIterator(this.getSpanContained(n2, n, -1L));
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        if (this.recordRangeInfo.getTotalRecordRangeLength() <= 0L) {
            throw new RuntimeException("Cannot create file span - SRA file is empty");
        }
        BAMFileSpan bAMFileSpan = new BAMFileSpan(new Chunk(this.recordRangeInfo.getTotalReferencesLength(), this.recordRangeInfo.getTotalRecordRangeLength()));
        return this.getIterator(bAMFileSpan);
    }

    @Override
    public void close() {
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public boolean hasBrowseableIndex() {
        return true;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        return this.index;
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan sAMFileSpan) {
        CloseableIterator<SAMRecord> closeableIterator = this.getIterator(sAMFileSpan);
        if (closeableIterator == null) {
            return null;
        }
        return (SAMRecordIterator)closeableIterator;
    }

    @Override
    void enableFileSource(SamReader samReader, boolean bl) {
        log.info("enableFileSource is not supported");
    }

    @Override
    void enableIndexCaching(boolean bl) {
        log.info("enableIndexCaching is not supported");
    }

    @Override
    void enableIndexMemoryMapping(boolean bl) {
        log.info("enableIndexMemoryMapping is not supported");
    }

    @Override
    void enableCrcChecking(boolean bl) {
        log.info("enableCrcChecking is not supported");
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
        log.info("setSAMRecordFactory is not supported");
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    protected SRAIterator.RecordRangeInfo getRecordsRangeInfo() {
        return this.recordRangeInfo;
    }

    private SAMFileHeader loadSamHeader() throws ErrorMsg {
        String string;
        if (this.run == null) {
            throw new RuntimeException("Cannot load SAMFileHeader - SRA run is uninitialized");
        }
        String string2 = this.run.getName();
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        ReadGroupIterator readGroupIterator = this.run.getReadGroups();
        while (readGroupIterator.nextReadGroup()) {
            string = readGroupIterator.getName();
            if (string.isEmpty()) {
                string = string2;
            }
            SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(string);
            sAMReadGroupRecord.setSample(string2);
            sAMFileHeader.addReadGroup(sAMReadGroupRecord);
        }
        string = this.run.getReferences();
        while (string.nextReference()) {
            sAMFileHeader.addSequence(new SAMSequenceRecord(string.getCanonicalName(), (int)string.getLength()));
        }
        return sAMFileHeader;
    }

    private BAMFileSpan getSpanContained(int n, long l, long l2) {
        if (this.recordRangeInfo.getTotalRecordRangeLength() <= 0L) {
            throw new RuntimeException("Cannot create file span - SRA file is empty");
        }
        long l3 = this.recordRangeInfo.getReferenceOffsets().get(n);
        long l4 = this.recordRangeInfo.getReferenceLengthsAligned().get(n);
        if (l2 == -1L) {
            l2 = l4;
        }
        if (l > l4) {
            throw new IllegalArgumentException("Sequence start position is larger than its length");
        }
        if (l2 > l4) {
            throw new IllegalArgumentException("Sequence end position is larger than its length");
        }
        return new BAMFileSpan(new Chunk(l3 + l, l3 + l2));
    }
}

