/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinList;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SRAIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;

public class SRAIndex
implements BrowseableBAMIndex {
    public static final int SRA_BIN_SIZE = 16384;
    public static final int SRA_CHUNK_SIZE = 50000;
    private static final int SRA_BIN_INDEX_OFFSET = GenomicIndexUtil.LEVEL_STARTS[GenomicIndexUtil.LEVEL_STARTS.length - 1];
    private static final int MAX_FRAGMENT_OVERLAP = 5000;
    private SAMFileHeader header;
    private SRAIterator.RecordRangeInfo recordRangeInfo;

    public SRAIndex(SAMFileHeader sAMFileHeader, SRAIterator.RecordRangeInfo recordRangeInfo) {
        this.header = sAMFileHeader;
        this.recordRangeInfo = recordRangeInfo;
    }

    @Override
    public int getLevelSize(int n) {
        if (n == GenomicIndexUtil.LEVEL_STARTS.length - 1) {
            return 37450 - GenomicIndexUtil.LEVEL_STARTS[n] - 1;
        }
        return GenomicIndexUtil.LEVEL_STARTS[n + 1] - GenomicIndexUtil.LEVEL_STARTS[n];
    }

    @Override
    public int getLevelForBin(Bin bin) {
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        return GenomicIndexUtil.LEVEL_STARTS.length - 1;
    }

    @Override
    public int getFirstLocusInBin(Bin bin) {
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        return (bin.getBinNumber() - SRA_BIN_INDEX_OFFSET) * 16384 + 1;
    }

    @Override
    public int getLastLocusInBin(Bin bin) {
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        return (bin.getBinNumber() - SRA_BIN_INDEX_OFFSET + 1) * 16384;
    }

    @Override
    public BinList getBinsOverlapping(int n, int n2, int n3) {
        long l = this.recordRangeInfo.getReferenceLengthsAligned().get(n);
        long l2 = n2 - 1;
        long l3 = n3;
        if (l3 >= l) {
            throw new RuntimeException("refEndPos is larger than reference length");
        }
        int n4 = (int)l2 / 16384;
        int n5 = (int)(l3 - 1L) / 16384;
        int n6 = (int)l / 16384 + 1;
        BitSet bitSet = new BitSet();
        bitSet.set(0, SRA_BIN_INDEX_OFFSET, false);
        if (n4 > 0) {
            bitSet.set(SRA_BIN_INDEX_OFFSET, SRA_BIN_INDEX_OFFSET + n4, false);
        }
        bitSet.set(SRA_BIN_INDEX_OFFSET + n4, SRA_BIN_INDEX_OFFSET + n5 + 1, true);
        if (n5 + 1 < n6) {
            bitSet.set(SRA_BIN_INDEX_OFFSET + n5 + 1, SRA_BIN_INDEX_OFFSET + n6, false);
        }
        return new BinList(n, bitSet);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(Bin bin) {
        return new BAMFileSpan(this.getBinChunks(bin));
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int n, int n2, int n3) {
        BinList binList = this.getBinsOverlapping(n, n2, n3);
        BAMFileSpan bAMFileSpan = new BAMFileSpan();
        HashSet<Chunk> hashSet = new HashSet<Chunk>();
        for (Bin bin : binList) {
            List<Chunk> list = this.getSpanOverlapping(bin).getChunks();
            for (Chunk chunk : list) {
                if (hashSet.contains(chunk)) continue;
                hashSet.add(chunk);
                bAMFileSpan.add(chunk);
            }
        }
        return bAMFileSpan;
    }

    @Override
    public long getStartOfLastLinearBin() {
        int n = this.recordRangeInfo.getReferenceLengthsAligned().size();
        long l = this.recordRangeInfo.getReferenceOffsets().get(n - 1);
        long l2 = this.recordRangeInfo.getReferenceLengthsAligned().get(n - 1) / 50000L;
        return l2 * 50000L + l;
    }

    @Override
    public BAMIndexMetaData getMetaData(int n) {
        throw new UnsupportedOperationException("Getting of BAM index metadata for SRA is not implemented");
    }

    @Override
    public void close() {
    }

    private List<Chunk> getBinChunks(Bin bin) {
        if (bin.containsChunks()) {
            return bin.getChunkList();
        }
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        int n = bin.getBinNumber() - SRA_BIN_INDEX_OFFSET;
        long l = this.recordRangeInfo.getReferenceOffsets().get(bin.getReferenceSequence());
        int n2 = n == 0 ? 0 : -5000;
        long l2 = (long)(n * 16384) + l;
        long l3 = (l2 + (long)n2) / 50000L;
        long l4 = (l2 + 16384L - 1L) / 50000L;
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (long i = l3; i <= l4; ++i) {
            arrayList.add(new Chunk(i * 50000L, (i + 1L) * 50000L));
        }
        return arrayList;
    }
}

