/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.io.File;
import java.io.IOException;

public class SamFiles {
    public static File findIndex(File file) {
        File file2 = SamFiles.lookForIndex(file);
        if (file2 == null) {
            return SamFiles.unsymlinkAndLookForIndex(file);
        }
        return file2;
    }

    private static File unsymlinkAndLookForIndex(File file) {
        try {
            File file2 = file.getCanonicalFile();
            File file3 = SamFiles.lookForIndex(file2);
            if (file3 != null) {
                System.err.println("The index file " + file3.getPath() + " was found by resolving the canonical path of a symlink: " + file.getPath() + " -> " + file.getCanonicalPath());
            }
            return file3;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File lookForIndex(File file) {
        File file2;
        String string = file.getName();
        if (string.endsWith(".bam")) {
            String string2 = string.substring(0, string.length() - ".bam".length()) + ".bai";
            file2 = new File(file.getParent(), string2);
            if (file2.isFile()) {
                return file2;
            }
        } else if (string.endsWith(".cram")) {
            String string3 = string.substring(0, string.length() - ".cram".length()) + ".crai";
            file2 = new File(file.getParent(), string3);
            if (file2.isFile()) {
                return file2;
            }
            file2 = new File(file.getParent(), file.getName() + ".crai");
            if (file2.isFile()) {
                return file2;
            }
        }
        if ((file2 = new File(file.getParent(), file.getName() + ".bai")).isFile()) {
            return file2;
        }
        return null;
    }
}

